#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "serverobject.h"
#include "netconfig.h"
#include "serverdata.h"
#include "scorevals.h"
#include "fileutils.h"


void ReadServerConfig(char *ServerConfigFileName);
void SetServerDefaults();
void ServerAssignValue(char *VariableName, char *value);


char ServerConfigFileName[MAX_FILENAME_SIZE];
char ServerSingleConfigFileName[MAX_FILENAME_SIZE];
int GameSleep;
int ServerGameType;
int ShotKeepAlive;
int ShipDeadTime;
int StartLives;
int MaxKills;
int NumConnectedPlayers;
float ServerWorldWidth;
int StartAsteroids;
int NewAsteroidTime;
int AsteroidTimeSpeedup;
int MinAsteroidTime;
int ServerMaxShield;
int StartShield;
int ServerMaxArmor;
int StartArmor;
int MaxPlayers;
int PacketSize;
int NetSleepTime;
int AsteroidScore;
int ShipScore;
float DecelerationConstant;
float AccelerationConstant;
float ShipSize;
int ShotDamage;
int NukeDamage;
int NukeShieldDrain;
int CollisionDamage;
float ShotSpeed;
float NukeSpeed;
int PowerupAliveTime;
int NukeAliveTime;
int NukeExplosionAliveTime;
float NukeExplosionGrowthSpeed;
int ShotAliveTime;
float MaxTotalAsteroidSize;
int NumBots;
float StartBotRatio;
float MaxBotRatio;
float BotRatioIncrease;
int BotFireTime;
int BotNukeOdds;
int BotShieldTime;
int StartWarps;
int StartNukes;
int PrizeOdds;
int ShieldPowerupValue;
int ArmorPowerupValue;
float RotationSpeed;


void ReadServerConfig(char *ServerConfigFileName)
{
  FILE *ConfigFile;

  SetServerDefaults();

  if (!(ConfigFile=fopen(ServerConfigFileName, "r"))) {
    return;
  }

  ReadVariables(ConfigFile, &ServerAssignValue);

  fclose(ConfigFile);
}


void SetServerDefaults()
{
  ServerWorldWidth=10.0;
  ServerGameType=1;
  GamePort=12346;
  GameSleep=10;
  ServerMaxShield=300;
  StartShield=300;
  ServerMaxArmor=1000;
  StartArmor=1000;
  AsteroidScore=1;
  ShipScore=10;
  NewAsteroidTime=10000;
  AsteroidTimeSpeedup=10;
  MinAsteroidTime=1000;
  StartAsteroids=3;
  StartLives=3;
  MaxKills=20;
  PacketSize=1024;
  DecelerationConstant=0.9;
  AccelerationConstant=0.35;
  ShipSize=0.2;
  ShotDamage=50;
  NukeDamage=350;
  NukeShieldDrain=50;
  CollisionDamage=75;
  ShotSpeed=0.14;
  NukeSpeed=0.14;
  PowerupAliveTime=500;
  ShotAliveTime=50;
  NukeAliveTime=35;
  NukeExplosionAliveTime=40;
  NukeExplosionGrowthSpeed=0.03;
  MaxTotalAsteroidSize=10.0;
  NetSleepTime=50;
  NumBots=0;
  StartBotRatio=0.25;
  MaxBotRatio=1.0;
  BotRatioIncrease=0.002;
  BotFireTime=20;
  BotShieldTime=60;
  BotNukeOdds=5000;
  StartWarps=2;
  StartNukes=2;
  PrizeOdds=512;
  ShieldPowerupValue=50;
  ArmorPowerupValue=50;
  RotationSpeed=1.2;
}


void ServerAssignValue(char *VariableName, char *value)
{
  int temp;

  if (!strcmp(VariableName, "MAX_NUMBER_OF_PLAYERS")) {
    MaxPlayers=atoi(value);
  } else if (!strcmp(VariableName, "GAME_TYPE")) {
    ServerGameType=atoi(value);
  } else if (!strcmp(VariableName, "WORLD_WIDTH")) {
    ServerWorldWidth=strtod(value, NULL);
  } else if (!strcmp(VariableName, "GAME_PORT")) {
    GamePort=atoi(value);
  } else if (!strcmp(VariableName, "SHOT_KEEP_ALIVE")) {
    ShotKeepAlive=atoi(value);
  } else if (!strcmp(VariableName, "SHIP_DEAD_TIME")) {
    ShipDeadTime=atoi(value);
  } else if (!strcmp(VariableName, "START_LIVES")) {
    StartLives=atoi(value);
  } else if (!strcmp(VariableName, "MAX_KILLS")) {
    MaxKills=atoi(value);
  } else if (!strcmp(VariableName, "GAME_SLEEP")) {
    GameSleep=atoi(value);
  } else if (!strcmp(VariableName, "MAX_SHIELD")) {
    ServerMaxShield=atoi(value);
  } else if (!strcmp(VariableName, "START_SHIELD")) {
    StartShield=atoi(value);
  } else if (!strcmp(VariableName, "MAX_ARMOR")) {
    ServerMaxArmor=atoi(value);
  } else if (!strcmp(VariableName, "START_ARMOR")) {
    StartArmor=atoi(value);
  } else if (!strcmp(VariableName, "ASTEROID_SCORE")) {
    AsteroidScore=atoi(value);
  } else if (!strcmp(VariableName, "SHIP_SCORE")) {
    ShipScore=atoi(value);
  } else if (!strcmp(VariableName, "NEW_ASTEROID_TIME")) {
    NewAsteroidTime=atoi(value);
  } else if (!strcmp(VariableName, "ASTEROID_TIME_SPEEDUP")) {
    AsteroidTimeSpeedup=atoi(value);
  } else if (!strcmp(VariableName, "MIN_ASTEROID_TIME")) {
    MinAsteroidTime=atoi(value);
  } else if (!strcmp(VariableName, "START_ASTEROIDS")) {
    StartAsteroids=atoi(value);
  } else if (!strcmp(VariableName, "PACKET_SIZE")) {
    PacketSize=atoi(value);
  } else if (!strcmp(VariableName, "NET_SLEEP_TIME")) {
    NetSleepTime=atoi(value);
  } else if (!strcmp(VariableName, "DECELERATION_CONSTANT")) {
    DecelerationConstant=strtod(value, NULL);
  } else if (!strcmp(VariableName, "ACCELERATION_CONSTANT")) {
    AccelerationConstant=strtod(value, NULL);
  } else if (!strcmp(VariableName, "SHIP_SIZE")) {
    ShipSize=strtod(value, NULL);
  } else if (!strcmp(VariableName, "SHOT_DAMAGE")) {
    ShotDamage=atoi(value);
  } else if (!strcmp(VariableName, "NUKE_DAMAGE")) {
    NukeDamage=atoi(value);
  } else if (!strcmp(VariableName, "NUKE_SHIELD_DRAIN")) {
    NukeShieldDrain=atoi(value);
  } else if (!strcmp(VariableName, "COLLISION_DAMAGE")) {
    CollisionDamage=atoi(value);
  } else if (!strcmp(VariableName, "SHOT_SPEED")) {
    ShotSpeed=strtod(value, NULL);
  } else if (!strcmp(VariableName, "NUKE_SPEED")) {
    NukeSpeed=strtod(value, NULL);
  } else if (!strcmp(VariableName, "POWERUP_ALIVE_TIME")) {
    PowerupAliveTime=atoi(value);
  } else if (!strcmp(VariableName, "NUKE_ALIVE_TIME")) {
    NukeAliveTime=atoi(value);
  } else if (!strcmp(VariableName, "NUKE_EXPLOSION_ALIVE_TIME")) {
    NukeExplosionAliveTime=atoi(value);
  } else if (!strcmp(VariableName, "NUKE_EXPLOSTION_GROWTH_SPEED")) {
    NukeSpeed=strtod(value, NULL);
  } else if (!strcmp(VariableName, "SHOT_ALIVE_TIME")) {
    ShotAliveTime=atoi(value);
  } else if (!strcmp(VariableName, "MAX_TOTAL_ASTEROID_SIZE")) {
    MaxTotalAsteroidSize=strtod(value, NULL);
  } else if (!strcmp(VariableName, "NUM_BOTS")) {
    NumBots=atoi(value);
  } else if (!strcmp(VariableName, "START_BOT_RATIO")) {
    StartBotRatio=strtod(value, NULL);
  } else if (!strcmp(VariableName, "MAX_BOT_RATIO")) {
    MaxBotRatio=strtod(value, NULL);
  } else if (!strcmp(VariableName, "BOT_RATIO_INCREASE")) {
    BotRatioIncrease=strtod(value, NULL);
  } else if (!strcmp(VariableName, "BOT_FIRE_TIME")) {
    BotFireTime=atoi(value);
  } else if (!strcmp(VariableName, "BOT_NUKE_ODDS")) {
    BotNukeOdds=atoi(value);
  } else if (!strcmp(VariableName, "BOT_SHIELD_TIME")) {
    BotShieldTime=atoi(value);
  } else if (!strcmp(VariableName, "START_WARPS")) {
    StartWarps=atoi(value);
  } else if (!strcmp(VariableName, "START_NUKES")) {
    StartNukes=atoi(value);
  } else if (!strcmp(VariableName, "PRIZE_ODDS")) {
    PrizeOdds=atoi(value);
  } else if (!strcmp(VariableName, "SHIELD_POWERUP_VALUE")) {
    ShieldPowerupValue=atoi(value);
  } else if (!strcmp(VariableName, "ARMOR_POWERUP_VALUE")) {
    ArmorPowerupValue=atoi(value);
  } else if (!strcmp(VariableName, "ROTATION_SPEED")) {
    RotationSpeed=strtod(value, NULL);
  }
}
