#include <math.h>


#include "globals.h"


class ServerObject {

public:
  struct Point Position;
  struct Point Velocity;
  struct Point Rotation;
  float RotationMatrix[3][3];
  int ObjectType;
  float ObjectSize;
  float ObjectMass;
  int AliveTime;
  int GravityStrength;
  int Weight;
  int HitPoints;
  int PlayerNum;
  int PlayersHit[MAX_PLAYERS];

  ServerObject(struct Point Pos, struct Point Vel, struct Point Rot,
               int Type, float Size, float Mass, int playernum=0);

  ~ServerObject();

  void CalcRotationMatrix();

  void UpdatePosition();

  void UpdateRotation();
};


extern ServerObject *ServerObjects[MAX_OBJECTS];
