#include "serverobject.h"
#include "matrix.h"


class ServerShip:public ServerObject {

public:
  float InvRotationMatrix[3][3];
  struct PlayerActionStruct Action;
  struct Point Acceleration;
  float xAcceleration, yAcceleration, zAcceleration;
  float ShotPos;
  int Score;
  int Lives;
  int Shield;
  int Armor;
  int ShakeTime;
  char PlayerName[MAX_PLAYERNAME_LENGTH];
  int Bot;
  int NextBotFireTime;
  int BotShieldOnTime;
  int WarpTime;
  int Warps;
  int Nukes;

  ServerShip(struct Point Pos, struct Point Vel, struct Point Rot, int Type, float Size, float Mass, int playernum, char *playername, int bot=0);

  ~ServerShip();

  void InitPlayer();

  void UpdateRotation();

  void UpdateVelocity();

  void Accelerate(int type, float Accelerate);

  void CalcAcceleration();

  void die();

  void live();

  void FireShot();

  void FireNuke();

  void DoUpdates();

  int TakeDamage(int DamageAmount);

  void CalcBotRotation();

  int FindClosestShip(float *Distance);

  int FindClosestObject(float *Distance);

  void CalcShipRelPosition(ServerObject *Obj, struct Point *relPosition);

  void IncreaseArmor(int ArmorAmount);

  void IncreaseShield(int ShieldAmount);

  void DecreaseShield(int ShieldAmount);

  void WarpShip();
};

extern ServerShip *ServerShips[MAX_PLAYERS];
