#include "globals.h"
#include "sizes.h"
#include "radar.h"
#include "object.h"
#include "ship.h"
#include "screen.h"


int ShowScore;
unsigned int MaxShield;
unsigned int MaxArmor;


int ScoreCompare(const void *value1, const void *value2);


// Function to draw the status on the bottom of the screen
void DrawStatus()
{
  char text[50];
  int pos;
  int i, j;
  int n=0;
  int tempval;
  int ShieldLength, ArmorLength;
  struct Color *textcolor;
  int ScoreDisplayOrder[MAX_PLAYERS];

  InitMatrixMode();

  if (Ships[myShip]->Lives) {
    sprintf(text, "Score:  %d", Ships[myShip]->Score);
    DrawText(10, ScreenHeight-20, text, &Green);

    if (GameType!=DEATHMATCH) { 
      sprintf(text, "Lives:  %d", Ships[myShip]->Lives);
      DrawText(10, ScreenHeight-35, text, &Green);
    }
    sprintf(text, "HyperWarps:  %d", Ships[myShip]->Warps);
    DrawText(ScreenWidth-100, ScreenHeight-20, text, &Green);
    sprintf(text, "Nukes:  %d", Ships[myShip]->Nukes);
    DrawText(ScreenWidth-100, ScreenHeight-35, text, &Green);

    if (GameType!=SINGLE_PLAYER && (ShowScore || !GameRunning)) {
      for (i=0; i<MAX_PLAYERS; i++) {
        ScoreDisplayOrder[i]=i;
      }

      qsort(ScoreDisplayOrder, MAX_PLAYERS, sizeof(int), ScoreCompare);

      for (i=0; i<MAX_PLAYERS-1; i++) {
        for (j=i; j<MAX_PLAYERS-1; j++) {
        }
      }

      for (i=0; i<MAX_PLAYERS; i++) {
        if (Ships[ScoreDisplayOrder[i]]) {
          sprintf(text, "%s Score: %d", Ships[ScoreDisplayOrder[i]]->PlayerName, Ships[ScoreDisplayOrder[i]]->Score);
          if (ScoreDisplayOrder[i]==myShip) {
            textcolor=&Red;
          } else {
            textcolor=&Blue;
          }
          DrawText(ScreenWidth/2-7, ScreenHeight-20*n-80, text, textcolor);
          n++;
        }
      }
      if (!GameRunning) {
        sprintf(text, "Game Over");
        DrawText(ScreenWidth/2-7, ScreenHeight-40, text, &Blue);
      }
    }
    sprintf(text, "Shield: ");
    pos=DrawText(10, 10, text, &Green)+5;
    DrawLine(pos, 18, pos, 9, &White);
    DrawLine(pos, 9, pos+40, 9, &White);
    DrawLine(pos+40, 9, pos+40, 18, &White);
    DrawLine(pos+40, 18, pos, 18, &White);
    if (Ships[myShip]->Shield) {
      ShieldLength=(38*Ships[myShip]->Shield)/MaxShield;
      DrawRect(pos+1, 10, pos+1, 17, pos+1+ShieldLength, 17,
               pos+1+ShieldLength, 10, &Blue);
    }
    sprintf(text, "Armor: ");
    pos=DrawText(ScreenWidth-100, 10, text, &Green)+5;
    DrawLine(pos, 18, pos, 9, &White);
    DrawLine(pos, 9, pos+40, 9, &White);
    DrawLine(pos+40, 9, pos+40, 18, &White);
    DrawLine(pos+40, 18, pos, 18, &White);
    if (Ships[myShip]->Armor) {
      ArmorLength=(38*Ships[myShip]->Armor)/MaxArmor;
      DrawRect(pos+1, 10, pos+1, 17, pos+1+ArmorLength, 17,
               pos+1+ArmorLength, 10, &Blue);
    }

  } else {
    sprintf(text, "Game Over");
    DrawText(ScreenWidth/2-7, ScreenHeight/2+20, text, &Blue);
    if (GameType!=SINGLE_PLAYER) {
      /*      for (i=0; i<NumPlayers; i++) {
              if (Ships[i]->Connected) {
              sprintf(text, "%s Score: %d", Ships[i]->ShipName, Ships[i]->score);
              DrawText(ScreenWidth/2-7, ScreenHeight/2-20*i, text, &Blue);
              }
              }*/
    } else {
      sprintf(text, "Player Score: %d", Ships[myShip]->Score);
      DrawText(ScreenWidth/2-7, ScreenHeight/2, text, &Blue);
      sprintf(text, "Press Fire key to continue");
      DrawText(ScreenWidth/2-7, ScreenHeight/2-20, text, &Blue);
    }
  }

  DrawRadar();

  SetupGameMatrixMode();
}


int ScoreCompare(const void *value1, const void *value2)
{
  if (Ships[*(int *)value1] && Ships[*(int *)value2]) {
    if (Ships[*(int *)value1]->Score < Ships[*(int *)value2]->Score) {
      return(1);
    } else if (Ships[*(int *)value2] &&
               !Ships[*(int *)value1]) {
      return(1);
    }
  }
  return(-1);
}
