/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lbking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpainter.h>
//#include <qpalette.h> 
#include <qsettings.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <qpixmap.h>

#include <kapplication.h>
#include <kcolorbutton.h>
#include <kimageeffect.h>
#include <klocale.h>
#include <kglobal.h>
#include <kparts/genericfactory.h>

#include "kstyle_baghira_config.h"
//#include "icon.h"
#include "preview.h"

#define _ENDIAN_ QImage::LittleEndian
//#define _ENDIAN_ QImage::BigEndian

#define CLAMP(x,l,u) x < l ? l :\
		     x > u ? u :\
		     x

#define SATURATION_COLOR(/*S,*/R,G,B) \
    grey = (299 * R + 587 * G + 114 * B) / 1000; \
    delta = 255 - grey; \
    grey = (grey *(10 - 5)) / 10; \
    iGrey = 255 - grey;\
    destR = (iGrey * (srcR - delta) + grey * R) / 255; \
    destG = (iGrey * (srcG - delta) + grey * G) / 255; \
    destB = (iGrey * (srcB - delta) + grey * B) / 255; 

#define SATURATION_COLOR2(S,R,G,B) \
   int max = 255+0.65*(100-S); \
   destR = CLAMP((srcR + R - 128), 0, max); \
   destG = CLAMP((srcG + G - 128), 0, max); \
   destB = CLAMP((srcB + B - 128), 0, max); \
   destR = (S*destR + (100-S)*R)/100; \
   destG = (S*destG + (100-S)*G)/100; \
   destB = (S*destB + (100-S)*B)/100;
   
#define COLOR_SPACE(R,G,B) \
    if ( R < 0 ) R = 0; else if ( R > 255 ) R = 255; \
    if ( G < 0 ) G = 0; else if ( G > 255 ) G = 255; \
    if ( B < 0 ) B = 0; else if ( B > 255 ) B = 255;

/*
  Internal class to get access to protected About members (to keep About itself autogeneratable)
*/
class AboutAccess : public About
{
    friend class kstyle_baghira_config;
public:
    AboutAccess( QWidget* parent=0, const char* name=0, WFlags f = 0 )
	: About( parent, name, false, f ){}
};


void kstyle_baghira_config::slotMenuEffectSpeedChanged(int id)
{
   dialog_->menuEffectSpeedIndicator->setNum(id);
   emit changed(true);
}

void kstyle_baghira_config::openHtml1()
{
   QStringList args;
   args << "exec" << "http://www.sf.net/projects/baghira/";
   kapp->kdeinitExec("kfmclient", args);
}

void kstyle_baghira_config::openHtml2()
{
   QStringList args;
   args << "exec" << "http://www.sf.net/projects/baghira/files/";
   kapp->kdeinitExec("kfmclient", args);
}

void kstyle_baghira_config::startBab()
{
   kapp->kdeinitExec("bab");
}

QImage* kstyle_baghira_config::tintButton(QImage &src, QColor c)
{
    QImage *dest = new QImage( src.width(), src.height(), 32, 0, _ENDIAN_ );
    dest->setAlphaBuffer( true );
    unsigned int *data = ( unsigned int * ) src.bits();
    unsigned int *destData = ( unsigned int* ) dest->bits();
    int total = src.width() * src.height();
    int red, green, blue;
    int destR, destG, destB, alpha;
    int srcR = c.red();
    int srcG = c.green();
    int srcB = c.blue();
    int hue, s, v;
    c.getHsv( &hue, &s, &v );
    int sq = CLAMP((int)((45.0/128.0)*s+55),0,100);
    // float srcPercent, destPercent;
    for ( int current = 0 ; current < total ; ++current ) {
    	alpha = qAlpha( data[ current ] );
    	red = qRed( data[ current ] );
    	green = qGreen( data[ current ] );
	blue = qBlue( data[ current ] );
	SATURATION_COLOR2(sq, red, green, blue);
	// force back to valid colorspace !
	COLOR_SPACE(destR, destG, destB);
	destData[ current ] = qRgba( destR, destG, destB, alpha );
    }
    return ( dest );
}

QImage* kstyle_baghira_config::tintBrush( QImage &img, QColor c/*, int saturation */)
{
    QImage *dest = new QImage( img.width(), img.height(), 32, 0, _ENDIAN_ );
    unsigned int *data = ( unsigned int * ) img.bits();
    unsigned int *destData = ( unsigned int* ) dest->bits();
    int total = img.width() * img.height();
    int current;
    int delta, uplight;
    int red, green, blue, grey, iGrey;
    int destR, destG, destB, alpha;
 
    int srcR = c.red();
    int srcG = c.green();
    int srcB = c.blue();
    
    
    // float srcPercent, destPercent;
    for ( current = 0 ; current < total ; ++current ) {
    	alpha = qAlpha( data[ current ] );
    	red = qRed( data[ current ] );
    	green = qGreen( data[ current ] );
	blue = qBlue( data[ current ] );
	SATURATION_COLOR(/*saturation,*/ red, green, blue);
	// force back to valid colorspace !
	COLOR_SPACE(destR, destG, destB);
	destData[ current ] = qRgba( destR, destG, destB, alpha );
    }
    return ( dest );
}

void kstyle_baghira_config::sliderButtonRedChanged(int value)
{
	sliderButtonRedValue = value;
	dialog_->valueButtonRed->setNum(value);
	dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
	dialog_->pixmapButtonPreview->repaint(false);
}

void kstyle_baghira_config::sliderButtonGreenChanged(int value)
{
	sliderButtonGreenValue = value;
	dialog_->valueButtonGreen->setNum(value);
	dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
	dialog_->pixmapButtonPreview->repaint(false);
}

void kstyle_baghira_config::sliderButtonBlueChanged(int value)
{
	sliderButtonBlueValue = value;
	dialog_->valueButtonBlue->setNum(value);
	dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
	dialog_->pixmapButtonPreview->repaint(false);
}

void kstyle_baghira_config::sliderBrushRedChanged(int value)
{
	sliderBrushRedValue = value;
	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/)));
	dialog_->pixmapBrushPreview->repaint(false);
	emit changed(true);
}

void kstyle_baghira_config::sliderBrushGreenChanged(int value)
{
	sliderBrushGreenValue = value;
	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/)));
	dialog_->pixmapBrushPreview->repaint(false);
	emit changed(true);
}

void kstyle_baghira_config::sliderBrushBlueChanged(int value)
{
	sliderBrushBlueValue = value;
	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/)));
	dialog_->pixmapBrushPreview->repaint(false);
	emit changed(true);
}

// void kstyle_baghira_config::sliderBrushSaturationChanged(int value)
// {
// 	sliderBrushSaturationValue = value;
// 	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue), sliderBrushSaturationValue));
// 	dialog_->pixmapBrushPreview->repaint(false);
// 	emit changed(true);
// }

typedef KGenericFactory<kstyle_baghira_config, QWidget> kstyle_baghira_configFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kstyle_baghira_config, kstyle_baghira_configFactory("kcmkstyle_baghira_config"))

kstyle_baghira_config::kstyle_baghira_config(QWidget *parent, const char *name, const QStringList&)
    : QWidget(parent, name )//, myAboutData(0)
{
    if (parent) parent->setCaption("Configure Your Cat");
    QVBoxLayout *layout = new QVBoxLayout(this);
    dialog_ = new Config(this);
    // preview stuff
    baseImage = baghira_findImage("button-base");
    
    layout->addWidget(dialog_);
    
    dialog_->show();
    help_ = new Help(dialog_);
    about_ = new About(dialog_);
    
    // get some nicer pix =)
    QLabel* icon = new QLabel( about_ );
    QPixmap blendPixmap(130,134);
    if (about_->paletteBackgroundPixmap()){
       QPainter p(&blendPixmap);
       p.drawTiledPixmap(0,0, 130, 134, *about_->paletteBackgroundPixmap());
    }
    else 
       blendPixmap.fill(about_->paletteBackgroundColor());
    QImage blendImage = blendPixmap.convertToImage();
    blendImage.convertDepth(32);
    QImage iconImage = baghira_findImage( "AboutBaghira" );
    icon->setPixmap( KImageEffect::blend( blendImage, iconImage, 0.0f));
//    icon->setCursor( QCursor( 13 ) );
//    icon->setMouseTracking( TRUE );
    ((AboutAccess*)about_)->layout4->addWidget( icon );
    QSpacerItem* spacer_2 = new QSpacerItem( 121, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    ((AboutAccess*)about_)->layout4->addItem( spacer_2 );
    about_->setFixedSize (380, 430);
    
    // load settings
    load();
    
    dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
    
    // connections
    connect(dialog_->buttonHelp, SIGNAL(clicked()), 
             help_, SLOT(exec()));
    connect(dialog_->buttonAbout, SIGNAL(clicked()),
             about_, SLOT(exec()));
    connect(about_->buttonInfo, SIGNAL(clicked()),
             this, SLOT(openHtml1()));
    connect(about_->buttonDownload, SIGNAL(clicked()),
             this, SLOT(openHtml2()));
    connect(help_->startBAB, SIGNAL(clicked()),
             this, SLOT(startBab()));
    connect(dialog_->defaultStyle, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->stippleBackground, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->bevelHighlights, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->stippleContrast, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowGroups,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowIntensity, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->centerTabs,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useRectButtons,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->colorMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->inactiveColorType, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->animateSlider,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowSlider,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->squeezeSlider,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->roundToolButtons,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->unhoveredToolButtons,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->drawTreeLines,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomExpanderColor,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));             
     connect(dialog_->treeLineMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
     connect(dialog_->expanderMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomExpanderColor,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useRectLVH,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->stippleKicker,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->removeKickerBevel,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->roundTasks,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomKickerColor,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->showProgressValue,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
     connect(dialog_->progressType, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
     connect(dialog_->menuTranslucencyStyle, SIGNAL(activated(int)),
             this, SLOT(configChanged()));             
    connect(dialog_->menuTranslucencyOpacity, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->menuDropShadowIntensity, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->useMenuDropShadows,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
     connect(dialog_->menuEffect, SIGNAL(activated(int)),
             this, SLOT(configChanged()));      
    connect(dialog_->menuEffectSpeed, SIGNAL(valueChanged (int)),
             this, SLOT(slotMenuEffectSpeedChanged(int)));
    connect(dialog_->stippleMenus,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowMenuText, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
     connect(dialog_->menuColorMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->menuDropShadowSize, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomColors, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
             
     connect(dialog_->customInactiveColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->treeLineColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->customExpanderColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->customKickerColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->menuTextColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->menuColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->radioOffColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->radioOnColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->checkOffColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->checkOnColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->sliderColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->hoverSliderColorColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->pressedSliderColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->inactiveTabColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->activeTabColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
	     
     connect(dialog_->sliderButtonRed, SIGNAL(valueChanged (int)),
             this, SLOT(sliderButtonRedChanged(int)));
     connect(dialog_->sliderButtonGreen, SIGNAL(valueChanged (int)),
             this, SLOT(sliderButtonGreenChanged(int)));
     connect(dialog_->sliderButtonBlue, SIGNAL(valueChanged (int)),
             this, SLOT(sliderButtonBlueChanged(int)));    

     connect(dialog_->sliderBrushRed, SIGNAL(valueChanged (int)),
             this, SLOT(sliderBrushRedChanged(int)));
     connect(dialog_->sliderBrushGreen, SIGNAL(valueChanged (int)),
             this, SLOT(sliderBrushGreenChanged(int)));
     connect(dialog_->sliderBrushBlue, SIGNAL(valueChanged (int)),
             this, SLOT(sliderBrushBlueChanged(int)));   
//      connect(dialog_->sliderBrushSaturation, SIGNAL(valueChanged (int)),
//              this, SLOT(sliderBrushSaturationChanged(int)));
	     
    /*QGroupBox* transGroup;
    QGroupBox* shadowBox;
    QGroupBox* effectBox;*/

};


kstyle_baghira_config::~kstyle_baghira_config()
{
}


void kstyle_baghira_config::load()
{
   QSettings settings;
   // general Design
    dialog_->defaultStyle->setCurrentItem(settings.readNumEntry("/qt/BAB/defaultState", 0 ));
    dialog_->stippleBackground->setChecked( settings.readBoolEntry( "/qt/Baghira/stippleBackground", true));
    dialog_->stippleContrast->setValue( settings.readNumEntry( "/qt/Baghira/stippleContrast", 30));
    dialog_->shadowGroups->setChecked( settings.readBoolEntry( "/qt/Baghira/useGroupShadows", true));
    dialog_->shadowIntensity->setValue( settings.readNumEntry( "/qt/Baghira/shadowDarkness", 50));
    dialog_->bevelHighlights->setChecked( settings.readBoolEntry( "/qt/Baghira/bevelHighlights", true));
    dialog_->colorMode->setCurrentItem(settings.readBoolEntry("/qt/Baghira/icyButtons", true) ? 0 : 1);
    dialog_->inactiveColorType->setCurrentItem(settings.readNumEntry( "/qt/Baghira/inactiveButtonColor", 1));
    dialog_->customInactiveColor->setColor(QColor(settings.readNumEntry("/qt/Baghira/customInactiveButtonColor",(int)colorGroup().background().rgb())));
    dialog_->useRectButtons->setChecked( settings.readBoolEntry( "/qt/Baghira/forceRectButtons", false));
    dialog_->centerTabs->setChecked( settings.readBoolEntry( "/qt/Baghira/centerTabs", true));
    // button color stuff
    QColor tmpColor = QColor(settings.readNumEntry("/qt/Baghira/buttonColor",(int)colorGroup().button().rgb()));
    dialog_->sliderButtonRed->setValue(sliderButtonRedValue = tmpColor.red());
    dialog_->sliderButtonGreen->setValue(sliderButtonGreenValue = tmpColor.green());
    dialog_->sliderButtonBlue->setValue(sliderButtonBlueValue = tmpColor.blue());
    dialog_->valueButtonRed->setNum(sliderButtonRedValue);
    dialog_->valueButtonGreen->setNum(sliderButtonGreenValue);
    dialog_->valueButtonBlue->setNum(sliderButtonBlueValue);
    
    // special Widgets
//    dialog_->animateSlider;
    //ListViews
    dialog_->useRectLVH->setChecked( !settings.readBoolEntry( "/qt/Baghira/smoothListViewHeaders", false));
    dialog_->drawTreeLines->setChecked( settings.readBoolEntry( "/qt/Baghira/drawDotlines", false));
    dialog_->treeLineMode->setCurrentItem(settings.readNumEntry( "/qt/Baghira/dotlineStyle", 0));
    dialog_->treeLineColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/dotlineColor", (int) colorGroup().mid().rgb())));
    dialog_->expanderMode->setCurrentItem(settings.readNumEntry( "/qt/Baghira/expanderStyle", 0));
    dialog_->useCustomExpanderColor->setChecked( settings.readBoolEntry( "/qt/Baghira/useCustomExpanderColor", false));
    dialog_->customExpanderColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/expanderColor", (int) colorGroup().text().rgb())));
    //Kicker
    dialog_->stippleKicker->setChecked( settings.readBoolEntry( "/qt/Baghira/stipplePanel", true));
    dialog_->removeKickerBevel->setChecked( settings.readBoolEntry( "/qt/Baghira/removeKickerBevel", true));
    dialog_->roundTasks->setChecked( settings.readBoolEntry( "/qt/Baghira/smootherLVH", false));
    dialog_->useCustomKickerColor->setChecked( settings.readBoolEntry( "/qt/Baghira/useCustomPanelColor", false));
    dialog_->customKickerColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customPanelColor", (int) colorGroup().background().rgb())));
    //Scrollbars
    dialog_->animateSlider->setChecked( settings.readBoolEntry( "/qt/Baghira/animateSlider", true));
    dialog_->shadowSlider->setChecked( settings.readBoolEntry( "/qt/Baghira/shadowSbSlider", false));
    dialog_->squeezeSlider->setChecked( settings.readBoolEntry( "/qt/Baghira/squeezeSbSlider", false));
    //Progress
    dialog_->progressType->setCurrentItem( settings.readNumEntry( "/qt/Baghira/progressBar", 0));
    dialog_->showProgressValue->setChecked( settings.readBoolEntry( "/qt/Baghira/drawProgressLabel", false));
    //Toolbars
    dialog_->roundToolButtons->setChecked( settings.readBoolEntry( "/qt/Baghira/smoothToolbuttons", true));
    dialog_->unhoveredToolButtons->setChecked( settings.readBoolEntry( "/qt/Baghira/drawToolbarButtonFrames", false));
    
    // menus
    //Translucency
//    dialog_->transGroup;
    dialog_->menuTranslucencyStyle->setCurrentItem( settings.readNumEntry( "/qt/Baghira/menuTranslucency", 1));
    dialog_->menuTranslucencyOpacity->setValue( settings.readNumEntry( "/qt/Baghira/customMenuOpacity", 50));
    //Look
//    dialog_->shadowBox;
    dialog_->stippleMenus->setChecked( settings.readBoolEntry( "/qt/Baghira/stippleMenu", true));
    dialog_->shadowMenuText->setChecked( settings.readBoolEntry( "/qt/Baghira/shadowedText", true));
    dialog_->menuColorMode->setCurrentItem(settings.readBoolEntry("/qt/Baghira/menuColorButton") ? 1 : 
    					   settings.readBoolEntry("/qt/Baghira/useCustomMenuStyle") ? 2 : 0 );
    dialog_->menuTextColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customMenuTextColor", (int) colorGroup().text().rgb())));
    dialog_->menuColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customMenuColor", (int) colorGroup().button().rgb())));
    //Effect
    dialog_->menuEffect->setCurrentItem( settings.readNumEntry( "/qt/Baghira/menuAnimation", 1));
    dialog_->menuEffectSpeed->setValue(settings.readNumEntry( "/qt/Baghira/menuAnimationSpeed", 20));
    dialog_->menuEffectSpeedIndicator->setNum(dialog_->menuEffectSpeed->value());
    //Shadows
    dialog_->useMenuDropShadows->setChecked( settings.readBoolEntry( "/qt/Baghira/menuDropShadows", true));
    dialog_->menuDropShadowSize->setValue(settings.readNumEntry( "/qt/Baghira/shadowOffset", 8));
    dialog_->menuDropShadowIntensity->setValue(settings.readNumEntry( "/qt/Baghira/dropShadowDarkness", 2));
//    dialog_->effectBox;

    // custom colors
    dialog_->useCustomColors->setChecked( settings.readBoolEntry( "/qt/Baghira/useCustomWidgetColor", false));
    dialog_->radioOffColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customRadioOffColor", ( int ) colorGroup().background().rgb())));
    dialog_->radioOnColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customRadioOnColor", ( int ) colorGroup().button().rgb())));
    dialog_->checkOffColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customCheckOffColor", ( int ) colorGroup().background().rgb())));
    dialog_->checkOnColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customCheckOnColor", ( int ) colorGroup().button().rgb())));
    dialog_->sliderColor->setColor( QColor( settings.readNumEntry( "/qt/Baghira/customSliderColor", ( int ) colorGroup().button().rgb())));
    dialog_->hoverSliderColorColor->setColor(QColor(settings.readNumEntry("/qt/Baghira/customHoveredSliderColor",(int)colorGroup().button().rgb())));
    dialog_->pressedSliderColor->setColor(QColor(settings.readNumEntry("/qt/Baghira/customPressedSliderColor",(int) colorGroup().button().dark(110).rgb())));
    dialog_->sliderGrooveColor->setColor(QColor(settings.readNumEntry("/qt/Baghira/customSliderGrooveColor",(int)colorGroup().background().rgb())));
    dialog_->inactiveTabColor->setColor(QColor(settings.readNumEntry("/qt/Baghira/customInactiveTabColor",(int) colorGroup().background().rgb())));
    dialog_->activeTabColor->setColor(QColor(settings.readNumEntry("/qt/Baghira/customActiveTabColor",(int)colorGroup().button().rgb())));
    dialog_->tintBrush->setChecked( settings.readBoolEntry( "/qt/Baghira/tintBrush", false));
    brushTint = QColor(settings.readNumEntry("/qt/Baghira/brushTint",(int)colorGroup().background().rgb()));
//    dialog_->brushTintSaturaion->setValue(settings.readNumEntry( "/qt/Baghira/brushTintSaturation", 3));
    baseImage2 = baghira_findImage("brush-me");
    dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, brushTint));
    dialog_->sliderBrushRed->setValue(sliderBrushRedValue = brushTint.red());
    dialog_->sliderBrushGreen->setValue(sliderBrushGreenValue = brushTint.green());
    dialog_->sliderBrushBlue->setValue(sliderBrushBlueValue = brushTint.blue());


}


void kstyle_baghira_config::defaults()
{
    dialog_->defaultStyle->setCurrentItem(0);
    dialog_->stippleBackground->setChecked( true);
    dialog_->stippleContrast->setValue( 30);
    dialog_->shadowGroups->setChecked( true);
    dialog_->shadowIntensity->setValue( 50);
    dialog_->bevelHighlights->setChecked( true );
    dialog_->centerTabs->setChecked( true);
    dialog_->useRectButtons->setChecked( false);
    dialog_->colorMode->setCurrentItem(0);
    dialog_->inactiveColorType->setCurrentItem(1);
    dialog_->customInactiveColor->setColor(colorGroup().background().rgb());
    // button color stuff
    dialog_->sliderButtonRed->setValue(sliderButtonRedValue = colorGroup().button().red());
    dialog_->sliderButtonGreen->setValue(sliderButtonGreenValue = colorGroup().button().green());
    dialog_->sliderButtonBlue->setValue(sliderButtonBlueValue = colorGroup().button().blue());
    dialog_->valueButtonRed->setNum(sliderButtonRedValue);
    dialog_->valueButtonGreen->setNum(sliderButtonGreenValue);
    dialog_->valueButtonBlue->setNum(sliderButtonBlueValue);
    
    // special Widgets
//    dialog_->animateSlider;
    dialog_->shadowSlider->setChecked( false);
    dialog_->squeezeSlider->setChecked( false);
    dialog_->roundToolButtons->setChecked( true);
    dialog_->unhoveredToolButtons->setChecked( false);
    dialog_->drawTreeLines->setChecked( false);
    dialog_->useCustomExpanderColor->setChecked( false);
    dialog_->treeLineMode->setCurrentItem(0);
    dialog_->treeLineColor->setColor( colorGroup().mid().rgb());
    dialog_->expanderMode->setCurrentItem(0);
    dialog_->customExpanderColor->setColor( colorGroup().text().rgb());
    dialog_->useRectLVH->setChecked( false);
    dialog_->stippleKicker->setChecked( true);
    dialog_->removeKickerBevel->setChecked( true);
    dialog_->roundTasks->setChecked( false);
    dialog_->useCustomKickerColor->setChecked( false);
    dialog_->customKickerColor->setColor( colorGroup().background().rgb());
    dialog_->showProgressValue->setChecked( false);
    dialog_->progressType->setCurrentItem( 0);
    
    // menus
//    dialog_->transGroup;
    dialog_->menuTranslucencyStyle->setCurrentItem( 1);
    dialog_->menuTranslucencyOpacity->setValue( 50);
//    dialog_->shadowBox;
    dialog_->menuDropShadowSize->setValue(8);
    dialog_->menuDropShadowIntensity->setValue(2);
    dialog_->useMenuDropShadows->setChecked( true);
//    dialog_->effectBox;
    dialog_->menuEffect->setCurrentItem( 1);
    dialog_->menuEffectSpeed->setValue(20);
    dialog_->stippleMenus->setChecked( true);
    dialog_->shadowMenuText->setChecked( true);
    dialog_->menuColorMode->setCurrentItem(0);
    dialog_->menuTextColor->setColor( colorGroup().text().rgb());
    dialog_->menuColor->setColor( colorGroup().button().rgb());
    
    // custom colors
    dialog_->useCustomColors->setChecked( false);
    dialog_->radioOffColor->setColor( colorGroup().background().rgb());
    dialog_->radioOnColor->setColor( colorGroup().button().rgb());
    dialog_->checkOffColor->setColor( colorGroup().background().rgb());
    dialog_->checkOnColor->setColor( colorGroup().button().rgb());
    dialog_->sliderColor->setColor( colorGroup().button().rgb());
    dialog_->hoverSliderColorColor->setColor(colorGroup().button().rgb());
    dialog_->pressedSliderColor->setColor(colorGroup().button().dark(110).rgb());
    dialog_->sliderGrooveColor->setColor(colorGroup().background().rgb());
    dialog_->inactiveTabColor->setColor(colorGroup().background().rgb());
    dialog_->activeTabColor->setColor(colorGroup().button().rgb());
    dialog_->tintBrush->setChecked( false);
    emit changed(true);
}


void kstyle_baghira_config::save()
{
    QSettings *settings = new QSettings;
    //General Design
    settings->writeEntry("/qt/BAB/defaultState", dialog_->defaultStyle->currentItem());
    settings->writeEntry("/qt/Baghira/brushMe", dialog_->defaultStyle->currentItem() == 1);
    settings->writeEntry("/qt/Baghira/stippleBackground", dialog_->stippleBackground->isOn());
    settings->writeEntry("/qt/Baghira/stippleContrast", dialog_->stippleContrast->value());
    settings->writeEntry("/qt/Baghira/useGroupShadows", dialog_->shadowGroups->isOn());
    settings->writeEntry("/qt/Baghira/shadowDarkness", dialog_->shadowIntensity->value());
    settings->writeEntry("/qt/Baghira/bevelHighlights", dialog_->bevelHighlights->isOn());
    settings->writeEntry("/qt/Baghira/icyButtons", dialog_->colorMode->currentItem() == 0);
    settings->writeEntry("/qt/Baghira/inactiveButtonColor", dialog_->inactiveColorType->currentItem());
    settings->writeEntry("/qt/Baghira/customInactiveButtonColor", (int)dialog_->customInactiveColor->color().rgb());
    settings->writeEntry("/qt/Baghira/centerTabs", dialog_->centerTabs->isOn());
    settings->writeEntry("/qt/Baghira/forceRectButtons", dialog_->useRectButtons->isOn());
    //button color stuff
    settings->writeEntry("/qt/Baghira/buttonColor", (int)(QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue).rgb()));
    
    // special Widgets
    //listviews
//    dialog_->animateSlider;
    settings->writeEntry("/qt/Baghira/smoothListViewHeaders", !dialog_->useRectLVH->isOn());
    settings->writeEntry("/qt/Baghira/drawDotlines", dialog_->drawTreeLines->isOn());
    settings->writeEntry("/qt/Baghira/dotlineStyle", dialog_->treeLineMode->currentItem());
    settings->writeEntry("/qt/Baghira/dotlineColor", (int)dialog_->treeLineColor->color().rgb());
    settings->writeEntry("/qt/Baghira/expanderStyle", dialog_->expanderMode->currentItem());
    settings->writeEntry("/qt/Baghira/useCustomExpanderColor", dialog_->useCustomExpanderColor->isOn());
    settings->writeEntry("/qt/Baghira/expanderColor", (int)dialog_->customExpanderColor->color().rgb());
    //Kicker
    settings->writeEntry("/qt/Baghira/stipplePanel", dialog_->stippleKicker->isOn());
    settings->writeEntry("/qt/Baghira/removeKickerBevel", dialog_->removeKickerBevel->isOn());
    settings->writeEntry("/qt/Baghira/smootherLVH", dialog_->roundTasks->isOn());
    settings->writeEntry("/qt/Baghira/useCustomPanelColor", dialog_->useCustomKickerColor->isOn());
    settings->writeEntry("/qt/Baghira/customPanelColor", (int)dialog_->customKickerColor->color().rgb());
    //Srollbars
    settings->writeEntry("/qt/Baghira/animateSlider", dialog_->animateSlider->isOn());
    settings->writeEntry("/qt/Baghira/shadowSbSlider", dialog_->shadowSlider->isOn());
    settings->writeEntry("/qt/Baghira/squeezeSbSlider", dialog_->squeezeSlider->isOn());
    //Progress
    settings->writeEntry("/qt/Baghira/progressBar", dialog_->progressType->currentItem());
    settings->writeEntry("/qt/Baghira/drawProgressLabel", dialog_->showProgressValue->isOn());
    //Toolbars
    settings->writeEntry("/qt/Baghira/smoothToolbuttons", dialog_->roundToolButtons->isOn());
    settings->writeEntry("/qt/Baghira/drawToolbarButtonFrames", dialog_->unhoveredToolButtons->isOn());

    // menus
    //Translucency
//    dialog_->transGroup;
    settings->writeEntry("/qt/Baghira/menuTranslucency", dialog_->menuTranslucencyStyle->currentItem());
    settings->writeEntry("/qt/Baghira/customMenuOpacity", dialog_->menuTranslucencyOpacity->value());
    //Look
    settings->writeEntry("/qt/Baghira/stippleMenu", dialog_->stippleMenus->isOn());
    settings->writeEntry("/qt/Baghira/shadowedText", dialog_->shadowMenuText->isOn());
    settings->writeEntry("/qt/Baghira/menuColorButton", dialog_->menuColorMode->currentItem() == 1);
    settings->writeEntry("/qt/Baghira/useCustomMenuStyle", dialog_->menuColorMode->currentItem() == 2);
    settings->writeEntry("/qt/Baghira/customMenuTextColor", (int)dialog_->menuTextColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customMenuColor", (int)dialog_->menuColor->color().rgb());
    //Effects
//    dialog_->effectBox;
    settings->writeEntry("/qt/Baghira/menuAnimation", dialog_->menuEffect->currentItem());
    settings->writeEntry("/qt/Baghira/menuAnimationSpeed", dialog_->menuEffectSpeed->value());
    //Shadows    
//    dialog_->shadowBox;
    settings->writeEntry("/qt/Baghira/menuDropShadows", dialog_->useMenuDropShadows->isOn());
    settings->writeEntry("/qt/Baghira/shadowOffset", dialog_->menuDropShadowSize->value());
    settings->writeEntry("/qt/Baghira/dropShadowDarkness", dialog_->menuDropShadowIntensity->value());
    
    // custom colors
    settings->writeEntry("/qt/Baghira/useCustomWidgetColor", dialog_->useCustomColors->isOn());
    settings->writeEntry("/qt/Baghira/customRadioOffColor", (int)dialog_->radioOffColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customRadioOnColor", (int)dialog_->radioOnColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customCheckOffColor",(int) dialog_->checkOffColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customCheckOnColor", (int)dialog_->checkOnColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customSliderColor",(int) dialog_->sliderColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customHoveredSliderColor", (int)dialog_->hoverSliderColorColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customPressedSliderColor", (int)dialog_->pressedSliderColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customSliderGrooveColor",(int) dialog_->sliderGrooveColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customInactiveTabColor",(int) dialog_->inactiveTabColor->color().rgb());
    settings->writeEntry("/qt/Baghira/customActiveTabColor", (int)dialog_->activeTabColor->color().rgb());
    settings->writeEntry("/qt/Baghira/tintBrush", dialog_->tintBrush->isOn());
    settings->writeEntry("/qt/Baghira/customActiveTabColor", (int)dialog_->activeTabColor->color().rgb());
    settings->writeEntry("/qt/Baghira/brushTint",(int)qRgb(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue));
    delete settings;
    emit changed(true);
}


void kstyle_baghira_config::configChanged()
{
   dialog_->statusWarning->setText("Config changed");
   emit changed(true);
}


QString kstyle_baghira_config::quickHelp() const
{
    return i18n("Configure Your Cat");
}


//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////
    
extern "C"
{   
    QWidget* allocate_kstyle_config(QWidget* parent){
         return(new kstyle_baghira_config(parent, "BaghiraConfig"));
    }
}   

#include "kstyle_baghira_config.moc"
