/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lbking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KSTYLE_BAGHIRA_CONFIG_H_
#define _KSTYLE_BAGHIRA_CONFIG_H_

//#include <kcmodule.h>
#include <qcolor.h>
#include <qimage.h>
#include <kaboutdata.h>
#include "configdialog.h"
#include "help.h"
#include "about.h"

class kstyle_baghira_config: public QWidget
{
    Q_OBJECT

public:
    kstyle_baghira_config( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
    ~kstyle_baghira_config();

    virtual void load();
//    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData()const
    { return myAboutData; };

public slots:
    void configChanged();
    void openHtml1();
    void openHtml2();
    void startBab();
    void slotMenuEffectSpeedChanged(int id);
    void sliderButtonRedChanged(int);
    void sliderButtonGreenChanged(int);
    void sliderButtonBlueChanged(int);
    void sliderBrushRedChanged(int);
    void sliderBrushGreenChanged(int);
    void sliderBrushBlueChanged(int);
    virtual void save();
    virtual void defaults();
    
signals:
    void changed(bool);  

private:
      QImage* tintButton(QImage &src, QColor c);
      QImage* tintBrush( QImage &img, QColor c/*, int saturation*/ );
      KAboutData *myAboutData;
      Config *dialog_;
      Help* help_;
      About* about_;
      QImage baseImage, baseImage2;
      QColor buttonColor;
      QColor brushTint;
      int sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue;
      int sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/;
};

#endif
