#include "colorpicker.h"
#include <qcolor.h>
#include <qlayout.h>
#include <qslider.h>
#include <qlabel.h>
//#include <qgroupbox.h>

ColorPicker::ColorPicker(QWidget* parent, const char* name) : QGroupBox( parent, name){
//    box = new QGroupBox(parent);
    setColumnLayout(0, Qt::Vertical );
    layout()->setSpacing( 6 );
    layout()->setMargin( 11 );
    
    gridLayout = new QGridLayout( layout() );
    gridLayout->setAlignment( Qt::AlignTop );
    
    redLayout = new QHBoxLayout(0,0,6);
    redSlider = new QSlider(0, 255, 1, 0, Qt::Horizontal, this, "redSlider");
    redLayout->addWidget(redSlider);
    
    redValue = new QLabel(this);
    redValue->setNum(0);
    redLayout->addWidget(redValue);
    
    gridLayout->addLayout(redLayout, 0, 0);
    
    greenLayout = new QHBoxLayout();
    greenSlider = new QSlider(0, 255, 1, 0, Qt::Horizontal, this, "greenSlider");
    greenLayout->addWidget(greenSlider);
    
    greenValue = new QLabel(this);
    greenValue->setNum(0);
    greenLayout->addWidget(greenValue);
    
    gridLayout->addLayout(greenLayout, 1, 0);
    
    blueLayout = new QHBoxLayout();
    blueSlider = new QSlider(0, 255, 1, 0, Qt::Horizontal, this, "blueSlider");
    blueLayout->addWidget(blueSlider);
    
    blueValue = new QLabel(this);
    blueValue->setNum(0);
    blueLayout->addWidget(blueValue);
    
    gridLayout->addLayout(blueLayout, 2, 0);
    
    resize( QSize(350, 100).expandedTo(minimumSizeHint()) );
    
    //connections
    connect(redSlider, SIGNAL(valueChanged (int)), this, SLOT(setRed(int)));
    connect(greenSlider, SIGNAL(valueChanged (int)), this, SLOT(setGreen(int)));
    connect(blueSlider, SIGNAL(valueChanged (int)), this, SLOT(setBlue(int)));
}

ColorPicker::~ColorPicker(){
}

void ColorPicker::setColor(QColor color){
    redSlider->blockSignals(true);
    redSlider->setValue( color.red() );
    redSlider->blockSignals(false);
    redValue->setNum(redSlider->value());
    greenSlider->blockSignals(true);
    greenSlider->setValue( color.green() );
    greenSlider->blockSignals(false);
    greenValue->setNum(greenSlider->value());
    blueSlider->blockSignals(true);
    blueSlider->setValue( color.blue() );
    blueSlider->blockSignals(false);
    blueValue->setNum(blueSlider->value());
    emit colorChanged(color);
}

void ColorPicker::setRed(int red){
    redValue->setNum(red);
    emit colorChanged(QColor(red, greenSlider->value(), blueSlider->value()));
}

void ColorPicker::setGreen(int green){
    greenValue->setNum(green);
    emit colorChanged(QColor(redSlider->value(), green, blueSlider->value()));
}

void ColorPicker::setBlue(int blue){
    blueValue->setNum(blue);
    emit colorChanged(QColor(redSlider->value(), greenSlider->value(), blue));
}

QColor ColorPicker::Color(){
    return QColor(redSlider->value(), greenSlider->value(), blueSlider->value());
}
