#ifndef COLORPICKER_H
#define COLORPICKER_H

//#include <qvariant.h>
#include <qgroupbox.h>

class QGridLayout;
class QHBoxLayout;
class QSlider;
class QLabel;
class QColor;
//class QGroupBox;

class ColorPicker : public QGroupBox
{
    Q_OBJECT

public:
    ColorPicker( QWidget* parent = 0, const char* name = 0);
    ~ColorPicker();
    QColor Color();

public slots:
    void setColor(QColor color);
    void setRed(int red);
    void setGreen(int green);
    void setBlue(int blue);
    
protected:
    QSlider *redSlider;
    QSlider *greenSlider;
    QSlider *blueSlider;
    QLabel *redValue;
    QLabel *greenValue;
    QLabel *blueValue;
    QHBoxLayout *redLayout;
    QHBoxLayout *greenLayout;
    QHBoxLayout *blueLayout;
    QGridLayout *gridLayout;
//    QGroupBox *box;

signals:
    void colorChanged(QColor color);

};

#endif // COLORPICKER_H
