#ifndef __LIQUID_STYLE_H
#define __LIQUID_STYLE_H

// #include <qdrawutil.h>
// #include <qpainter.h>
// #include <qpointarray.h>
// #include <qstyleplugin.h>
// #include <qbitmap.h>

// #include <qimage.h>
// #include <qcleanuphandler.h>
// #include <qpainter.h>

// #include <kpixmapeffect.h>
// #include <kimageeffect.h>
// 
// #include <qiconview.h>
// #include <qwidgetlist.h>
// #include <qapplication.h>
// #include <qfile.h>
// #include <qfileinfo.h>
#include <qcstring.h>
#include <qdir.h>
// #include <qsettings.h>
// #include <qobjectlist.h>

// 
// // various widgets with special handlers
// #include <qscrollbar.h>
// #include <qcombobox.h>
// #include <qmenubar.h>
// #include <qpushbutton.h>
// #include <qslider.h>
// #include <qtabbar.h>
// #include <qtoolbutton.h>
// #include <qtoolbar.h>
// #include <qpopupmenu.h>

// #include <qheader.h>
// #include <qtextedit.h>
// 
// #include <kiconview.h>
// #include <kwordwrap.h>

#include <qintdict.h>
#include <qprogressbar.h>
#include <qtimer.h>
#include <qwmatrix.h> 
#include <kpixmap.h>
#include <qwidget.h>
#include <kstyle.h>

#define BITMAP_ITEMS 85 // Don't worry, they're demand loaded ;-)
#define LIQUID_MENU_CHANGE 667
#define MOSFET_BUTTON_CHANGE 661
#define _ENDIAN_ QImage::LittleEndian
//#define _ENDIAN_ QImage::BigEndian

class QColor;
class QHeader;
class QImage;
class QMenuBar;
class QPalette;
class QPoint;
class QPopupMenu;
class QRect;
class QScrollBar;
class QSize;
class QString;
class QTabBar;
class LiquidStyle;

enum BitmapData{RadioOn = 0, RadioOff, RadioOnHover, RadioOffHover, RadioOnPressed, RadioOffPressed,
		VSBSliderTop, VSBSliderMid, VSBSliderBtm,
		VSBSliderTopActive, VSBSliderMidActive, VSBSliderBtmActive,
		VSBSliderTopHover, VSBSliderMidHover, VSBSliderBtmHover,
		VSBSliderTopPressed, VSBSliderMidPressed, VSBSliderBtmPressed,
		VSBSliderTopBg, VSBSliderMidBg, VSBSliderMidBgI, VSBSliderBtmBg,
                HSBSliderTop, HSBSliderMid, HSBSliderBtm,
		HSBSliderTopActive, HSBSliderMidActive, HSBSliderBtmActive,
		HSBSliderTopHover, HSBSliderMidHover, HSBSliderBtmHover,
		HSBSliderTopPressed, HSBSliderMidPressed, HSBSliderBtmPressed,
		HSBSliderTopBg, HSBSliderMidBg, HSBSliderMidBgI, HSBSliderBtmBg,
		Tab, TabDown, TabFocus, belowTab, belowTabDown,
		ButtonShadow, CB, CBDown, CBHover, CBDownHover, CBPressed, CBDownPressed,
		HSlider, VSlider, VSliderAbove, HSliderInactive, VSliderInactive, VSliderAboveInactive,
		Progress, HTMLRadioOn, HTMLRadioOff,
                HTMLRadioOnHover, HTMLRadioOffHover, HTMLCBDown, HTMLCBDownHover,
                HTMLCBHover, HTMLCB,rectbutton, combo, comboShadow, progress2};

enum CustomColor{CustomCBOn = 0, CustomCBOff, CustomRadioOn, CustomRadioOff,
                 CustomTabOn, CustomTabOff, CustomSBSlider, CustomSBSliderHover, CustomSBSliderPressed, CustomSBGroove};

enum PulseType{PushButton, ComboBox, AppletHandle, Splitter, ToolButton};

enum myMenuTranslucency{Solid=0, DefaultTrans, CustomTrans, Gradient};

enum InactiveButtonColor{Original=0, Background, Active, Custom};

enum myExpanderStyle{Apple=0, MS};

enum progressStyle{mac=0, liquid, baghira};

enum DotlineStyle{Line=0, Dots};

enum Tile{TileTopLeft = 0, TileTop, TileTopRight,
          TileLeft, TileMiddle, TileRight, TileBtmLeft, TileBtm, TileBtmRight};

enum myPosition{left = 0, center, right, full};

enum tabStyle {TrueTab = 0, Clever, Chooser};

struct Effects
{
    enum Direction {
    	None = 0,
	FadeIn,
	LeftScroll,
	RightScroll,
	UpScroll,
	DownScroll
    };

    typedef uint DirFlags;
};
/*
    enum Direction {
    	None = 0,
	FadeIn,
	LeftScroll,
	RightScroll,
	UpScroll,
	DownScroll
    };
*/
class ButtonTile {
	public:
		ButtonTile() {
			for ( int i = 0;i < 9;++i ) {
				pixmaps[ i ] = 0;
				}
			}
		~ButtonTile() {
			for ( int i = 0;i < 9;++i ) {
				if ( pixmaps[ i ] )
					delete pixmaps[ i ];
				}
			}
		QPixmap* pixmap( Tile pos ) {
			return ( pixmaps[ ( int ) pos ] );
			}
		void setPixmap( Tile pos, QPixmap *pix ) {
			pixmaps[ ( int ) pos ] = pix;
			}
	protected:
		QPixmap *pixmaps[ 9 ];
	};

//namespace BaghiraStyle // menudropshadow stuff bases upon kde code - well... based ;-)
//{
	// Drop Shadow
/*	typedef struct _ShadowElements {
		QWidget* w1;
		QWidget* w2;
		QWidget* w3;
	}ShadowElements;

	
	typedef struct _PopupStuff{
		KPixmap *pix;
		KPixmap *cleanPix;
		ShadowElements *shadow;
		int leftOffset;
		bool hasShadows;
	}PopupStuff;*/

class ShadowElements : public QObject{
		Q_OBJECT
	public:
		ShadowElements(){
			w1 = NULL;
			w2 = NULL;
			w3 = NULL;
		}
		~ShadowElements(){
			if (w1) delete w1;
			if (w2) delete w2;
			if (w3) delete w3;
		}
		QWidget* w1;
		QWidget* w2;
		QWidget* w3;
	};

//}

//using namespace BaghiraStyle;

// class FadeWidget : public QWidget{
// 		Q_OBJECT
// };

class PopupStuff : public QObject{
		Q_OBJECT
	public:
		PopupStuff(){
			pix = NULL;
			cleanPix = NULL;
			shadow = NULL;
			leftOffset = 0;
			hasShadows = false;
		}
		~PopupStuff(){
			if (pix) delete pix;
			if (cleanPix) delete cleanPix;
			if (shadow) delete shadow;
		}
		KPixmap *pix;
		KPixmap *cleanPix;
		ShadowElements *shadow;
		int leftOffset;
		bool hasShadows;
};

class OptionHandler : public QObject {
		Q_OBJECT
	public:
		OptionHandler( QObject *parent );
		~OptionHandler() {
			if ( fillPixmap )
				delete fillPixmap;
// 			if (indicatedMenuItemRect)
// 				delete indicatedMenuItemRect;
// 			if (lastIndicatedMenuItemRect)
// 				delete lastIndicatedMenuItemRect;
// 			if (indicatedMenuItemPix)
// 				delete indicatedMenuItemPix;
// 			if (lastIndicatedMenuItemPix)
// 				delete lastIndicatedMenuItemPix;
			}
		void reloadSettings();
		KPixmap *pixmap( WId id ) {
			if (id == currentPopupWinID)
				return currentPopupPix;
			else if (PopupStuff *popupStuff = popupDict.find(id)){
				currentPopupWinID = id;
//				return ( currentPopupPix = pixDict.find( id ) );
				return ( currentPopupPix = popupStuff->pix);
			}
			else
				return NULL;
		}
		PopupStuff *popup( WId id ) {
			if (id == currentPopupWinID)
				return currentPopup;
			else if (PopupStuff *popupStuff = popupDict.find(id)){
				currentPopupWinID = id;
//				return ( currentPopupPix = pixDict.find( id ) );
				return ( currentPopup = popupStuff);
			}
			else
				return NULL;
		}		
		QPixmap* bgPixmap() {
			return ( fillPixmap );
			}
		inline static bool useShadowText() {
			return ( shadowText );
			}
		const QColor& textColor();
		const QColor& bgColor();
		const QColor& buttonColor();
		inline void reset() {
			menusProcessed = false;
			}

		inline static bool bevelHighlights(){
                    return (bevelHighlights_);
                }
                inline static bool useBgStipple() {
			return ( bgStipple );
			}
		inline static bool usePanelStipple() {
			return ( panelStipple );
			}
		inline static bool BrushMe(){
			return (brushMe);
			}
		inline static int stippleContrast() {
			return ( contrast );
			}
		inline static bool useReverseBtnColor() {
			return ( reverseBtnColor );
			}
		inline static bool usePanelCustomColor() {
			return ( panelCustom );
			}
		inline QColor panelCustomColor() {
			return ( customPanelColor );
			}
		inline static bool useToolButtonFrame() {
			return ( tbFrame );
			}
		void prepareMenus();

		inline static bool useCustomColors() {
			return ( customWidgetColor );
			}
		inline static const QColor& customColor( int idx ) {
			return ( customColors[ idx ] );
			}

		inline static bool DrawDotlines() {
			return ( drawDotlines );
			}
		inline static bool squeezeSbSlider() {
			return ( squeezesbslider );
			}
		inline static bool shadowSbSlider(){
			return (shadowsbslider);
			}
		inline static bool drawGroupBoxShadow() {
			return ( groupboxshadow );
			}
		inline static int InactiveButtonColorType() {
			return ( inactiveButtonColor );
			}
		inline static bool StippleMenu(){
			return (stippleMenu);
			}
		inline static int MenuTranslucency(){
			return (menuTranslucency);
			}
		inline static bool UseCustomMenuColor(){
			return (useCustomMenuColor);
			}
		inline static int DotlineStyle(){
			return (dotlineStyle);
			}
/*		inline static bool AlignStipples(){
			return(alignStipples);
			}*/
		inline static bool MenuColorButton(){
			return (menuColorButton);
			}
		inline static int ExpanderStyle(){
			return (expanderStyle);
			}
		inline static bool UseCustomExpanderColor(){
			return (useCustomExpanderColor);
			}
		inline static QColor CustomExpanderColor(){
			return (expanderColor);
			}
		inline static QColor DotlineColor(){
			return (dotlineColor);
			}
		inline QColor InactiveButtonColor(){
			switch (inactiveButtonColor){
			case 0 : return (QColor(232,232,232));
			case 1 : return (bgColor());
			case 2 : return (buttonColor());
			case 3 : return (customInactiveButtonColor);
			}
		}
		inline static bool CenterTabs(){
			return centerTabs;
		}
/*		inline static bool EngageFB(){
			return engageFB;
		}*/

		inline static bool SmoothListViewHeaders(){
			return smoothListViewHeaders;
		}

		inline static bool SmootherLVH(){
			return smootherLVH;
		};
		
		inline static bool IcyButtons(){
			return icyButtons;
		}

		inline static bool ForceRectButton(){
			return forceRectButton;
		}

		inline static int ShadowDarkness(){
			return shadowDarkness;
		}

/*		inline static int Saturation(){
			return saturation;
		}*/
/*
		inline bool MenuItemActive(){
			return menuItemActive;
		}

		inline void setMenuItemActive(){
			menuItemActive = true;
		}

		inline void setMenuItemInactive(){
			menuItemActive = false;
		}*/

		inline int MenuLevelCounter(){
			return menuLevelCounter;
		}

		inline WId LastPopupID(){
			return lastPopupID;
		}


		inline void SetLastPopupID(WId id){
			lastPopupID = id;
		}

		inline static int ProgressBar(){
			return progressBar;
		}

		inline static bool RemoveKickerBevel(){
			return removeKickerBevel;
		}

		inline static bool SmoothToolbuttons(){
			return smoothToolbuttons;
		}

		inline void setGroupShadowButton(){
			groupShadowButton = true;
		}
		inline void setNotGroupShadowButton(){
			groupShadowButton = false;
		}
		inline bool GroupShadowButton(){
			return groupShadowButton;
		}

		inline void setScrollerActive(){
			scrollerActive = true;
		}

		inline void setScrollerInactive(){
			scrollerActive = false;
		}

		inline bool ScrollerActive(){
			return scrollerActive;
		}

		inline static bool MenuDropShadows(){
			return menuDropShadows;
		}

		inline static QColor Color(){
			return color;
		}
		
		inline static int ShadowOffset(){
			return shadowOffset;
		}
		inline static bool DrawProgressLabel(){
			return drawProgressLabel;
		}
		inline static Effects::DirFlags MenuAnimation(){
			return menuAnimation;
		}
		inline static int MenuAnimationSpeed(){
			return menuAnimationSpeed;
		}
		
		inline static tabStyle TabStyle(){
			return tabStyle_;
		}
		
		inline static QColor BrushTint(){
			return brushTint;
		}
		
		inline static bool TintBrush(){
			return tintBrush;
		}
		
		inline static bool AnimateSlider(){
			return animateSlider;
		}
		inline static QColor CustomButtonColor(){
			return customButtonColor;
		}
		
		static QColor brushedMetalColor;
		
		void renderMenuBlendPixmap( KPixmap *blendPix, QColor c, QPopupMenu *p, int leftOffset);
		WId currentPopupWinID;
		PopupStuff *currentPopup;
		QMenuBar *currentMenu;
		QPixmap *indicatedMenuItemPix;
		QRect *indicatedMenuItemRect;
		QPixmap *lastIndicatedMenuItemPix;
		QRect *lastIndicatedMenuItemRect;
		bool daddyWasAPopup;
                bool mouseOverMenu;
		WId lastIndicatedMenuItemID;

		QRect *sharedRect(QRect *r1, QRect *r2);
//		QIntDict<KPixmap>pixDict;
//		QIntDict<KPixmap>cleanPixDict;
		QIntDict<PopupStuff>popupDict;
		void createShadowWindows(const QPopupMenu* p, PopupStuff *popupStuff, int swh);
		static void saveBitBlt(QPixmap* from, int x_from, int y_from, QPixmap* to, int x_to, int y_to, int width, int height, QString error);
		
	public slots:
		inline void warningSlot(){
			qWarning("widget destroyed");
		}
		
		inline void deletePopupDict(){
			if (menuLevelCounter < 1){
				popupDict.setAutoDelete(true);
				popupDict.clear();
				currentPopupWinID = 0;
				currentPopup = NULL;
				lastPopupID = 0;
				lastIndicatedMenuItemID = 0;
				indicatedMenuItemRect->setRect(0,0,0,0);
				lastIndicatedMenuItemRect->setRect(0,0,0,0);
				qWarning("popoup cleared!");
			}
		}

	protected:

//		void createShadowWindows(const QPopupMenu* p, QPixmap *cleanPix, int swh, int leftOffset);
		void removeShadowWindows(const QPopupMenu* p);
		void rightShadow(QImage& dst, int swh);
		void leftShadow(QImage& dst, int swh);
		void bottomShadow(QImage& dst, int swh);

		void stripePixmap( KPixmap &pix, const QColor &color );
		void stripePixmap( KPixmap &pix, const QColor &color, int density );
		bool eventFilter( QObject *obj, QEvent *ev );
		void initDropShadows(int swh);
		void ScrollEffect( QWidget*, QPixmap* pix, Effects::DirFlags dir = Effects::DownScroll, int time = -1, OptionHandler* oh = NULL, const QPopupMenu* p = NULL, PopupStuff *popupStuff = NULL, int swh = 0);
		void FadeEffect( QWidget*, QPixmap*, int time = -1, OptionHandler* oh = NULL, const QPopupMenu* p = NULL, PopupStuff *popupStuff = NULL, int swh = 0);
		


		// menu
		static bool stippleMenu;
		bool directFollower;
		static int menuTranslucency;
		static int opacity;//int customMenuOpacity;
		static bool menuColorButton;
		static bool menuDropShadows;
		static bool shadowText;
		//color
		static QColor customButtonColor;
		//widgets
		static bool customWidgetColor;
		static QColor customColors[ 10 ];
		//menu
		static bool useCustomMenuColor;
		static QColor color, fgColor;
		//Panel
		static bool panelCustom;
		static QColor customPanelColor;
		//incativeButton
		static int inactiveButtonColor;
		static QColor customInactiveButtonColor;

		//Design
		//stipples
		static bool bgStipple, panelStipple, brushMe, bevelHighlights_;
		static int contrast;
		//shadows
		static bool groupboxshadow;
		static int shadowDarkness;
		//istviews;
		static bool drawDotlines, useCustomExpanderColor;
		static int expanderStyle;
		static QColor expanderColor, dotlineColor;
		static int dotlineStyle;
		//slider
		static bool squeezesbslider;
		static bool shadowsbslider;
		//toolbar
		static bool reverseBtnColor, tbFrame;
		//tweaks
//		static bool alignStipples;
		static bool centerTabs;
//		static bool engageFB;
		static bool smoothListViewHeaders;
		static bool smootherLVH;
		static bool icyButtons;
		static bool forceRectButton;
//		static int saturation;
		bool menusProcessed;
		bool scrollerActive;
//		bool menuItemActive;
		int menuLevelCounter;
		WId lastPopupID;
		bool groupShadowButton;
		QRect lastPopupRect;
		QPixmap *fillPixmap;
		static int progressBar;
		static bool removeKickerBevel;
		static bool smoothToolbuttons;
		static int shadowOffset;
		bool dropShadowsInited;
		bool unblocked;
		static int dropShadowDarkness;
		KPixmap *currentPopupPix;
		static bool drawProgressLabel;
		static int menuAnimationSpeed;
		static Effects::DirFlags menuAnimation;
		static tabStyle tabStyle_;
		
		QString colorStr, fgColorStr, panelColorStr;
		static QColor brushTint;
		static bool tintBrush;
		static bool animateSlider;
	};
	
class WidgetAnimator : public QWidget{
		Q_OBJECT
	public:
		WidgetAnimator( QWidget *parent, int type = 0 ){
			hasIt = false;
			timer = new QTimer();
			timer->start(50);
			myWidget = parent;
			activeWidget = NULL;
			if (type == 0)
				connect(timer, SIGNAL(timeout()), this, SLOT(animateSingleWidget()));
			else if (type == 1)
				connect(timer, SIGNAL(timeout()), this, SLOT(animateMultipleWidgets()));
			else if (type == 2)
				connect(timer, SIGNAL(timeout()), this, SLOT(animateProgressBar()));

			connect(this, SIGNAL(animate(bool)), myWidget, SLOT(repaint(bool)));
		}
		~WidgetAnimator(){
			if (myWidget) { myWidget = NULL;}
			if (timer) {delete  timer; timer = NULL;}
		}
		
		void setMyWidget(QWidget *myNewWidget){
			if (myWidget) disconnect(this, SIGNAL(animate(bool)), myWidget, SLOT(repaint(bool)));
			qWarning("updating");
			myWidget = myNewWidget;
			connect(this, SIGNAL(animate(bool)), myWidget, SLOT(repaint(bool)));
		}
		void setActiveWidget(QWidget **newActiveWidget){
			activeWidget = newActiveWidget;
		}
		
		bool hasIt;
		
	private:
		QTimer *timer;
		QWidget *myWidget;
		QWidget **activeWidget;
	public slots:
		inline void animateSingleWidget(){
			if (*activeWidget == myWidget) emit animate(false);
		}
		inline void animateMultipleWidgets(){
			if (*activeWidget != NULL) emit animate(false);
		}
		inline void animateProgressBar(){
			if (((QProgressBar *)myWidget)->progress() > 0) emit animate(false);
		}
		signals:
		void animate(bool);
		void animate();
	};
	
class LiquidStyle : public KStyle {
		Q_OBJECT
	public:
		friend class OptionHandler;
//		friend class ScrollbarAnimator;
		LiquidStyle();
		virtual ~LiquidStyle();
		bool isPlain() const;
		
		virtual void polish( QWidget *w );
		virtual void unPolish( QWidget *w );
		virtual void polish( QPalette &p );
		virtual void unPolish( QApplication *a );
		int styleHint(StyleHint sh, const QWidget * w, const QStyleOption & opt, QStyleHintReturn * shr) const;
		void drawKStylePrimitive( KStylePrimitive kpe, QPainter* p, const QWidget* widget, const QRect &r, const QColorGroup &cg, SFlags flags = Style_Default, const QStyleOption& = QStyleOption::Default ) const;
		void drawPrimitive( PrimitiveElement pe, QPainter* p, const QRect &r, const QColorGroup &cg, SFlags flags = Style_Default, const QStyleOption& = QStyleOption::Default ) const;
		void drawControl( ControlElement element, QPainter *p, const QWidget *widget, const QRect &r, const QColorGroup &cg, SFlags flags = Style_Default, const QStyleOption& = QStyleOption::Default ) const;
//		void drawControlMask( ControlElement element, QPainter *p, const QWidget *widget, const QRect &r, const QStyleOption& = QStyleOption::Default ) const;
		void drawComplexControl( ComplexControl control, QPainter *p, const QWidget *widget, const QRect &r, const QColorGroup &cg, SFlags flags = Style_Default, SCFlags controls = SC_All, SCFlags active = SC_None, const QStyleOption& = QStyleOption::Default ) const;
//		void drawComplexControlMask( ComplexControl control, QPainter *p, const QWidget *widget, const QRect &r, const QStyleOption& = QStyleOption::Default ) const;

		int pixelMetric( PixelMetric m, const QWidget *widget = 0 ) const;

		QSize sizeFromContents( ContentsType contents, const QWidget *widget, const QSize &contentSize, const QStyleOption& opt ) const;
		QRect subRect( SubRect r, const QWidget *widget ) const;
		QRect querySubControlMetrics( ComplexControl control, const QWidget *widget, SubControl subcontrol, const QStyleOption &opt = QStyleOption::Default ) const;
		// Fix Qt3's wacky image positions
		QPixmap stylePixmap( StylePixmap stylepixmap, const QWidget *widget = 0, const QStyleOption& = QStyleOption::Default ) const;
		bool eventFilter( QObject *object, QEvent *event );
		//    void renderMenuBlendPixmap( KPixmap& pix, const QColorGroup &cg, const QPopupMenu* popup) const;
		
	public slots:
		void updateProgressPos();
		void updateSliderPos();
	
	protected:
		void clearImage( QImage &img ) const;
		ButtonTile* createButtonTile( const QColor &c, const QColor &bgColor, QImage *buttonImage, QImage *shadowImage, QImage *glowImage, QIntDict <ButtonTile>*buttonDict, QIntDict<ButtonTile>*shadowDict, QIntDict<ButtonTile>*glowDict, int w, int h, int xOff, int yOff, int centerW, int centerH, int shadowH, int glowWH, bool sunken, bool hover ) const;
                ButtonTile* createRoundFrameTile(QImage &img, const QColor &color, const QColor *bg, const QColor &baseColor ) const;
		QPixmap* createSliderEnd( const QColor &c, const QColor &bgColor, bool top/*, bool vertical*/ ) const;
		ButtonTile* separateTiles( QPixmap *pix, int xO, int yO, int w, int h, int sh, bool sunken, bool forceAlpha ) const;

		QPixmap* getPixmap( BitmapData item ) const;
		QPixmap* adjustHSV( QImage &img, const QColor &c, bool blend = false, const QColor *bg = NULL ) const;
//		QImage* apple(QImage *img, const QColor *c, bool blend, const QColor *bg ) const;
//		QImage* grain_merge(QImage *image, const QColor *color) const;
//		int clamp(int v, int min, int max) const;
		QImage* adjustHSVImage( QImage &img, const QColor &c, bool blend = false, const QColor *bg = NULL ) const;
		void adjustHSV( QPixmap &pix, const QColor &c ) const;
		QImage* tintBrush( const QImage &img, const QColor &c ) const;
		QPixmap* processEmbedded( const char *label, const QColor &c, bool blend = false, const QColor *bg = NULL ) const;
		void drawRoundButton( QPainter *p, const QColorGroup &cg, const QColor &c, const QColor &bg, int x, int y, int w, int h, bool supportPushDown = false, bool pushedDown = false, bool hover = false, bool autoDefault = false, bool isHTML = false, int bgX = -1, int bgY = -1 ) const;
		void drawClearBevel( QPainter *p, int x, int y, int w, int h, const QColor &c, const QColor &bg ) const;
		void drawRectangularButton( QPainter *p, const QColorGroup &cg, const QColor &c, int x, int y, int w, int h, bool sunken = false, bool hover = false, bool isCombo = false, int position = full, bool isHtml = false) const;
		void drawCombo( QPainter *painter, const QColorGroup &cg, const QColor &c, int x, int y, int w, int h, bool sunken, bool hover, bool isCombo, int position = full ) const;
		void drawEditFrame( QPainter *p, const QRect &r, const QColorGroup &cg, bool isHTML = false, bool focused = false, bool inverse = false/*, bool round = false*/ ) const;
                void drawRoundFrame( QPainter *p, const QRect &r, const QColorGroup &cg, bool focused, QPoint offset ) const;
		void drawHTMLCBBorder( const QPixmap &pix, const QColor &c ) const;
		bool isHTMLWidget( const QWidget *w ) const;


	private:
		LiquidStyle( const LiquidStyle & );
		LiquidStyle& operator=( const LiquidStyle & );
		int getBrightness(unsigned int rgb) const;
		QImage fetchImage( const char *name );
                
		
		QBitmap *sbLeft, *sbRight, *sbUp, *sbDown, *checkmark;
		QImage *btnBorderImg, *btnShadowImg, *slider_top, *slider_btm, *slider_top_shd, *slider_btm_shd, *rectbutton, *combo, *comboShadow, *buttonGlow, *roundFrame;
		QPixmap *btnBlendPix, *bevelFillPix, *smallBevelFillPix, *menuPix, *groupShadow ;
		QPixmap plainBrush, gradBrush;
		QBrush pagerBrush, pagerHoverBrush;
		QBrush origPanelBrush;
		QPalette origPanelPalette;

		QPixmap *pixmaps[ BITMAP_ITEMS ];
		QPixmap sbBuffer;
		QScrollBar *currentScrollBar;
		QWMatrix lMatrix;
		QWMatrix rMatrix;
		QWMatrix iMatrix;

		bool isKicker, isHTMLButton, initialPaletteLoaded, inExitPolish;

		QHeader *currentHeader;
		QTabBar *currentTabBar;
		int headerHoverID;
                int headerSortID;
		QPoint btnOffset;
		QWidget *currentTaskContainer;
		bool isTaskContainer, taskContainerHover;

		QPalette polishedPalette, tooltipPalette;
		unsigned int qtrcModificationTime;
		
		int progAnimShift;
		int prog2AnimShift;
		int sliderAnimShift;
		int hoveredTabIndex;

		OptionHandler *optionHandler;

		QIntDict<ButtonTile>btnDict;
		QIntDict<ButtonTile>btnShadowedDict;
		QIntDict<ButtonTile>buttonGlowDict;
		QIntDict<ButtonTile>comboDict;
		QIntDict<ButtonTile>comboShadowedDict;
		QIntDict<ButtonTile>tabDict;
		QIntDict<ButtonTile>inverseTabDict;
		QIntDict<ButtonTile>rectBtnDict;
		QIntDict<ButtonTile>progress2Dict;
		QIntDict<QPixmap>bevelFillDict;
		QIntDict<QPixmap>smallBevelFillDict;
		QIntDict<WidgetAnimator>animatedWidgetDict;

		QPixmap *tmpBtnPix;
                ButtonTile *inactiveRoundFrame;
                ButtonTile *activeRoundFrame;
		
		QWidget *highlightWidget;
		QScrollBar *activeScroller;
//		QProgressBar *activeProgress;
//		void FadeEffect( QWidget*, int time = -1 );

	};
	
#endif
