bool LiquidStyle::eventFilter( QObject *obj, QEvent *ev ) {

    switch (ev->type()){
        case QEvent::None:
        case QEvent::Timer:
            return FALSE;
        case QEvent::MouseMove:
            if (::qt_cast<QTabBar*>(obj)){
                QTabBar *tb = (QTabBar*)obj;
                QRect tmpRect;
                bool done = false;
                QMouseEvent *me = ( QMouseEvent*)ev;
                int oldTab = hoveredTabIndex;
                if (hoveredTabIndex == -1){
                    for (int i = 0; i < tb->count(); i++){
                        if (tb->tabAt(i)){
                            tmpRect = tb->tabAt(i)->rect();
                            if ( tmpRect.x() < me->x() && me->x() < tmpRect.right()){
                                hoveredTabIndex = i;
                                break;
                            }
                        }
                    }
                }
                else{
                    if ((oldTab > 0) && tb->tabAt(oldTab-1)){
                        tmpRect = tb->tabAt(oldTab-1)->rect();
                        if ((tmpRect.x() < me->x()) && (me->x() < tmpRect.right())){
                            hoveredTabIndex = oldTab-1;
                            done = true;
                        }
                    }
                    if (!done && (oldTab < tb->count()-1) && tb->tabAt(oldTab+1)){
                        tmpRect = tb->tabAt(oldTab+1)->rect();
                        if ((tmpRect.x() < me->x()) && (me->x() < tmpRect.right())){
                            hoveredTabIndex = oldTab+1;
                        }
                    }
                }
                if ( oldTab != hoveredTabIndex ) {
                    // reset old tab
                    if ( oldTab != -1 ) {
                        if (tb->tabAt(oldTab)) tb->repaint( tb->tabAt(oldTab)->rect(), false );
                    }
                    if ( hoveredTabIndex != -1 ) {
                        tb->repaint( tmpRect, false );
                    }
                }
                return FALSE;
            }
            else if ( ::qt_cast<QHeader*>(obj) ) {
                QHeader *hw = (QHeader*)obj;
                QMouseEvent * me = ( QMouseEvent * ) ev;
                int oldHeader = headerHoverID;
                headerHoverID = hw->sectionAt( me->x() + hw->offset());
                if ( oldHeader != headerHoverID ) {
                    // reset old header
                    if ( oldHeader != -1 ) {
                        hw->repaint( hw->sectionPos( oldHeader )-hw->offset(), 0, hw->sectionSize( oldHeader ), hw->height(), false );
                    }
                    if ( headerHoverID != -1 ) {
                            hw->repaint( hw->sectionPos( headerHoverID )-hw->offset(), 0, hw->sectionSize( headerHoverID ), hw->height(), false );
                    }
                }
                return FALSE;
            }
            return FALSE;
        case QEvent::Paint:
            if ( ::qt_cast<QToolButton*>(obj) ) {
                QToolButton * btn = ( QToolButton * ) obj;
                if (!obj->inherits( "TaskContainer" )){
                    if (btn->backgroundOrigin() != QWidget::WindowOrigin)
                        btn->setBackgroundOrigin( QWidget::WindowOrigin );
                }
                else{
                    isTaskContainer = true;
                    if ( currentTaskContainer == btn )
                        taskContainerHover = true;
                    else
                        taskContainerHover = false;
                }
                return FALSE;
            }
            else if (::qt_cast<QMenuBar*>(obj)){
                if (KStyle::eventFilter( obj, ev ))
                    return TRUE;
                QWidget *w = (QWidget *)obj;
                if(w->backgroundMode() != Qt::PaletteBackground){
                    w->setBackgroundMode(PaletteBackground);
                    w->setBackgroundOrigin(QWidget::WindowOrigin);
                }
                return FALSE;
            }
            else if ( ::qt_cast<QHeader*>(obj) ) {
                QHeader *hw = (QHeader*)obj;
                if (hw->parentWidget() && ::qt_cast<QListView*>(hw->parentWidget()))
                    headerSortID = ((QListView*)hw->parentWidget())->sortColumn();
                return FALSE;
            }
            else if ( obj->inherits( "QDockWindow" ) ) {
                if (KStyle::eventFilter( obj, ev ))
                    return TRUE;
                QWidget * w = ( QWidget * ) obj;
                if ( w->backgroundMode() != Qt::PaletteBackground ) {
                    w->setBackgroundMode( Qt::PaletteBackground );
                    w->setBackgroundOrigin( QWidget::WindowOrigin );
                }
                return FALSE;
            }
            else if ( obj->inherits( "QRadioButton" ) || obj->inherits( "QCheckBox" ) ) {
                QButton * btn = ( QButton * ) obj;
                bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "QStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
                bool isRadio = obj->inherits( "QRadioButton" );
                btn->erase();
                QPainter p;
                p.begin( btn );
                QFontMetrics fm = btn->fontMetrics();
                QSize lsz = fm.size( ShowPrefix, btn->text() );
                QSize sz = isRadio ?
                QSize( pixelMetric( PM_ExclusiveIndicatorWidth ), pixelMetric( PM_ExclusiveIndicatorHeight ) ) :
                QSize( pixelMetric( PM_IndicatorWidth ), pixelMetric( PM_IndicatorHeight ) );
                int x = 0;
                int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
                SFlags flags = Style_Default;
                if ( btn->isEnabled() )
                    flags |= Style_Enabled;
                if ( btn->hasFocus() )
                    flags |= Style_HasFocus;
                if ( btn->isDown() )
                    flags |= Style_Down;
                if ( highlightWidget == btn )
                    flags |= Style_MouseOver;
                if ( btn->state() == QButton::On )
                    flags |= Style_On;
                else if ( btn->state() == QButton::Off )
                    flags |= Style_Off;
                if ( isRadio )
                    drawControl( CE_RadioButton, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
                else
                    drawControl( CE_CheckBox, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
                x = sz.width() + 6;
                y = 0;
                if ( btn->hasFocus() ) {
                    QColor tmp( btn->colorGroup().background().dark( 130 ) );
                    drawItem( &p, QRect( sz.width() + 6 + 2, 1, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1, &tmp );
                    drawItem( &p, QRect( sz.width() + 6 + 3, 2, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1, &tmp );
                }
                drawItem( &p, QRect( sz.width() + 6 + 1, 0, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text() );
                p.end();
                return TRUE;
            }
            return FALSE;
        case QEvent::KeyPress:
            if (::qt_cast<QMenuBar*>(obj)){
                optionHandler->mouseOverMenu = true;
            }
            return FALSE;
        case QEvent::KeyRelease:
            return FALSE;
        case QEvent::Wheel:
            return FALSE;
        case QEvent::Enter:
            if ( ::qt_cast<QToolButton*>(obj) ) {
                bool isTask = obj->inherits( "TaskContainer" );
                QToolButton * btn = ( QToolButton * ) obj;
                if (isTask){
                    currentTaskContainer = btn;
                    btn->repaint( false );
                    return FALSE;
                }
                else if ( btn->isEnabled() ) {
                    highlightWidget = btn;
                    btn->repaint( false );
                    return FALSE;
                }
            }
            else if ( ::qt_cast<QPushButton*>(obj) || ::qt_cast<QComboBox*>(obj) || obj->inherits( "QSplitterHandle" ) || obj->inherits( "AppletHandleDrag" ) ) {
                QWidget * btn = ( QWidget * ) obj;
                if ( btn->isEnabled() ) {
                    highlightWidget = btn;
                    btn->repaint( false );
                }
                return FALSE;
            }
            else if (::qt_cast<KToolBar*>(obj)){
                QObjectList *handlerList = obj->queryList( "QDockWindowHandle" );
                for (uint i= 0; i < handlerList->count(); i++)
                    ((QWidget*)(handlerList->at(i)))->repaint(false);
                return FALSE;
            }
            else if (::qt_cast<QMenuBar*>(obj)){
                optionHandler->mouseOverMenu = true;
                return FALSE;
            }
            else if ( ::qt_cast<QScrollBar*>(obj) ) {
                QScrollBar * sb = ( QScrollBar * ) obj;
                if ( !sb->draggingSlider() ) {
                    if (optionHandler->AnimateSlider()){
                        // generating animation stuff
                        WidgetAnimator *scrollbarAnimator = animatedWidgetDict[sb->winId()];
                        if (!scrollbarAnimator){
                            scrollbarAnimator = new WidgetAnimator(sb, 0);
                            scrollbarAnimator->setActiveWidget((QWidget **)(&activeScroller));
                            animatedWidgetDict.insert(sb->winId(), scrollbarAnimator);
                        }
                    }
                    if ( sb->isEnabled() ) {
                        activeScroller = sb;
                        highlightWidget = sb;
                        sb->repaint( false );
                    }
                }
                return FALSE;
            }
            else if ( ::qt_cast<QScrollView*>(obj) ) {
                QScrollView *sv = ( QScrollView * ) obj;
                optionHandler->setScrollerActive();
                if (!(highlightWidget == sv->verticalScrollBar()))
                    sv->verticalScrollBar()->repaint(false);
                if (!(highlightWidget == sv->horizontalScrollBar()))
                    sv->horizontalScrollBar()->repaint(false);
                return FALSE;
            }
            else if ( ::qt_cast<QHeader*>(obj) ) {
                currentHeader = (QHeader*)obj;
                headerHoverID = -1;
                return FALSE;
            }
            else if (::qt_cast<QTabBar*>(obj)){ 
                currentTabBar = (QTabBar*)obj;
                hoveredTabIndex = -1;
                return FALSE;
            }
            else if ( obj->inherits( "KateView" ) || obj->inherits( "TEWidget") || obj->inherits("CHexViewWidget")) {
                QObjectList *scrollerList = obj->queryList( "QScrollBar" );
                optionHandler->setScrollerActive();
                for (uint i= 0; i < scrollerList->count(); i++)
                        ((QWidget*)(scrollerList->at(i)))->repaint(false);  
                return FALSE;                    
            }
            else if (obj->inherits("KDockWidgetAbstractHeaderDrag")){
                ((QWidget *)obj)->repaint();
                return FALSE;
            }
            else if (obj->inherits( "KAnimWidget" )){
                return TRUE;
            }
            else if ( obj->inherits( "QLineEdit" ) && obj->parent() && ::qt_cast<QComboBox*>(obj->parent())) {
                QWidget * btn = ( QWidget * ) obj->parent();
                if ( btn->isEnabled() ) {
                    highlightWidget = btn;
                    btn->repaint( false );
                }
                return FALSE;
            }
            else if ( obj->inherits( "QRadioButton" ) || obj->inherits( "QCheckBox" ) ) {
                QButton * btn = ( QButton * ) obj;
                if (btn->isEnabled()) {
                    bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "QStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
                    bool isRadio = obj->inherits( "QRadioButton" );
                    highlightWidget = btn;
                    QFontMetrics fm = btn->fontMetrics();
                    QSize lsz = fm.size( ShowPrefix, btn->text() );
                    QSize sz = isRadio ?
                                QSize( pixelMetric( PM_ExclusiveIndicatorWidth ), pixelMetric( PM_ExclusiveIndicatorHeight ) ) :
                                QSize( pixelMetric( PM_IndicatorWidth ), pixelMetric( PM_IndicatorHeight ) );
                    int x = 0;
                    int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
                    //if(btn->autoMask())
                    //    btn->erase(x+1, y+1, sz.width()-2, sz.height()-2);
                    QPainter p;
                    p.begin( btn );
                    SFlags flags = Style_Default;
                    if ( btn->isEnabled() )
                        flags |= Style_Enabled;
                    if ( btn->hasFocus() )
                        flags |= Style_HasFocus;
                    if ( btn->isDown() )
                        flags |= Style_Down;
                    if ( highlightWidget == btn )
                        flags |= Style_MouseOver;
                    if ( btn->state() == QButton::On )
                        flags |= Style_On;
                    else if ( btn->state() == QButton::Off )
                        flags |= Style_Off;
                    if ( isRadio )
                        drawControl( CE_RadioButton, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
                    else
                        drawControl( CE_CheckBox, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
                    p.end();
                }
                return FALSE;
            }
            return FALSE;
        case QEvent::Leave:
            if ( ::qt_cast<QToolButton*>(obj) ) {
                QToolButton * btn = ( QToolButton * ) obj;
                if (obj->inherits( "TaskContainer" )){
                    currentTaskContainer = NULL;
                    btn->repaint( false );
                    return FALSE;
                }
                else if ( btn == highlightWidget ) {
                    highlightWidget = NULL;
                    btn->repaint( false );
                    return FALSE;
                }
            }
            else if ( ::qt_cast<QPushButton*>(obj) || ::qt_cast<QComboBox*>(obj) || obj->inherits( "QSplitterHandle" ) || obj->inherits( "AppletHandleDrag" ) ) {
                QWidget * btn = ( QWidget * ) obj;
                if ( btn == highlightWidget ) {
                    highlightWidget = NULL;
                    btn->repaint( false );
                }
                return FALSE;
            }
            else if (::qt_cast<KToolBar*>(obj)){
                QObjectList *handlerList = obj->queryList( "QDockWindowHandle" );
                for (uint i= 0; i < handlerList->count(); i++)
                    ((QWidget*)(handlerList->at(i)))->repaint(false);
                return FALSE;
            }
            else if (::qt_cast<QMenuBar*>(obj)){
                optionHandler->mouseOverMenu = false;
                return FALSE;
            }
            else if ( ::qt_cast<QScrollBar*>(obj) ) {
                QScrollBar * sb = ( QScrollBar * ) obj;
                if ( sb == highlightWidget && !sb->draggingSlider() ) {
                    activeScroller = NULL;
                    highlightWidget = NULL;
                    sb->repaint( false );
                }
                return FALSE;
            }
            else if ( ::qt_cast<QScrollView*>(obj) ) {
                QScrollView *sv = (QScrollView*)obj;
                optionHandler->setScrollerInactive();
                if (!(highlightWidget == sv->verticalScrollBar()))
                    sv->verticalScrollBar()->repaint(false);
                if (!(highlightWidget == sv->horizontalScrollBar()))
                    sv->horizontalScrollBar()->repaint(false);
                return FALSE;
            }
            else if ( ::qt_cast<QHeader*>(obj) ) {
                QHeader *hw = (QHeader*)obj;
                currentHeader = NULL;
                if ( headerHoverID != -1 ) {
                    hw->repaint( hw->sectionPos( headerHoverID )-hw->offset(), 0, hw->sectionSize( headerHoverID ), hw->height(), false );
                }
                headerHoverID = -1;
                return FALSE;
            }
            else if (::qt_cast<QTabBar*>(obj)){ 
                QTabBar *tb = (QTabBar*)obj;
                currentTabBar = NULL;
                if ( hoveredTabIndex != -1 ) {
                    QTab *tmpTab = tb->tabAt(hoveredTabIndex);
                    if (tmpTab) tb->repaint( tmpTab->rect(), false );
                }
                hoveredTabIndex = -1;
                return FALSE;
            }
            else if ( obj->inherits( "KateView" ) || obj->inherits( "TEWidget") || obj->inherits("CHexViewWidget")) {
                QObjectList *scrollerList = obj->queryList( "QScrollBar" );
                optionHandler->setScrollerInactive();
                for (uint i= 0; i < scrollerList->count(); i++)
                    ((QWidget*)(scrollerList->at(i)))->repaint(false);
                return FALSE;
            }
            else if (obj->inherits("KDockWidgetAbstractHeaderDrag")){
                ((QWidget *)obj)->repaint();
                return FALSE;
            }
            else if (obj->inherits( "KAnimWidget" )){
                return TRUE;
            }
            else if ( obj->inherits( "QLineEdit" ) && obj->parent() && ::qt_cast<QComboBox*>(obj->parent())) {
                QWidget *btn = (QWidget*)obj->parent();
                if ( btn == highlightWidget )
                    highlightWidget = NULL;
                btn->repaint( false );
                return FALSE;
            }
            else if ( obj->inherits( "QRadioButton" ) || obj->inherits( "QCheckBox" ) ) {
                QButton * btn = ( QButton * ) obj;
                if (btn == highlightWidget) {
                    bool isRadio = obj->inherits( "QRadioButton" );
                    bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "QStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
                    highlightWidget = NULL;
                    QFontMetrics fm = btn->fontMetrics();
                    QSize lsz = fm.size( ShowPrefix, btn->text() );
                    QSize sz = isRadio ?
                                QSize( pixelMetric( PM_ExclusiveIndicatorWidth ), pixelMetric( PM_ExclusiveIndicatorHeight ) ) :
                                QSize( pixelMetric( PM_IndicatorWidth ), pixelMetric( PM_IndicatorHeight ) );
                    int x = 0;
                    int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
                    //if(btn->autoMask())
                    //    btn->erase(x+1, y+1, sz.width()-2, sz.height()-2);
                    QPainter p;
                    p.begin( btn );
                    SFlags flags = Style_Default;
                    if ( btn->isEnabled() )
                        flags |= Style_Enabled;
                    if ( btn->hasFocus() )
                        flags |= Style_HasFocus;
                    if ( btn->isDown() )
                        flags |= Style_Down;
                    if ( highlightWidget == btn )
                        flags |= Style_MouseOver;
                    if ( btn->state() == QButton::On )
                        flags |= Style_On;
                    else if ( btn->state() == QButton::Off )
                        flags |= Style_Off;
                    if ( isRadio )
                        drawControl( CE_RadioButton, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
                    else
                        drawControl( CE_CheckBox, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
                    p.end();
                }
                return FALSE;
            }
            return FALSE;
        case QEvent::MouseButtonPress:
            if ( ::qt_cast<QScrollBar*>(obj) ){
                QScrollBar * sb = ( QScrollBar * ) obj;
                activeScroller = NULL;
                sb->repaint( false );
                return FALSE;
            }
            else if (obj->inherits( "KAnimWidget" )){
                ((QFrame *)obj)->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
                return FALSE;
            }
            return FALSE;
        case QEvent::MouseButtonRelease:
            if ( ::qt_cast<QScrollBar*>(obj) ){
                QScrollBar * sb = ( QScrollBar * ) obj;
                QMouseEvent * me = ( QMouseEvent * ) ev;
                if ( sb == highlightWidget){
                    if ( sb->rect().contains( me->pos() ) ) {
                        activeScroller = sb;
                        sb->repaint( false );
                    }
                    else {
                        // this assumes, scrollers are right/bottom to scrollview
                        if ( ((sb->orientation() == Vertical) && (me->pos().x() < 0)) || ((sb->orientation() == Horizontal) && (me->pos().y() < 0)) ) {
                            optionHandler->setScrollerActive();
                            sb->repaint( false );
                        }
                    }
                }
                return FALSE;
            }
            else if ( ::qt_cast<QHeader*>(obj) && obj->parent() && ::qt_cast<QListView*>(obj->parent())) {
                QMouseEvent * me = ( QMouseEvent * ) ev;
                headerSortID = ((QHeader*)obj)->sectionAt( me->x() + ((QHeader*)obj)->offset());
                return FALSE;                
            }
            else if (obj->inherits( "KAnimWidget" )){
                ((QFrame *)obj)->setFrameShape(QFrame::NoFrame);
                return FALSE;
            }
            return FALSE;
//         case QEvent::MouseButtonDblClick:
        case QEvent::FocusIn:
            if (::qt_cast<QMenuBar*>(obj)){
                optionHandler->mouseOverMenu = true;
                return FALSE;
            }
            else if ( obj->inherits( "QLineEdit" ) ) {
                QObject *daddy = obj->parent();
                if ( daddy && daddy->inherits( "QSpinWidget" )){
                    ((QWidget*)daddy)->repaint(false);
                }
                else {
                    ((QWidget*)obj)->repaint(false);
                }
                return FALSE;
            }
            return FALSE;
        case QEvent::FocusOut:
            if (::qt_cast<QMenuBar*>(obj)){
                optionHandler->mouseOverMenu = false;
                return FALSE;
            }
            else if ( obj->inherits( "QLineEdit" ) ) {
                if ( obj->parent() && obj->parent()->inherits( "QSpinWidget" )){
                    ((QWidget*)obj->parent())->repaint(false);
                }
                else {
                    ((QWidget*)obj)->repaint(false);
                }
                return FALSE;
            }
            return FALSE;
        case QEvent::Move:
             if ( !obj->inherits( "KActiveLabel" ))
                return FALSE;
        case QEvent::Show:
            if ( !qstrcmp(obj->name(), "kde toolbar widget") ){
                QWidget* lb = static_cast<QWidget*>(obj);
                if (lb->backgroundMode() == Qt::PaletteButton)
                    lb->setBackgroundMode(Qt::PaletteBackground);
                lb->removeEventFilter(this);
                return FALSE;
            }
            else if (isKicker)
                return FALSE;
//             if (::qt_cast<QListView*>(obj)){
//                 QListView *LV = (QListView*)obj;
//                 qWarning("%d",LV->selectionMode());
//                 LV->firstChild()?qWarning("%d", LV->firstChild()->height()):qWarning("NO LISTVIEW CHILD FOUND!!!");
//             }
//             if (::qt_cast<QListBox*>){
//             }
        case QEvent::Resize:{
            QResizeEvent* rev = (QResizeEvent*) ev;
            if (optionHandler->BrushMe() && obj->isWidgetType() && ((QWidget*)obj)->isTopLevel() &&
            !(::qt_cast<QPopupMenu*>(obj) || ::qt_cast<QMenuBar*>(obj) || ((QWidget*)obj)->isDesktop () || ::qt_cast<QListBox*>(obj) ||
            obj->inherits("QTipLabel") || obj->inherits("AlphaWidget") || obj->inherits("ScrollWidget") ) && (ev->type() == QEvent::Show ||
            rev->size().width() != rev->oldSize().width())){
                QWidget* widget = (QWidget*)obj;
                // create new brushpix
                QPixmap tmpBrushPix(ev->type() == QEvent::Show?widget->width():rev->size().width(), 52);
                QPainter lightMe(&tmpBrushPix);
                // calc brush offsets
                int tmpWidth;
                if ((tmpWidth = tmpBrushPix.width()) > 1024){
                    int leftWidth = (tmpWidth-1024)/2;
                    int rightWidth = tmpWidth - leftWidth;
                    lightMe.drawTiledPixmap(0, 0, leftWidth, 52, plainBrush,256-leftWidth,0);
                    lightMe.drawPixmap(leftWidth, 0, gradBrush);
                    lightMe.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, 52, plainBrush);
                }
                else{
                    lightMe.drawPixmap(0, 0, gradBrush, (1024-tmpWidth)/2, 0, tmpWidth);
                }
                lightMe.end();
                    
                //update palette
                QPalette pal( qApp->palette());
                QColor c( pal.active().background() );
                QBrush brush( c, tmpBrushPix );
                pal.setBrush ( QColorGroup::Background, brush );
                //reset apps palette
                qApp->setPalette(pal);
                pal = QPalette(widget->palette());
                pal.setBrush ( QColorGroup::Background, brush );
                widget->setPalette(pal);
    //             qWarning("well, we now should recreate the brushes...");
    //             reset widgets palette
    //             QObjectList *kids = widget->children();
                QObjectList *kids = widget->queryList("QWidget"); //this is crappy slow, but children returns a const list... f*ckf*ckf*ck
                for (uint i= 0; i < kids->count(); i++){
                    QWidget *kid = (QWidget*)kids->at(i);
                    if (!(kid->isTopLevel() || kid->inherits( "KonqIconViewWidget" ) || kid->inherits( "khtml"))){
                        pal = QPalette(kid->palette());
                        pal.setBrush ( QColorGroup::Background, brush );
                        kid->setPalette(pal);
                    }
                }
                delete kids;
                return FALSE;
            }
            else if ( obj->inherits( "KActiveLabel" )){
                QWidget * w = ( QWidget * ) obj;
                QPalette pal( w->palette() );
                QPixmap *tile = pal.brush( QPalette::Active, QColorGroup::Background ).pixmap();
                if ( tile ) {
                    QSize sz( ev->type() == QEvent::Resize ? ( ( QResizeEvent* ) ev )->size() : w->size() );                                
                    QPixmap pix( sz.width(), sz.height() );
                    QPainter p;
                    if (optionHandler->BrushMe()){
                        p.begin( &pix );
                        // calc brush offsets
                        int tmpWidth;
                        if ((tmpWidth = pix.width()) > 1024){
                            int leftWidth = (tmpWidth-1024)/2;
                            int rightWidth = tmpWidth - leftWidth;
                            p.drawTiledPixmap(0, 0, leftWidth, sz.height(), plainBrush);
                            p.drawTiledPixmap(leftWidth, 0, 1024, sz.height(), gradBrush);
                            p.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, sz.height(), plainBrush);
                        }
                        else{
                                p.drawTiledPixmap(0, 0, tmpWidth, sz.height(), gradBrush, (1024-tmpWidth)/2, 0);
                        }
                        p.end();
                        QBrush brush( pal.active().background(), pix );
                        pal.setBrush( QColorGroup::Base, brush );
                        w->setPalette( pal );
                    }
                    else {
//                         qWarning("y: %d, h: %d, off: %d",w->y(),w->height(),w->backgroundOffset().y());
                        p.begin(w);
                        p.drawTiledPixmap(QRect(0,0,sz.width(),sz.height()), *tile, w->backgroundOffset());
                    }
                }
                return FALSE;
            }
            return FALSE;
            }
//         case QEvent::Create:
//         case QEvent::Destroy:
//         case QEvent::Hide:
//         case QEvent::Close:
//         case QEvent::Quit:
//         case QEvent::Reparent:
//         case QEvent::ShowMinimized:
//         case QEvent::ShowNormal:
//         case QEvent::WindowActivate:
//         case QEvent::WindowDeactivate:
//         case QEvent::ShowToParent:
//         case QEvent::HideToParent:
//         case QEvent::ShowMaximized:
//         case QEvent::ShowFullScreen:
//         case QEvent::Accel:
//         case QEvent::AccelAvailable:
//         case QEvent::CaptionChange:
//         case QEvent::IconChange:
//         case QEvent::ParentFontChange:
//         case QEvent::ApplicationFontChange:
//         case QEvent::ParentPaletteChange:
        case QEvent::ApplicationPaletteChange:
            if ( obj->inherits( "QTipLabel" ) ) {
                ( ( QWidget* ) obj ) ->setPalette( tooltipPalette );
                return TRUE;
            }
            return FALSE;
        case QEvent::PaletteChange:
            if (obj->inherits("QStatusBar")){
                ((QWidget*)obj)->setPalette(qApp->palette());
                return TRUE;
            }
            else if ( obj->inherits( "QTipLabel" ) ) {
                ( ( QWidget* ) obj ) ->setPalette( tooltipPalette );
                return TRUE;
            }
            return FALSE;
//         case QEvent::Clipboard:
//         case QEvent::Speech:
//         case QEvent::SockAct:
//         case QEvent::AccelOverride:
//         case QEvent::DeferredDelete:
//         case QEvent::DragEnter:
//         case QEvent::DragMove:
//         case QEvent::DragLeave:
//         case QEvent::Drop:
//         case QEvent::DragResponse:
//         case QEvent::ChildInserted:
//         case QEvent::ChildRemoved:
//         case QEvent::LayoutHint:
//         case QEvent::ShowWindowRequest:
//         case QEvent::WindowBlocked:
//         case QEvent::WindowUnblocked:
//         case QEvent::ActivateControl:
//         case QEvent::DeactivateControl:
//         case QEvent::ContextMenu:
//         case QEvent::IMStart:
//         case QEvent::IMCompose:
//         case QEvent::IMEnd:
//         case QEvent::Accessibility:
//         case QEvent::TabletMove:
//         case QEvent::LocaleChange:
//         case QEvent::LanguageChange:
//         case QEvent::LayoutDirectionChange:
//         case QEvent::Style:
//         case QEvent::TabletPress:
//         case QEvent::TabletRelease:
//         case QEvent::OkRequest:
//         case QEvent::HelpRequest:
//         case QEvent::WindowStateChange:
//         case QEvent::IconDrag:
//         case QEvent::User:
//         case QEvent::MaxUser:
        default:
            return FALSE;
    }
}

// bool LiquidStyle::eventFilter( QObject *obj, QEvent *ev ) {
// 
//     if ((ev->type() == QEvent::Resize || ev->type() == QEvent::Show ) && optionHandler->BrushMe() && obj->isWidgetType()){
//         QWidget* widget = (QWidget*)obj;
//         QResizeEvent* rev = (QResizeEvent*) ev;
//         // check if this is a toplevel widget, exclude some useless toplevelers and check for width change
//         if (widget->isTopLevel() &&
//         !(::qt_cast<QPopupMenu*>(widget) || ::qt_cast<QMenuBar*>(widget) || widget->isDesktop () || ::qt_cast<QListBox*>(widget) ||
//         widget->inherits("QTipLabel") || widget->inherits("AlphaWidget") || widget->inherits("ScrollWidget") ) && (ev->type() == QEvent::Show ||
//         rev->size().width() != rev->oldSize().width())){
//             // create new brushpix
//             QPixmap tmpBrushPix(ev->type() == QEvent::Show?widget->width():rev->size().width(), 52);
//             QPainter lightMe(&tmpBrushPix);
//             // calc brush offsets
//             int tmpWidth;
//             if ((tmpWidth = tmpBrushPix.width()) > 1024){
//                 int leftWidth = (tmpWidth-1024)/2;
//                 int rightWidth = tmpWidth - leftWidth;
//                 lightMe.drawTiledPixmap(0, 0, leftWidth, 52, plainBrush,256-leftWidth,0);
//                 lightMe.drawPixmap(leftWidth, 0, gradBrush);
//                 lightMe.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, 52, plainBrush);
//             }
//             else{
//                 lightMe.drawPixmap(0, 0, gradBrush, (1024-tmpWidth)/2, 0, tmpWidth);
//             }
//             lightMe.end();
//                 
//             //update palette
//             QPalette pal( qApp->palette());
//             QColor c( pal.active().background() );
//             QBrush brush( c, tmpBrushPix );
//             pal.setBrush ( QColorGroup::Background, brush );
//             //reset apps palette
//             qApp->setPalette(pal);
//             pal = QPalette(widget->palette());
//             pal.setBrush ( QColorGroup::Background, brush );
//             widget->setPalette(pal);
// //             qWarning("well, we now should recreate the brushes...");
// //             reset widgets palette
// //             QObjectList *kids = widget->children();
//             QObjectList *kids = widget->queryList("QWidget"); //this is crappy slow, but children returns a const list... f*ckf*ckf*ck
//             for (uint i= 0; i < kids->count(); i++){
//                 QWidget *kid = (QWidget*)kids->at(i);
//                 if (!((kid->isTopLevel() /*&& !kid->inherits( "QDockWindow" )*/) || kid->inherits( "KonqIconViewWidget" ) || kid->inherits( "khtml"))){
//                     pal = QPalette(kid->palette());
//                     pal.setBrush ( QColorGroup::Background, brush );
//                     kid->setPalette(pal);
//                 }
//             }
//             delete kids;
//             return FALSE;
//         }
//     }
//     if (KStyle::eventFilter( obj, ev ))
//         return TRUE;
//                 
// //     if (!obj->isWidgetType() ) {qWarning("NO WIDGET!");return false;}
// 
//     else if (::qt_cast<QMenuBar*>(obj)){
//         if ( ev->type() == QEvent::FocusIn || ev->type() == QEvent::Enter || ev->type() == QEvent::KeyPress) {
//             optionHandler->mouseOverMenu = true;
//         }
//         else if ( ev->type() == QEvent::FocusOut || ev->type() == QEvent::Leave) {
//             optionHandler->mouseOverMenu = false;
//         }
//         else if (ev->type() == QEvent::Paint){
//             QWidget *w = (QWidget *)obj;
//             if(w->backgroundMode() != Qt::PaletteBackground){
//                 w->setBackgroundMode(PaletteBackground);
//                 w->setBackgroundOrigin(QWidget::WindowOrigin);
//             return FALSE;
//             }
//         }
//     }
//     else if ( obj->inherits( "QDockWindow" ) ) {
//         QWidget * w = ( QWidget * ) obj;
//         if ( ev->type() == QEvent::Paint ) {
//             if ( w->backgroundMode() != Qt::PaletteBackground ) {
//                 w->setBackgroundMode( Qt::PaletteBackground );
//                 w->setBackgroundOrigin( QWidget::WindowOrigin );
//                 return FALSE;
//             }
//         }
//         else if (::qt_cast<KToolBar*>(obj)){
//             if (ev->type() == QEvent::Enter){
//                 QObjectList *handlerList = obj->queryList( "QDockWindowHandle" );
//                     for (uint i= 0; i < handlerList->count(); i++)
//                         ((QWidget*)(handlerList->at(i)))->repaint(false);
//             }
//             if (ev->type() == QEvent::Leave){
//             QObjectList *handlerList = obj->queryList( "QDockWindowHandle" );
//             for (uint i= 0; i < handlerList->count(); i++)
//                 ((QWidget*)(handlerList->at(i)))->repaint(false);
//             }
//         }
//     }
//     else if ( ::qt_cast<QPushButton*>(obj) || ::qt_cast<QComboBox*>(obj) ||
//     obj->inherits( "QSplitterHandle" ) ||
//     obj->inherits( "AppletHandleDrag" ) ) {
//         QWidget * btn = ( QWidget * ) obj;
// 
//         if ( ev->type() == QEvent::Enter ) {
//             if ( btn->isEnabled() ) {
//                 highlightWidget = btn;
//                 btn->repaint( false );
//             }
//         }
//         else if ( ev->type() == QEvent::Leave ) {
//             if ( btn == highlightWidget ) {
//                 highlightWidget = NULL;
//                 btn->repaint( false );
//             }
//         }
//         return FALSE;
//     }
//     else if ( ::qt_cast<QToolButton*>(obj) ) {
//         if ( ev->type() == QEvent::Paint ) {
//             QToolButton * btn = ( QToolButton * ) obj;
//             bool isTask = obj->inherits( "TaskContainer" );
//             if (!isTask){
//                 if (btn->backgroundOrigin() != QWidget::WindowOrigin)
//                     btn->setBackgroundOrigin( QWidget::WindowOrigin );
//                 return FALSE;
//             }
//             else{
//                 isTaskContainer = true;
//                 if ( currentTaskContainer == btn )
//                     taskContainerHover = true;
//                 else
//                     taskContainerHover = false;
//                 return FALSE;
//             }
//         }
//         else if ( ev->type() == QEvent::Enter ) {
//             bool isTask = obj->inherits( "TaskContainer" );
//             QToolButton * btn = ( QToolButton * ) obj;
//             if (isTask){
//                 currentTaskContainer = btn;
//                 btn->repaint( false );
//                 return FALSE;
//             }
//             else if ( btn->isEnabled() ) {
//                 highlightWidget = btn;
//                 btn->repaint( false );
//                 return FALSE;
//             }
//         }
//         else if ( ev->type() == QEvent::Leave ) {
//             bool isTask = obj->inherits( "TaskContainer" );
//             QToolButton * btn = ( QToolButton * ) obj;
//             if (isTask){
//                 currentTaskContainer = NULL;
//                 btn->repaint( false );
//                 return FALSE;
//             }
//             else if ( btn == highlightWidget ) {
//                     highlightWidget = NULL;
//                     btn->repaint( false );
//                     return FALSE;
//             }
//         }
//         return FALSE;
//     }
//     else if ( ::qt_cast<QScrollView*>(obj) ) {
//         QScrollView *sv = ( QScrollView * ) obj;
//         if ( ( ev->type() == QEvent::Enter )){
//             optionHandler->setScrollerActive();
//             if (!(highlightWidget == sv->verticalScrollBar()))
//                 sv->verticalScrollBar()->repaint(false);
//             if (!(highlightWidget == sv->horizontalScrollBar()))
//                 sv->horizontalScrollBar()->repaint(false);
//         }
//         else if( ev->type() == QEvent::Leave){
// //             QPoint upperLeftGlobal = sv->mapToGlobal(QPoint(0,0));
// //             QRect globalRect(upperLeftGlobal, sv->size());
// //             if ( !globalRect.contains( ((QMouseEvent*)ev)->globalPos() ) )  {
//             optionHandler->setScrollerInactive();
//             if (!(highlightWidget == sv->verticalScrollBar()))
//                     sv->verticalScrollBar()->repaint(false);
//             if (!(highlightWidget == sv->horizontalScrollBar()))
//                     sv->horizontalScrollBar()->repaint(false);
// //             }
//         }
// //         if (::qt_cast<QListBox*>(obj) && ev->type() == QEvent::ChildInserted) {
// //             QObject *kid = ((QChildEvent*)ev)->child();
// //             qWarning("",kid->className());
// //             if (kid->inherits("QListBoxItem"))
// //                 qWarning("%d",((QWidget*)kid)->height());
// //             return FALSE;
// //         }
//         if ( obj->inherits( "KActiveLabel" ) /*&& optionHandler->BrushMe()*/) {
//             if ( ev->type() == QEvent::Move || ev->type() == QEvent::Resize || ev->type() == QEvent::Show ) {
//                 QWidget * w = ( QWidget * ) obj;
//                 QPalette pal( w->palette() );
//                 QPixmap *tile = pal.brush( QPalette::Active, QColorGroup::Background ).pixmap();
//                 if ( tile ) {
//                     QSize sz( ev->type() == QEvent::Resize ? ( ( QResizeEvent* ) ev )->size() : w->size() );                                
//                     QPixmap pix( sz.width(), sz.height() );
//                     QPainter p;
//                     if (optionHandler->BrushMe()){
//                         p.begin( &pix );
//                         // calc brush offsets
//                         int tmpWidth;
//                         if ((tmpWidth = pix.width()) > 1024){
//                             int leftWidth = (tmpWidth-1024)/2;
//                             int rightWidth = tmpWidth - leftWidth;
//                             p.drawTiledPixmap(0, 0, leftWidth, sz.height(), plainBrush);
//                             p.drawTiledPixmap(leftWidth, 0, 1024, sz.height(), gradBrush);
//                             p.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, sz.height(), plainBrush);
//                         }
//                         else{
//                                 p.drawTiledPixmap(0, 0, tmpWidth, sz.height(), gradBrush, (1024-tmpWidth)/2, 0);
//                         }
//                         p.end();
//                         QBrush brush( pal.active().background(), pix );
//                         pal.setBrush( QColorGroup::Base, brush );
//                         w->setPalette( pal );
//                     }
//                     else {
// //                         qWarning("y: %d, h: %d, off: %d",w->y(),w->height(),w->backgroundOffset().y());
//                         p.begin(w);
//                         p.drawTiledPixmap(QRect(0,0,sz.width(),sz.height()), *tile, w->backgroundOffset());
//                     }
//                 }
//             }
//         }
//         return FALSE;
//     }
//     else if ( obj->inherits( "KateView" ) || obj->inherits( "TEWidget") || obj->inherits("CHexViewWidget")) {
//         if ( ( ev->type() == QEvent::Enter )){
//             QObjectList *scrollerList = obj->queryList( "QScrollBar" );
//             optionHandler->setScrollerActive();
//             for (uint i= 0; i < scrollerList->count(); i++)
//                     ((QWidget*)(scrollerList->at(i)))->repaint(false);
//         }
//         else if( ev->type() == QEvent::Leave )  {
//             QObjectList *scrollerList = obj->queryList( "QScrollBar" );
//             optionHandler->setScrollerInactive();
//             for (uint i= 0; i < scrollerList->count(); i++)
//                     ((QWidget*)(scrollerList->at(i)))->repaint(false);
//         }
//         return FALSE;
//     } 
//     else if (obj->inherits("KDockWidgetAbstractHeaderDrag")){
//         if ( ev->type() == QEvent::Enter || ev->type() == QEvent::Leave )
//             ((QWidget *)obj)->repaint();
//     }
//     else if ( ::qt_cast<QScrollBar*>(obj) ) {
//     QScrollBar * sb = ( QScrollBar * ) obj;
//         if ( ev->type() == QEvent::Enter && !sb->draggingSlider() ) {
//             if (optionHandler->AnimateSlider()){
//                 // generating animation stuff
//                 WidgetAnimator *scrollbarAnimator = animatedWidgetDict[sb->winId()];
//                 if (!scrollbarAnimator){
//                     scrollbarAnimator = new WidgetAnimator(sb, 0);
//                     scrollbarAnimator->setActiveWidget((QWidget **)(&activeScroller));
//                     animatedWidgetDict.insert(sb->winId(), scrollbarAnimator);
//                 }
//             }
//             if ( sb->isEnabled() ) {
//                     activeScroller = sb;
//                     highlightWidget = sb;
//                     sb->repaint( false );
//             }
//         }
//         else if ( ev->type() == QEvent::Leave ) {
//             if ( sb == highlightWidget && !sb->draggingSlider() ) {
//                 activeScroller = NULL;
//                 highlightWidget = NULL;
//                 sb->repaint( false );
//             }
//         }
//         else if ( ev->type() == QEvent::MouseButtonPress ){
//             activeScroller = NULL;
//             sb->repaint( false );
//         }
//         else if ( ev->type() == QEvent::MouseButtonRelease ) {
//             QMouseEvent * me = ( QMouseEvent * ) ev;
//             if ( sb == highlightWidget){
//                 if ( sb->rect().contains( me->pos() ) ) {
//                     activeScroller = sb;
//                     // assume, that the user wants to work on in this scrollview, so keep hW = sb
// //                     highlightWidget = NULL;
//                     sb->repaint( false );
//                 }
//                 else {
//                     // this assumes, scrollers are either on the right 
//                     if ( ((sb->orientation() == Vertical) && (me->pos().x() < 0)) || ((sb->orientation() == Horizontal) && (me->pos().y() < 0)) ) {
//                         optionHandler->setScrollerActive();
// //                         activeScroller = NULL;
//                         sb->repaint( false );
//                     }
//                 }
//             }
//         }
//         return FALSE;
//     }
//     else if (obj->inherits("QStatusBar") && ev->type() == QEvent::PaletteChange){
// //         QWidget *widget = (QWidget*)obj;
// //         QPixmap tmpBrushPix(widget->width(), 52);
// //         if (optionHandler->BrushMe()){
// //             QPainter lightMe(&tmpBrushPix);
// //             calc brush offsets
// //             int tmpWidth;
// //             if ((tmpWidth = tmpBrushPix.width()) > 1024){
// //                 int leftWidth = (tmpWidth-1024)/2;
// //                 int rightWidth = tmpWidth - leftWidth;
// //                 lightMe.drawTiledPixmap(0, 0, leftWidth, 52, plainBrush);
// //                 lightMe.drawPixmap(leftWidth, 0, gradBrush);
// //                 lightMe.drawTiledPixmap(leftWidth + 1024, 0, rightWidth, 52, plainBrush);
// //             }
// //             else{
// //                 lightMe.drawPixmap(0, 0, gradBrush, (1024-tmpWidth)/2, 0, tmpWidth);
// //             }
// //             lightMe.end();
// //             QPalette pal = QPalette(widget->palette());
// //             QColor c( pal.active().background() );
// //             QBrush brush( c, tmpBrushPix );
// //             blockSignals( TRUE );
// //             pal.setBrush ( QColorGroup::Background, brush );
// //             blockSignals( FALSE );
// //             widget->blockSignals( TRUE );
// //             qWarning("stage 1");
// //             widget->setPalette(pal);
// //             qWarning("stage 2");
// //             widget->blockSignals( FALSE );
// //             qWarning("stage 3");
// //         }
// //         else{
// //             widget->blockSignals( TRUE );
//         ((QWidget*)obj)->setPalette(qApp->palette());
// //         widget->blockSignals( FALSE );
// //         }
//         return FALSE;
//     }
//     else if (obj->inherits( "KAnimWidget" )){
//         if (ev->type() == QEvent::Enter || ev->type() == QEvent::Leave)
//             return TRUE;
//         else if (ev->type() == QEvent::MouseButtonPress)
//             ((QFrame *)obj)->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
//         else if (ev->type() == QEvent::MouseButtonRelease)
//             ((QFrame *)obj)->setFrameShape(QFrame::NoFrame);
//     }
// //     else if ( obj->inherits( "KMiniPagerButton" ) ) {
// //         QButton * btn = ( QButton * ) obj;
// //         if ( ev->type() == QEvent::Paint ) {
// //             if ( pagerBrush.pixmap() == NULL ) {
// //                 // color scheme has changed
// //                 QColor c( optionHandler->usePanelCustomColor() ?
// //                             optionHandler->panelCustomColor().dark( 110 ) :
// //                             qApp->palette().active().button().dark( 110 ) );
// //                 QPixmap *pix = smallBevelFillDict.find( c.rgb() );
// //                 if ( !pix ) {
// //                     pix = new QPixmap( *smallBevelFillPix );
// //                     adjustHSV( *pix, c );
// //                     smallBevelFillDict.insert( c.rgb(), pix );
// //                 }
// //                 pagerHoverBrush.setColor( c );
// //                 pagerHoverBrush.setPixmap( *pix );
// //                 c = c.dark( 115 );
// //                 pix = smallBevelFillDict.find( c.rgb() );
// //                 if ( !pix ) {
// //                     pix = new QPixmap( *smallBevelFillPix );
// //                     adjustHSV( *pix, c );
// //                     smallBevelFillDict.insert( c.rgb(), pix );
// //                 }
// //                 pagerBrush.setColor( c );
// //                 pagerBrush.setPixmap( *pix );
// //             }
// //             if ( !( btn->isOn() || btn->isDown() ) ) {
// //                 QPalette pal = qApp->palette();
// //                 pal.setBrush( QColorGroup::Dark, btn == highlightWidget ? pagerHoverBrush : pagerBrush );
// //                 btn->setPalette( pal );
// //             }
// //             else {
// //                 QPalette pal = qApp->palette();
// //                 pal.setBrush( QColorGroup::Dark, QApplication::palette().active().brush( QColorGroup::Dark ) );
// //                 btn->setPalette( pal );
// //             }
// //         }
// //         else if ( ev->type() == QEvent::Enter ) {
// //             highlightWidget = btn;
// //             btn->repaint( false );
// //         }
// //         else if ( ev->type() == QEvent::Leave ) {
// //             highlightWidget = NULL;
// //             btn->repaint( false );
// //         }
// //         return FALSE;
// //     } 
//     else if ( obj->inherits( "QLineEdit" ) ) {
//         if ( QObject *daddy = obj->parent()){
//             if (/*daddy->inherits( "QComboBox" )*/ ::qt_cast<QComboBox*>(daddy)) {
//                 QWidget * btn = ( QWidget * ) daddy;
//                 if ( ev->type() == QEvent::Enter ) {
//                     if ( btn->isEnabled() ) {
//                         highlightWidget = btn;
//                         btn->repaint( false );
//                     }
//                 }
//                 else if ( ev->type() == QEvent::Leave ) {
//                     if ( btn == highlightWidget )
//                         highlightWidget = NULL;
//                     btn->repaint( false );
//                 }
//             }
//             else if ( daddy->inherits( "QSpinWidget" ) ) {
//                 if ((ev->type() == 8/*QEvent::FocusIn*/) || (ev->type() == 9/*QEvent::FocusOut*/))
//                     ((QWidget *)daddy)->repaint(false);
//             }
//             else if ((ev->type() == 8/*QEvent::FocusIn*/) || (ev->type() == 9/*QEvent::FocusOut*/))
//                 ((QWidget *)obj)->repaint(false);
//         }
//         else if ((ev->type() == 8/*QEvent::FocusIn*/) || (ev->type() == 9/*QEvent::FocusOut*/))
//             ((QWidget *)obj)->repaint(false);
//         return FALSE;
//     }
//     else if ( obj->inherits( "QRadioButton" ) || obj->inherits( "QCheckBox" ) ) {
//         QButton * btn = ( QButton * ) obj;
//         bool isStatusChild = btn->parent() && ( btn->parent() ->inherits( "QStatusBar" ) || btn->parent() ->inherits( "KonqFrameStatusBar" ) );
//         bool isRadio = obj->inherits( "QRadioButton" );
//     
//         if ( ev->type() == QEvent::Paint ) {
//             btn->erase();
//             QPainter p;
//             p.begin( btn );
//             QFontMetrics fm = btn->fontMetrics();
//             QSize lsz = fm.size( ShowPrefix, btn->text() );
//             QSize sz = isRadio ?
//             QSize( pixelMetric( PM_ExclusiveIndicatorWidth ), pixelMetric( PM_ExclusiveIndicatorHeight ) ) :
//             QSize( pixelMetric( PM_IndicatorWidth ), pixelMetric( PM_IndicatorHeight ) );
//             int x = 0;
//             int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
//             SFlags flags = Style_Default;
//             if ( btn->isEnabled() )
//                 flags |= Style_Enabled;
//             if ( btn->hasFocus() )
//                 flags |= Style_HasFocus;
//             if ( btn->isDown() )
//                 flags |= Style_Down;
//             if ( highlightWidget == btn )
//                 flags |= Style_MouseOver;
//             if ( btn->state() == QButton::On )
//                 flags |= Style_On;
//             else if ( btn->state() == QButton::Off )
//                 flags |= Style_Off;
//             if ( isRadio )
//                 drawControl( CE_RadioButton, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
//             else
//                 drawControl( CE_CheckBox, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
//             x = sz.width() + 6;
//             y = 0;
//             if ( btn->hasFocus() ) {
//                 QColor tmp( btn->colorGroup().background().dark( 130 ) );
//                 drawItem( &p, QRect( sz.width() + 6 + 2, 1, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1, &tmp );
//                 drawItem( &p, QRect( sz.width() + 6 + 3, 2, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1, &tmp );
//             }
//             drawItem( &p, QRect( sz.width() + 6 + 1, 0, btn->width() - ( sz.width() + 6 + 1 ), btn->height() ), AlignLeft | AlignVCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text() );
//             p.end();
//             return TRUE;
//         }
//         // for hover, just redraw the indicator (not the text)
//         else if ( ( ev->type() == QEvent::Enter && btn->isEnabled() ) || ( ev->type() == QEvent::Leave && btn == highlightWidget ) ) {
//             QButton * btn = ( QButton * ) obj;
//             bool isRadio = obj->inherits( "QRadioButton" );
//             if ( ev->type() == QEvent::Enter )
//                 highlightWidget = btn;
//             else
//                 highlightWidget = NULL;
//             QFontMetrics fm = btn->fontMetrics();
//             QSize lsz = fm.size( ShowPrefix, btn->text() );
//             QSize sz = isRadio ?
//                         QSize( pixelMetric( PM_ExclusiveIndicatorWidth ), pixelMetric( PM_ExclusiveIndicatorHeight ) ) :
//                         QSize( pixelMetric( PM_IndicatorWidth ), pixelMetric( PM_IndicatorHeight ) );
//             int x = 0;
//             int y = isStatusChild ? 0 : ( btn->height() - lsz.height() + fm.height() - sz.height() ) / 2;
//             //if(btn->autoMask())
//             //    btn->erase(x+1, y+1, sz.width()-2, sz.height()-2);
//             QPainter p;
//             p.begin( btn );
//             SFlags flags = Style_Default;
//             if ( btn->isEnabled() )
//                 flags |= Style_Enabled;
//             if ( btn->hasFocus() )
//                 flags |= Style_HasFocus;
//             if ( btn->isDown() )
//                 flags |= Style_Down;
//             if ( highlightWidget == btn )
//                 flags |= Style_MouseOver;
//             if ( btn->state() == QButton::On )
//                 flags |= Style_On;
//             else if ( btn->state() == QButton::Off )
//                 flags |= Style_Off;
//             if ( isRadio )
//                 drawControl( CE_RadioButton, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
//             else
//                 drawControl( CE_CheckBox, &p, btn, QRect( x, y, sz.width(), sz.height() ), btn->colorGroup(), flags );
//             p.end();
//         }
//         return FALSE;
//     }
//     else if ( ::qt_cast<QHeader*>(obj) ) {
//         QHeader * hw = ( QHeader * ) obj;
//         if ( ev->type() == QEvent::MouseMove ) {
//             QMouseEvent * me = ( QMouseEvent * ) ev;
//             int oldHeader = headerHoverID;
//             headerHoverID = hw->sectionAt( me->x() + hw->offset());
//             if ( oldHeader != headerHoverID ) {
//                 // reset old header
//                 if ( oldHeader != -1 ) {
//                     hw->repaint( hw->sectionPos( oldHeader )-hw->offset(), 0, hw->sectionSize( oldHeader ), hw->height(), false );
//                 }
//                 if ( headerHoverID != -1 ) {
//                         hw->repaint( hw->sectionPos( headerHoverID )-hw->offset(), 0, hw->sectionSize( headerHoverID ), hw->height(), false );
//                 }
//             }
//             return FALSE;
//         }
//         else if ( ev->type() == QEvent::Paint ) {
//             if (hw->parentWidget() && ::qt_cast<QListView*>(hw->parentWidget()))
//                 headerSortID = ((QListView*)hw->parentWidget())->sortColumn();
//         }
//         else if ( ev->type() == QEvent::Enter ) {
//             currentHeader = hw;
//             headerHoverID = -1;
//             return FALSE;
//         }
//         else if ( ev->type() == QEvent::Leave ) {
//             currentHeader = NULL;
//             if ( headerHoverID != -1 ) {
//                 hw->repaint( hw->sectionPos( headerHoverID )-hw->offset(), 0, hw->sectionSize( headerHoverID ), hw->height(), false );
//             }
//             headerHoverID = -1;
//             return FALSE;
//         }
//         else if ( ev->type() == QEvent::MouseButtonRelease && hw->parentWidget() && ::qt_cast<QListView*>(hw->parentWidget())){
//             QMouseEvent * me = ( QMouseEvent * ) ev;
//             headerSortID = hw->sectionAt( me->x() + hw->offset());
//             return FALSE;
//         }
//         return FALSE;
//     }
//     else if (::qt_cast<QTabBar*>(obj)){ 
//         QTabBar *tb = (QTabBar*)obj;
//         QRect tmpRect;
//         bool done = false;
//         if ( ev->type() == QEvent::Enter ) {
//             currentTabBar = tb;
//             hoveredTabIndex = -1;
//         }
//         else if ( ev->type() == QEvent::Leave ) {
//             currentTabBar = NULL;
//             if ( hoveredTabIndex != -1 ) {
//                 QTab *tmpTab = tb->tabAt(hoveredTabIndex);
//                 if (tmpTab) tb->repaint( tmpTab->rect(), false );
//             }
//             hoveredTabIndex = -1;
//         }
//         else if ( ev->type() == QEvent::MouseMove ) {
//             QMouseEvent *me = ( QMouseEvent*)ev;
//             int oldTab = hoveredTabIndex;
//             if (hoveredTabIndex == -1){
//                 for (int i = 0; i < tb->count(); i++){
//                     if (tb->tabAt(i)){
//                         tmpRect = tb->tabAt(i)->rect();
//                         if ( tmpRect.x() < me->x() && me->x() < tmpRect.right()){
//                             hoveredTabIndex = i;
//                             break;
//                         }
//                     }
//                 }
//             }
//             else{
//                 if ((oldTab > 0) && tb->tabAt(oldTab-1)){
//                     tmpRect = tb->tabAt(oldTab-1)->rect();
//                     if ((tmpRect.x() < me->x()) && (me->x() < tmpRect.right())){
//                         hoveredTabIndex = oldTab-1;
//                         done = true;
//                     }
//                 }
//                 if (!done && (oldTab < tb->count()-1) && tb->tabAt(oldTab+1)){
//                     tmpRect = tb->tabAt(oldTab+1)->rect();
//                     if ((tmpRect.x() < me->x()) && (me->x() < tmpRect.right())){
//                         hoveredTabIndex = oldTab+1;
//                     }
//                 }
//             }
//             if ( oldTab != hoveredTabIndex ) {
//                 // reset old tab
//                 if ( oldTab != -1 ) {
//                     if (tb->tabAt(oldTab)) tb->repaint( tb->tabAt(oldTab)->rect(), false );
//                 }
//                 if ( hoveredTabIndex != -1 ) {
//                     tb->repaint( tmpRect, false );
//                 }
//             }
// //             qWarning("move action finished");
//         }
//         return FALSE;
//     }
//     else if ( obj->inherits( "QTipLabel" ) ) {
//         if ( ev->type() == QEvent::PaletteChange || ev->type() == QEvent::ApplicationPaletteChange ) {
// //             qWarning( "Got tiplabel palette change" ); // Debug
//             ( ( QWidget* ) obj ) ->setPalette( tooltipPalette );
//             return TRUE;
//         }
//     }
//     if (obj->inherits( "KColorGrid" ) && ev->type() == QEvent::Paint){
//         QPaintEvent *pev = (QPaintEvent *)ev;
//         if (pev->rect().width() == 0 || pev->rect().height() == 0)
//             return TRUE;
//         else
//             return FALSE;
//     }
//     if ( !qstrcmp(obj->name(), "kde toolbar widget") ){
//         QWidget* lb = static_cast<QWidget*>(obj);
//         if (lb->backgroundMode() == Qt::PaletteButton)
//             lb->setBackgroundMode(Qt::PaletteBackground);
//         lb->removeEventFilter(this);
//         return FALSE;
//     }
//     return ( false );
// }
