//#include <qdir.h>
#include "baghira.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <qapplication.h>
#include <qbrush.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <qcursor.h>
#include <qdialog.h>
#include <qframe.h>
#include <qfile.h>
#include <qheader.h>
#include <qgroupbox.h>
//#include <qiconview.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistbox.h>
//#include <qlistview.h>
#include <qmenubar.h>
#include <qpalette.h>
#include <qpainter.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qscrollbar.h>
#include <qscrollview.h>
#include <qsizepolicy.h> 
#include <qslider.h>
#include <qtabbar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
//#include <qsizegrip.h>
//#include <qstatusbar.h>
#include <kpixmapeffect.h>

void LiquidStyle::polish( QPalette &pal ) {
    if ( inExitPolish )
            return ;
    
    // clear out all old colorized pixmaps
    int i;
    for ( i = 0; i < BITMAP_ITEMS; ++i ) {
            if ( pixmaps[ i ] ) {
                    delete pixmaps[ i ];
                    pixmaps[ i ] = NULL;
                    }
            }
    // clear out all dicts
    btnDict.clear();
    btnShadowedDict.clear();
    bevelFillDict.clear();
    smallBevelFillDict.clear();
//     optionHandler->pixDict.clear();
    optionHandler->popupDict.clear();
    // reset brushes
    pagerHoverBrush = QBrush();
    pagerBrush = QBrush();

    /**
    * Okay, here's the deal. We might need to set the application
    * background brush with a pixmap stipple or a custom kicker color.
    * It wouldn't be much of a problem but Qt calls this method for a lot
    * of different palettes, not just the application's, so we really don't
    * know what we are changing and if the QPalette parameter is actually
    * the application's colors or something like a tooltip.
    *
    * This used to mean I'd check the timestamp of .qt/qtrc and reload the
    * entire palette if it has changed. Now we just assume the QPalette
    * parameter is the new application palette. Much more efficent :)
    */

    bool newPalette = false;
    struct stat buffer;
    if ( stat( QFile::encodeName( QDir::homeDirPath() + "/.qt/qtrc" ), &buffer ) == 0 ) {
        unsigned int lastModTime = ( unsigned int ) buffer.st_mtime;
        if ( lastModTime > qtrcModificationTime ) {
            qtrcModificationTime = lastModTime;
            newPalette = true;
        }
    }
    else if ( !initialPaletteLoaded )  // Hack, should always have qtrc in KDE
        newPalette = true;
    initialPaletteLoaded = true;

    if ( !newPalette ) {
        pal = polishedPalette;
        return ;
    }
        
    pal.setColor( QColorGroup::Button, optionHandler->CustomButtonColor() );

    // only executed on first run or if qtrc has changed
    if ( isKicker ) {
        origPanelBrush = pal.brush( QPalette::Active, QColorGroup::Background );
        origPanelPalette = pal;
        QColor c( pal.active().button() );
        if ( optionHandler->usePanelCustomColor() && optionHandler->panelCustomColor().isValid() ){
            c = optionHandler->panelCustomColor();
        }

        pal.setColor( QColorGroup::Mid, c.dark( 110 ) );
        pal.setColor( QColorGroup::Dark, c.dark( 130 ) );
        pal.setColor( QColorGroup::Midlight, c.light( 110 ) );
        pal.setColor( QColorGroup::Light, c.light( 115 ) );
        if (optionHandler->BrushMe()){
            QBrush brush( c, gradBrush );
            pal.setBrush( QColorGroup::Background, brush );
        }
        else if ( optionHandler->usePanelStipple() ) {
            QPixmap stipple( 64, 64 );
            stipple.fill( c.rgb() );
            QPainter p;
            p.begin( &stipple );
            p.setPen( c.dark( 100 + (int)(optionHandler->stippleContrast()/2) ) );
            for ( i = 1; i < 64; i += 4 ) {
                p.drawLine( 0, i, 63, i );
                p.drawLine( 0, i+2, 63, i+2 );
                }
            p.setPen( c.dark( 100 + optionHandler->stippleContrast() ) );
            for ( i = 2; i < 63; i += 4 ) {
                p.drawLine( 0, i, 63, i );
                }
            p.end();
            QBrush brush( c, stipple );
                pal.setBrush( QColorGroup::Background, brush );
        }
        else
            pal.setBrush( QColorGroup::Background, c );
    }
    else if (optionHandler->BrushMe()){
        QColor c( pal.active().background() );
        QBrush brush( c, gradBrush );
        pal.setBrush( QColorGroup::Background, brush );
    }
    else if ( !isPlain() ) {
        origPanelBrush = pal.brush( QPalette::Active,QColorGroup::Button );
        QColor c( pal.active().background() );
        QPixmap stipple( 64, 64 );
        stipple.fill( c.rgb() );
        QPainter p;
        p.begin( &stipple );
        p.setPen( c.dark( 100 + (int)(optionHandler->stippleContrast()/2) ) );
        for ( i = 1; i < 64; i += 4 ) {
            p.drawLine( 0, i, 63, i );
            p.drawLine( 0, i+2, 63, i+2 );
        }
        p.setPen( c.dark( 100 + optionHandler->stippleContrast() ) );
        for ( i = 2; i < 63; i += 4 ) {
            p.drawLine( 0, i, 63, i );
        }
        p.end();
        QBrush brush( c, stipple );
        pal.setBrush( QColorGroup::Background, brush );
    }
    
    if (optionHandler->bevelHighlights()){
        QColor c(pal.active().highlight());
        QColor c2(c.light(140));
        QPixmap pix2 = QPixmap(48,48);
        QPainter coolPainter(&pix2);
        KPixmap pix = QPixmap(48,24);
        KPixmapEffect::gradient(pix,c,c2,KPixmapEffect::VerticalGradient,0);
        coolPainter.drawPixmap(0,0,pix);
        KPixmapEffect::gradient(pix,c2,c,KPixmapEffect::VerticalGradient,0);
        coolPainter.drawPixmap(0,24,pix);
        QBrush brush(c, pix2);
        pal.setBrush(QColorGroup::Highlight, brush);
    }
    
    polishedPalette = pal;
    optionHandler->reset();
    }

void LiquidStyle::unPolish( QApplication *app ) {

    QPalette pal( app->palette() );
    inExitPolish = true;
    if ( isKicker ) {
        // reset kicker
        QColor c = origPanelBrush.color();
        pal.setBrush( QColorGroup::Background, c );
        pal.setBrush( QColorGroup::Mid, c.dark( 110 ) );
        pal.setBrush( QColorGroup::Dark, c.dark( 130 ) );
        pal.setBrush( QColorGroup::Midlight, c.light( 110 ) );
        pal.setBrush( QColorGroup::Light, c.light( 115 ) );
//         app->blockSignals( TRUE );
        app->setPalette( pal );
//         app->blockSignals( FALSE );
        }
        else if ( !isPlain() ) {
            // reset any stipples
            if ( pal.brush( QPalette::Active, QColorGroup::Background ).pixmap() )
                    pal.setBrush( QColorGroup::Background, pal.active().background() );
            if ( pal.brush( QPalette::Active, QColorGroup::Button ).pixmap() )
                    pal.setBrush( QColorGroup::Button, pal.active().button() );
//             app->blockSignals( TRUE );
            app->setPalette( pal );
//             app->blockSignals( FALSE );
        }

        inExitPolish = false;
        }

void LiquidStyle::polish( QWidget *w ) {

//         bool testWidget = w->inherits("QtVisionView");
//         int testInt = 0;
        
//         if (w->isTopLevel())
//        if (qstrcmp( w->name(), "kde toolbar widget" ) == 0 )
//             qWarning("class %s",w->className());
        
        bool tmpBool = false;
        bool isViewport = qstrcmp( w->name(), "qt_viewport" ) == 0 || qstrcmp( w->name(), "qt_clipped_viewport" ) == 0;
	bool isViewportChild = w->parent() && ( ( qstrcmp( w->parent() ->name(), "qt_viewport" ) == 0 ) || ( qstrcmp( w->parent() ->name(), "qt_clipped_viewport" ) == 0 ) );
        
        if (w->inherits("KColorGrid")){
            // kiconedit doesn't check for the paintevent rect size, but tries to create a (possibly) NULL Pixmap (after palette change event e.g.)
            // so we catch it's paint event and destroy it if the size is NULL
            // remove this after kiconedit corrected its code
            w->installEventFilter( this );
            w->setBackgroundMode(QWidget::PaletteBase);
            goto kstpolish;
        }
        
        if ( ::qt_cast<QPopupMenu*>(w) /*w->inherits( "QPopupMenu" )*/){
		optionHandler->prepareMenus();
		w->installEventFilter( optionHandler);
		w->setBackgroundMode( NoBackground );
		goto kstpolish;
	}
        
//         if (w->inherits("QListBoxItem") && w->parentWidget() && ::qt_cast<QListBox*>(w->parentWidget()) && ((QListBox*)w->parentWidget())->selectionMode() == QListBox::Single){
//             qWarning("single select item found");
//             goto kstpolish;
//         }

   
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

        //if (testWidget) qWarning("testwidget stage %d",testInt++);

// 	// first test, if we are toplevel...
	if (optionHandler->BrushMe() && w->isTopLevel() && !( ::qt_cast<QPopupMenu*>(w) || ::qt_cast<QMenuBar*>(w) || w->isDesktop() || ::qt_cast<QListBox*>(w) || w->inherits("QTipLabel") || w->inherits("AlphaWidget") || w->inherits("ScrollWidget") || w->inherits("PlayerWidget"))){
		w->installEventFilter( this );
	}

        //if (testWidget) qWarning("testwidget stage %d",testInt++);
        if (qstrcmp( w->name(), "kde toolbar widget" ) == 0 ) w->installEventFilter( this );
        
        if (w->inherits("QButton")){
            w->setBackgroundOrigin(QWidget::WindowOrigin);
        }
        
        if (::qt_cast<QPushButton*>(w)/*w->inherits( "QPushButton" )*/){
		w->setBackgroundMode( QWidget::PaletteBackground);
                w->setBackgroundOrigin(QWidget::WindowOrigin);
		w->installEventFilter( this );
//		return;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	if (::qt_cast<QComboBox*>(w)){
		w->setBackgroundMode(NoBackground);
		w->installEventFilter( this );
                w->setBackgroundOrigin(QWidget::WindowOrigin);
//		return;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
	if (w->inherits("TaskBar")){
		w->setBackgroundOrigin(QWidget::WidgetOrigin);
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
        if ( isViewportChild && (::qt_cast<QPushButton*>(w) || w->inherits( "QRadioButton" ) || w->inherits( "QComboBox" ))) {
	// shape radiobuttons on html pages...
		w->setAutoMask( true );
		w->setBackgroundMode( QWidget::NoBackground );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
	if (w->inherits("KDockWidgetAbstractHeaderDrag")){
		w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	

	if (w->inherits("QSpinWidget")){
		w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
	
	if ( !isPlain () && (w->inherits( "KonqIconViewWidget" ) || w->inherits( "khtml")/* || w->inherits( "QtVisionView")*/)) {
	// if you want custom backgrounds in konqueror, you have to reset pixmap, since Konq animation can't handle it
	// original liquid did this on khtml, too (at speed loss) so well see, if we get errors from this...
		QPalette pal( w->palette() );
		pal.setBrush( QColorGroup::Background, pal.active().background() );
		w->setPalette( pal );
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
        if ( w->inherits( "KActiveLabel" )) {
            w->setBackgroundMode( QWidget::PaletteBackground );
            w->setBackgroundOrigin(QWidget::WindowOrigin);
        }
        if ((::qt_cast<QScrollView*>(w) || w->inherits("KateView") || w->inherits("TEWidget") || w->inherits("CHexViewWidget")) && !(w->isA("KOAgenda"))){
//             if (::qt_cast<QListBox*>(w)){
//                 int height = ((QListBox*)w)->itemHeight();
//                 if (height >  0){
//                     QPalette pal = w->palette();
//                     QColor c(pal.active().highlight());
//                     QColor c2(c.light(140));
//                     KPixmap pix = QPixmap(48,height);
//                     KPixmapEffect::gradient(pix,c2,c,KPixmapEffect::VerticalGradient,0);
//                     QBrush brush(c, pix);
//                     pal.setBrush(QColorGroup::Highlight, brush);
//                     w->setPalette(pal);
//                 }
//             }
		w->setMouseTracking( true );
		w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
 	else if (w->inherits("QStatusBar")) {
            w->setBackgroundOrigin(QWidget::WindowOrigin);
            if ( qstrcmp( qApp->argv() [ 0 ], "konqueror" ) == 0 )
 		w->installEventFilter( this );
            goto kstpolish;
 	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
        
        if (w->inherits("QSplitterHandle")) {
 		w->setBackgroundOrigin(QWidget::WindowOrigin);
 		w->installEventFilter( this );
                goto kstpolish;
 	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
        if (::qt_cast<QSlider*>(w)){
 		w->setBackgroundMode( QWidget::NoBackground );
                goto kstpolish;
 	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
// 	else if (w->isTopLevel() && (w->minimumSize() != w->maximumSize())){
// 		QSizeGrip *grip = new QSizeGrip(w);
// 		goto kstpolish;
// 	}
	
	if (w->inherits( "TaskContainer" )){
//            w->setMouseTracking( TRUE );
            w->installEventFilter( this );
            goto kstpolish;
        }
	
        if ( w->isA( "AppletHandleDrag" ) || w->inherits( "KMiniPagerButton" ) || w->inherits( "QLineEdit" ) ) {
                w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	

	if ( !isPlain() ) {
	if ( !isViewport && w->parent() && qstrcmp( w->parent() ->name(), "proxyview" ) == 0 ) {
			w->setBackgroundOrigin( QWidget::WindowOrigin );
			goto kstpolish ;
		}
                //if (testWidget) qWarning("testwidget stage %d",testInt++);
		

// 		if ( w->ownPalette() && !w->inherits( "QButton" ) && !w->inherits( "QComboBox" ) )
// 			goto kstpolish ;
	//if (testWidget) qWarning("testwidget stage %d",testInt++);

		if ( w->inherits( "PanelButtonBase" ) )
			goto kstpolish ;
	//if (testWidget) qWarning("testwidget stage %d",testInt++);	
			
		if ( !isKicker&& !isViewport && !isViewportChild && !w->testWFlags( WType_Popup ) && !w->inherits( "KDesktop" ) && !w->inherits( "PasswordDlg" ) ) {
			if ( w->backgroundMode() == QWidget::PaletteBackground || w->backgroundMode() == QWidget::PaletteButton ) {
				w->setBackgroundOrigin( QWidget::WindowOrigin );
				}
			}
		}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	if ( ::qt_cast<QPushButton*>(w) || ::qt_cast<QComboBox*>(w)) goto kstpolish;
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	

	if ( ::qt_cast<QMenuBar*>(w)) {
//             if (optionHandler->BrushMe() && w->isTopLevel()){
//             QPalette pal(w->palette());
//             QColor c( pal.active().background() );
//             if ( optionHandler->usePanelCustomColor() && optionHandler->panelCustomColor().isValid() ){
//                 c = optionHandler->panelCustomColor();
//             }
//             if ( optionHandler->usePanelStipple() ) {
//                 QPixmap stipple( 64, 64 );
//                 stipple.fill( c.rgb() );
//                 QPainter p;
//                 p.begin( &stipple );
//                 p.setPen( c.dark( 100 + (int)(optionHandler->stippleContrast()/2) ) );
//                 for (int i = 1; i < 64; i += 4 ) {
//                     p.drawLine( 0, i, 63, i );
//                     p.drawLine( 0, i+2, 63, i+2 );
//                 }
// 		p.setPen( c.dark( 100 + optionHandler->stippleContrast()) );
// 			for ( int i = 2; i < 63; i += 4 ) {
// 				p.drawLine( 0, i, 63, i );
// 				}
//                 p.end();
//                 QBrush brush( c, stipple );
//                 pal.setBrush( QColorGroup::Background, brush );
//             } else{
//                 pal.setBrush( QColorGroup::Background, c );
//             }
//             w->setPalette( pal );
//             }
            w->setBackgroundMode( QWidget::PaletteBackground );
            w->setBackgroundOrigin(QWidget::WindowOrigin);
            w->installEventFilter( this );
            goto kstpolish ;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	
        if (::qt_cast<QFrame*>(w)){
                w->setBackgroundOrigin(QWidget::WindowOrigin);
                if ( ::qt_cast<QLabel*>(w)){
                    if ( !isPlain() && !(w->inherits( "QTipLabel" ) || w->inherits( "KSystemTray" ))) {
                        w->setBackgroundMode( QWidget::PaletteBackground );
                    }
                    else if ( w->inherits( "QTipLabel" ) ) {
                                w->setPalette( tooltipPalette );
                                w->setBackgroundOrigin(QWidget::WidgetOrigin);
                                w->installEventFilter( this );
                    }
                }
                if (w->inherits( "KAnimWidget" )){
                    ((QFrame *)w)->setFrameShape(QFrame::NoFrame);
                    w->installEventFilter( this ); // the widget resets it's frameshape on mouseevents - looks crap!
                    goto kstpolish ;
                }
//                 else if (w->inherits("QWidgetStack") && w->parentWidget() && w->parentWidget()->parentWidget() && w->parentWidget()->parentWidget()->inherits("KonqMainWindow")){ // konqueror tabbar statusbar offset
//                     ((QFrame *)w)->setFrameShape(QFrame::NoFrame);
//                     goto kstpolish;
//                 }
                else if (((QFrame *)w)->frameShape() >= QFrame::Box && ((QFrame *)w)->frameShape() <= QFrame::WinPanel){
// 			qWarning("forcing down frameShape");
			((QFrame *)w)->setFrameShape(QFrame::StyledPanel);
                        goto kstpolish ;
		}
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
	
	 if ( w->parentWidget() && ( ( ::qt_cast<QListBox*>(w) && ::qt_cast<QPushButton*>(w->parentWidget())) || w->inherits( "KCompletionBox" ) ) ) {
		QListBox* listbox = (QListBox*) w;
		listbox->setBackgroundMode( NoBackground );
		w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	
	if (::qt_cast<QHeader*>(w)){
//                 if (::qt_cast<QListView*>(w->parentWidget()))
//                     headerSortID = ((QListView*)w->parentWidget())->sortColumn();
		w->setBackgroundMode( NoBackground );
		w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	
	if (::qt_cast<QTabBar*>(w)){
//                qWarning("installing tab event");
		w->setMouseTracking( true );
		w->installEventFilter( this );
                w->setBackgroundOrigin(QWidget::WindowOrigin);
		goto kstpolish;
	}
        
        if (::qt_cast<QGroupBox*>(w) && ((QGroupBox*)w)->frameShape() == QFrame::GroupBoxPanel && !((QGroupBox*)w)->isFlat()){
            if ( optionHandler->drawGroupBoxShadow() ){
            if ( isKicker ){ // kicker (and children) needs special handling again - otherwise the shadow pixmap won't be found and your GB will be completely black
                this->groupShadow = new QPixmap( 64, 64 );
                QColor c;
                ( optionHandler->MenuColorButton() ) ? c = QColor( optionHandler->buttonColor() ) : c = QColor( optionHandler->bgColor() );
                this->groupShadow->fill( ( c.dark( 100 + optionHandler->ShadowDarkness() ) ).rgb() );
                if ( optionHandler->useBgStipple() ) {
                    QPainter p;
                    p.begin( this->groupShadow );
                    p.setPen( c.dark( 100 + optionHandler->ShadowDarkness() + (int)(optionHandler->stippleContrast()/2) ) );
                    for ( int i = 1; i < 64; i += 4 ) {
                        p.drawLine( 0, i, 63, i );
                        p.drawLine( 0, i+2, 63, i+2 );
                    }
                    p.setPen( c.dark( 100 + optionHandler->ShadowDarkness() + optionHandler->stippleContrast() ) );
                    for ( int i = 2; i < 63; i += 4 ) {
                            p.drawLine( 0, i, 63, i );
                            }
                }
                w->setPaletteBackgroundPixmap ( *(this->groupShadow) );
            }
            else{
                w->setPaletteBackgroundPixmap ( *groupShadow );
            }
            }
            w->setBackgroundOrigin(QWidget::WindowOrigin);
        }
        //if (testWidget) qWarning("testwidget stage %d",testInt++);


	if (w->inherits("QProgressBar"))
	{
		w->setBackgroundMode( NoBackground );
		WidgetAnimator* progressAnimator = new WidgetAnimator(w, 2);
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
	
	if ( ::qt_cast<QToolBar*>(w)) {
 		if (optionHandler->useToolButtonFrame() && w->inherits("KToolBar")) ((QToolBar*)w)->boxLayout()->setSpacing( 0 );
		((QToolBar*)w)->setMargin( 4 );
                w->setBackgroundMode(PaletteBackground);
                w->setBackgroundOrigin(QWidget::WindowOrigin);
		goto kstpolish ;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

 	if (tmpBool = ::qt_cast<QToolButton*>(w) ||  w->inherits( "QToolBarSeparator" ) ||  w->inherits( "KToolBarSeparator" ) ){
		if (tmpBool && w->parentWidget() && ::qt_cast<QToolBar*>(w->parentWidget()) ){
			w->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
		}
 		w->setBackgroundMode( QWidget::PaletteBackground );
 		w->setBackgroundOrigin(QWidget::WindowOrigin);
 		w->installEventFilter( this );
 		goto kstpolish;
 	}
        
        
        //if (testWidget) qWarning("testwidget stage %d",testInt++);


        //if (testWidget) qWarning("testwidget stage %d",testInt++);
        
		

	if ( w->inherits( "QDockWindow" ) ) {
		w->setBackgroundMode( QWidget::PaletteBackground );
		w->setBackgroundOrigin(QWidget::WindowOrigin);
		w->installEventFilter( this );
		goto kstpolish ;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	if (w->inherits( "QRadioButton" ) || w->inherits( "QCheckBox" )){
		w->setBackgroundOrigin(QWidget::WindowOrigin);
		w->installEventFilter( this );
		goto kstpolish;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);


	if ( ::qt_cast<QScrollBar*>(w)) {
		QCursor tmpCursor(Qt::PointingHandCursor);
                w->setCursor(tmpCursor);
		w->installEventFilter( this );
		w->setBackgroundMode( QWidget::NoBackground );
		goto kstpolish ;
	}
        if ( w->inherits( "KdetvView")) {
            w->setBackgroundMode( QWidget::NoBackground );
        }
        //if (testWidget) qWarning("testwidget stage %d",testInt++);

	if ( w->isTopLevel() && isKicker ) {
	// more kicker stuff
		// force extensions and child panels to use proper palette.
		if ( !w->inherits( "Panel" ) && !w->inherits( "KPanelApplet" ) ) {
			if (!origPanelPalette.active().brush( QColorGroup::Background ).pixmap() ) {
				if (optionHandler->BrushMe()) {
					QBrush brush( origPanelPalette.active().brush( QColorGroup::Background ) );
//					QPixmap brushed = optionHandler->TintBrush() ? *tintBrush(fetchImage( "brush-me" ), optionHandler->BrushTint()) : fetchImage("brush-me" );
					brush.setPixmap( gradBrush );
					origPanelPalette.setBrush( QColorGroup::Background, brush );
				} else if ( !isPlain()) {
				QBrush brush( origPanelPalette.active().brush( QColorGroup::Background ) );
				QColor c( brush.color() );
				QPixmap stipple( 64, 64 );
				stipple.fill( c.rgb() );
				QPainter p;
				p.begin( &stipple );
				p.setPen( c.dark( 100 + (int)(optionHandler->stippleContrast()/2) ) );
				for ( int i = 1; i < 64; i += 4 ) {
					p.drawLine( 0, i, 63, i );
					p.drawLine( 0, i+2, 63, i+2 );
				}
                                p.setPen( c.dark( 100 + optionHandler->stippleContrast()) );
                                for ( int i = 2; i < 63; i += 4 ) {
                                        p.drawLine( 0, i, 63, i );
                                        }
				p.end();
				brush.setPixmap( stipple );
				origPanelPalette.setBrush( QColorGroup::Background, brush );
			}
                        }
			w->setPalette( origPanelPalette );
		}
		goto kstpolish ;
	}
        //if (testWidget) qWarning("testwidget stage %d",testInt++);
kstpolish:	KStyle::polish( w ); // nothing of all above? do default kde stuff
	}



void LiquidStyle::unPolish( QWidget *w ) {

	bool isViewport;
	bool isViewportChild;
        
        // general - better than querying for each and ever widget if it got one...
        w->removeEventFilter( this );
        

	if (w->inherits("KColorGrid")){
            w->setBackgroundMode(QWidget::PaletteBackground);
            goto kstunpolish;
        }
        
        if ( w->inherits("QToolBar") || qstrcmp( w->name(), "kde toolbar widget" ) == 0 ) {
		w->setBackgroundOrigin( QWidget::WidgetOrigin );
		w->unsetPalette();
		goto kstunpolish;
		}
	if ( w->inherits( "QPopupMenu" ) ) {
		w->unsetPalette();
		w->setBackgroundMode( QWidget::PaletteButton );
		w->removeEventFilter( optionHandler );
		goto kstunpolish;
		}
	if ( !isPlain () && w->inherits( "KonqIconViewWidget" ) ||
	        w->inherits( "KHTMLView" ) ) {
		w->unsetPalette();
		goto kstunpolish;
		}
	if (w->inherits("KateView") || w->inherits("TEWidget") || w->inherits("CHexViewWidget")){
//		w->setMouseTracking( false );
		goto kstunpolish;
	}

	if (w->isA( "QViewportWidget" ) || w->inherits( "QClipperWidget" ) )
		goto kstunpolish;

	if ( !isPlain() ) {
		if ( w->inherits( "KActiveLabel" ) || w->inherits( "QTipLabel" ) ) {
			w->unsetPalette();
			goto kstunpolish;
			}
		/*
		else if(w->inherits("KdmClock")){
		    ; // Check this!
		    return;
			}*/
		}
	else if ( w->inherits( "QMenuBar" ) ) {
		w->setBackgroundMode( QWidget::PaletteButton );
		if ( !isPlain() )
			w->setBackgroundOrigin( QWidget::WidgetOrigin );
		goto kstunpolish;
		}else if ( w->inherits( "QDockWindow" ) ) {
		w->setBackgroundMode( QWidget::PaletteButton );
		if ( !isPlain() )
			w->setBackgroundOrigin( QWidget::WidgetOrigin );
		goto kstunpolish;
		} else if ( w->inherits( "QComboBox" ) || w->inherits( "QPushButton" ) ) {
		w->setBackgroundMode( QWidget::PaletteButton );
		} else if ( w->inherits( "QScrollBar" ) ) {
//		if (!w->isEnabled()) w->setEnabled(true);
		w->setBackgroundMode( QWidget::PaletteBackground );
		goto kstunpolish;
		} else if ( w->inherits( "QHeader" ) ) {
		w->setMouseTracking( false );
		}

	if ( w->inherits( "QToolButton" ) ) {
		w->unsetPalette();
		w->setBackgroundMode( QWidget::PaletteButton );
		if ( !isPlain() )
			w->setBackgroundOrigin( QWidget::WidgetOrigin );
		goto kstunpolish;
		}

	if ( w->isTopLevel() && isKicker && !w->inherits( "Panel" ) &&
	        !w->inherits( "KPanelApplet" ) ) {
		w->unsetPalette();
		goto kstunpolish;
		}

	isViewport = qstrcmp( w->name(), "qt_viewport" ) == 0 ||
	                  qstrcmp( w->name(), "qt_clipped_viewport" ) == 0;
	isViewportChild = w->parent() &&
	                       ( ( qstrcmp( w->parent() ->name(), "qt_viewport" ) == 0 ) ||
	                         ( qstrcmp( w->parent() ->name(), "qt_clipped_viewport" ) == 0 ) );

	if ( isViewportChild ) {
		if ( w->inherits( "QRadioButton" ) || w->inherits( "QComboBox" ) || w->inherits( "QPushButton" ) ) {
			if ( isHTMLWidget( w ) ) {
				w->setAutoMask( false );
				w->setBackgroundMode( QWidget::PaletteBackground );
				goto kstunpolish;
				}
			}
		}

	if ( !isPlain() ) {
		if ( !isViewport && w->parent() && qstrcmp( w->parent() ->name(), "proxyview" ) == 0 ) {
			w->setBackgroundOrigin( QWidget::WidgetOrigin );
			goto kstunpolish;
			}
		if ( w->ownPalette() && !w->inherits( "QButton" ) && !w->inherits( "QComboBox" ) )
			goto kstunpolish;
		if ( w->inherits( "PanelButtonBase" ) )
			goto kstunpolish;

		if ( !isViewport && !isViewportChild && !w->testWFlags( WType_Popup ) &&
		        !w->inherits( "KDesktop" ) && !w->inherits( "PasswordDlg" ) ) {

			if ( w->backgroundOrigin() == QWidget::WindowOrigin )
				w->setBackgroundOrigin( QWidget::WidgetOrigin );
			goto kstunpolish;
			}
		}
kstunpolish:	KStyle::unPolish( w );
	}
