/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** editor.h
**
** Author<s>:   Marc Bevand (aka "After") <bevand_m@epita.fr>
**              Michael Terry <mterry@fastmail.fm>
** Last update: Mon Jul  8 08:22:44 CEST 2002
** Description: Beaver editing functions
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __EDITOR_H__
#define __EDITOR_H__

/*
** NOTE_REMARK : syhi stands for SYntax HIghlighting, the main work to
**  be accomplished by the source
*/

/*
** TODO: handle the case where the compiler does not provide __func__
** (used in editor.c)
*/

/*
** Macro equivalent to the delta time "Tv2 - Tv1" in millisec
** NOTE_WARNING : needs sys/time.h because Tvx are struct timeval
*/
#define DELTA_TIME(Tv1, Tv2)						\
  ((double)((Tv2).tv_sec) * 1000.0 + (double)((Tv2).tv_usec) / 1000.0 - \
  (double)((Tv1).tv_sec) * 1000.0 - (double)((Tv1).tv_usec) / 1000.0)

/*
** Macro for recording time in the struct timeval Tv
** NOTE_WARNING : needs sys/time.h, unistd.h & stdio.h
*/
#define REC_TIME(Tv)							\
{									\
  if (gettimeofday(&(Tv), NULL))					\
    perror(__FILE__": REC_TIME() macro: gettimeofday() error");		\
}

/*
** Macro for filtering printable chars
*/
#define PRINTC(c)							\
  ((((c) >= ' ') && ((c) <= '~')) ? (c) : 0x7f)

/*
** Macro that return 1 if 2 letters are equivalent (ignoring the case), 0 else
*/
#define CHAR_CASE_CMP(C1, C2)					\
  ((C1 == C2) ||						\
   (g_ascii_isalpha((gchar)C1) && g_ascii_isalpha((gchar)C2) &&	\
    ((C1 | 0x20)  == (C2 | 0x20))))

#include "struct.h"

/*
** Macros for use with refresh_editor()
*/
#define SYHI_AUTODETECT	(-1)
#define SYHI_DISABLE	(-2)

/*
** Prototypes of fcns
*/
extern void		editor_init(void);
extern void		open_file_in_editor(GtkWidget *Editor,
					    const gchar *Filename, gint CurrentPage);

gboolean catch_mult_line_indents (GtkWidget *widget, GdkEventKey *event, gpointer data);

void set_mime_type (gint page, const gchar *mime_type);
void load_file_contents_into_buffer (gint page, const gchar *filename);

#endif /* !__EDITOR_H__ */
