/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** languages.c
**
** Author<s>:   Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
**              Michael Terry <mterry@fastmail.fm>
** Latest update: Wed May  3 04:27:13 2000
** Description:   Beaver languages menus generator source
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include "filesops.h"
#include "editor.h"
#include "tools.h"
#include "struct.h"
#include "conf.h"
#include "search.h"
#include "main.h"
#include "msgbar.h"
#include "languages.h"
#include "gtksourceview/gtksourcelanguagesmanager.h"
#include "gtksourceview/gtksourcebuffer.h"

/* Max number of entries per language */

#define ENTRIES_MAX_NB 1000

extern GtkItemFactory *MainFactory;
extern GtkWidget *MainNotebook;
extern GArray *FileProperties;
extern gint OpenedFilesCnt;
GtkSourceLanguagesManager *LanguagesManager = NULL;

void languages_treatment (GtkWidget *Widget, guint Op);

/* Load the Beaver Language files that are declared in the 'General' config
   file */

void init_languages_menu (void)
{
	GtkItemFactoryEntry entry = 
		{_("/Language/None"), NULL, languages_treatment, 
		GPOINTER_TO_INT (NULL), "<RadioItem>"};
	const GSList *languages, *tmp;
	
	gtk_item_factory_create_items (MainFactory, 1, &entry, NULL);
	
	LanguagesManager = gtk_source_languages_manager_new ();
	
	languages = gtk_source_languages_manager_get_available_languages (LanguagesManager);
	
	entry.item_type = _("/Language/None");
	for (tmp = languages; tmp; tmp = tmp->next)
	{
		GtkSourceLanguage *l = (GtkSourceLanguage *) tmp->data;
		gchar *name;
		
		name = gtk_source_language_get_name (l);
		entry.path = g_strconcat (_("/Language/"), name, NULL);
		entry.callback_action = GPOINTER_TO_INT (l);
		
		gtk_item_factory_create_items (MainFactory, 1, &entry, NULL);
		
		g_free (name);
		g_free (entry.path);
	}
}


/* This is the function called by the items of the Languages menu generated
   above */

void languages_treatment (GtkWidget *Widget, guint Op)
{
	gint CurrentPage;
	gchar *msg;
	GtkSourceLanguage *l = GINT_TO_POINTER (Op);
	GtkSourceBuffer *buffer;
	
	if (!OpenedFilesCnt)
		return;

	CurrentPage = gtk_notebook_get_current_page (GTK_NOTEBOOK (MainNotebook));
	buffer = GTK_SOURCE_BUFFER (FPROPS (CurrentPage, Buffer));
	
	if (!l)
	{
  		gtk_source_buffer_set_highlight (buffer, FALSE);
		
		msg = g_strdup(_("Language support disabled..."));
	}
	else
	{
		gtk_source_buffer_set_language (buffer, l);
  		gtk_source_buffer_set_highlight (buffer, TRUE);
  		
		msg = g_strdup_printf(_("Language mode \"%s\" activated."), gtk_source_language_get_name (l));
	}
	
	print_msg(msg);
	g_free(msg);
}

void languages_activate_menu_item_for_language (GtkSourceLanguage *lang)
{
	gchar *path;
	GtkWidget *item;
	
	if (lang)
	{
		gchar *name = gtk_source_language_get_name (lang);
		path = g_strconcat (_("/Language/"), name, NULL);
		g_free (name);
	}
	else
	{
		path = g_strdup (_("/Language/None"));
	}
	
	item = gtk_item_factory_get_item (MainFactory, path);
	
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
	
	g_free (path);
}
