/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** main.c
**
** Author<s>:     Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
** Latest update: Wed Jan 10 20:32:23 2001
** Description:   Beaver main source file
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include "interface.h"
#include "main.h"


/* The incredibly complex 'main' function :) */

int main (int argc, char *argv[])
{
  gchar *ConfDir;	   

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  g_set_prgname (PACKAGE_NAME);

  if (argc >= 2)
    {
      gint i;
      
      for (i = 1; i < argc; i++)
	{
	  if (!strcmp (argv[i], "--help") || !strcmp (argv[i], "-?"))
	    {
	      g_print
		(g_strconcat
		 (_("Usage: "), PACKAGE, " [", _("OPTION"), "...] [", _("FILE"), "...]",
		  "\n\n",
		  _("Help options"), "\n",
		  "  -?, --help\t\t\t", _("Show this help message"), "\n",
		  "  --usage\t\t\t", _("Display brief usage message"),
		  "\n\n",
		  _("GTK/X options"), "\n",
		  "  --gdk-debug=FLAGS\t\t", _("Gdk debugging flags to set"), "\n",
		  "  --gdk-no-debug=FLAGS\t\t", _("Gdk debugging flags to unset"), "\n",
		  "  --display=DISPLAY\t\t", _("X display to use"), "\n",
		  "  --sync\t\t\t", _("Make X calls synchronous"), "\n",
		  "  --no-xshm\t\t\t", _("Don't use X shared memory extension"), "\n",
		  "  --name=NAME\t\t\t", _("Program name as used by the window manager"), "\n",
		  "  --class=CLASS\t\t\t", _("Program class as used by the window manager"), "\n",
		  "  --gtk-debug=FLAGS\t\t", _("Gtk+ debugging flags to set"), "\n",
		  "  --gtk-no-debug=FLAGS\t\t", _("Gtk+ debugging flags to unset"), "\n",
		  "  --g-fatal-warnings\t\t", _("Make all warnings fatal"), "\n",
		  "  --gtk-module=MODULE\t\t", _("Load an additional Gtk module"),
		  "\n\n",
		  _("Misc. options"), "\n",
		  "  --version\t\t\t", _("Display version number"), "\n", NULL));
	      return(1);
	    }
	  else if (!strcmp (argv[i], "--usage"))
	    {
	      g_print
		(g_strconcat
		 (_("Usage: "), PACKAGE, " [-?] [--version] [--usage] "
		  "[--gdk-debug=FLAGS]\n\t[--gdk-no-debug=FLAGS] "
		  "[--display=DISPLAY] [--sync] [--no-xshm]\n\t"
		  "[--name=NAME] [--class=CLASS] [--gtk-debug=FLAGS] "
		  "[--gtk-no-debug=FLAGS]\n\t[--g-fatal-warnings] "
		  "[--gtk-module=MODULE]\n", NULL));
	      return (1);
	    }
	  else if (!strcmp (argv[i], "--version"))
	    {
	      g_print ("%s\n", PACKAGE_STRING);
	      return (1);
	    }
	  else if (!strcmp (argv[i], "--"))
	    {
	      break;
	    }
	}
    }
  ConfDir = g_build_filename (g_get_home_dir (), CONF_DIR, NULL);
  mkdir (ConfDir, 0755);
  g_free (ConfDir);
  interface (argc, argv);
  return (0);
}
