/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** main.h
**
** Author<s>:   Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
** Description:   Beaver main source file header
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#else
#  error No config.h found, run configure first.
#endif

#ifdef ENABLE_NLS
#  include <locale.h>
#  include "gettext.h"
#  define _(String) gettext(String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop(String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(Domain)
#  define bindtextdomain(Package, Directory)
#  define gettext(String) (String)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#define TEMP_PREFIX "buffer_"

#ifdef WIN32
	#define CONF_DIR "config"
#else
	#define CONF_DIR ".beaver"
#endif

#define APP_MOTTO       "Beaver's an Early\nAdVanced EditoR"
#define APP_URL	        "http://www.nongnu.org/beaver"
#define UNTITLED        "Untitled"
#define WELCOME_MSG     "Welcome to"
#define UNKNOWN         "???"


int main (int argc, char *argv[]);

#endif
