/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** toolbar.c
**
** Author<s>:   Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
**              Michael Terry <mterry@fastmail.fm>
** Latest update: Wed May  3 04:28:06 2000
** Description:   Beaver toolbar source
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>
#include <sys/stat.h>
#include "filesops.h"
#include "interface.h"
#include "struct.h"


static GtkWidget *Toolbar;


/* This toolbar is one of the things that should evolve in a near future */

void init_toolbar (GtkBox *ParentBox)
{
  GtkWidget *ParentWindow;
  GtkWidget *image;
  GtkWidget *w;

  ParentWindow = gtk_widget_get_toplevel (GTK_WIDGET(ParentBox));
  gtk_widget_realize (ParentWindow);
  Toolbar = gtk_toolbar_new ();
  gtk_box_pack_start (GTK_BOX(ParentBox), Toolbar, FALSE, FALSE, 0);
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_NEW,
			   "Create a new document", NULL, 
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (NEW), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(NEW));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_OPEN,
			   "Open a file", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (OPEN), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(OPEN));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_SAVE,
			   "Save the current file", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (SAVE), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(SAVE));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_CLOSE,
			   "Close the current file", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (CLOSE), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(CLOSE));
  
  gtk_toolbar_append_space (GTK_TOOLBAR(Toolbar));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_UNDO,
			   "Undo last operation", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (UNDO), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(UNDO));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_REDO,
			   "Redo last operation", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (REDO), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(REDO));

  gtk_toolbar_append_space (GTK_TOOLBAR(Toolbar));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_CUT,
			   "Cut the selection", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (CUT), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(CUT));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_COPY,
			   "Copy the selection", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (COPY), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(COPY));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_PASTE,
			   "Paste from the clipboard", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (PASTE), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(PASTE));

  gtk_toolbar_append_space (GTK_TOOLBAR(Toolbar));
  w = gtk_toolbar_insert_stock (GTK_TOOLBAR(Toolbar), GTK_STOCK_FIND,
			   "Search for a string", NULL,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (FIND), -1);
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(FIND));


  image = gtk_image_new_from_stock (GTK_STOCK_FIND_AND_REPLACE, 
		gtk_toolbar_get_icon_size (GTK_TOOLBAR (Toolbar)));
  w = gtk_toolbar_append_item (GTK_TOOLBAR(Toolbar), "Replace",
			   "Search and replace", NULL, image,
			   GTK_SIGNAL_FUNC (menu_items_treatment),
			   GINT_TO_POINTER (REPLACE));
  g_object_set_data (G_OBJECT (w), "toolbar_id", GINT_TO_POINTER(REPLACE));
}


void hide_toolbar (void)
{
  gtk_widget_hide (Toolbar);
}


void show_toolbar (void)
{
  gtk_widget_show (Toolbar);
}


void toolbar_set_sensitive (gint id, gboolean setting)
{
	GList *children, *tmp;
	gpointer obj_data;
	
	START_FCN
	
	tmp = children = gtk_container_get_children (GTK_CONTAINER (Toolbar));
	
	while (tmp)
	{
		obj_data = g_object_get_data (G_OBJECT (tmp->data),
			"toolbar_id");
		
		if (obj_data && GPOINTER_TO_INT (obj_data) == id)
		{
			gtk_widget_set_sensitive (GTK_WIDGET (tmp->data),
				setting);
			break;
		}
		
		tmp = tmp->next;
	}
	
	g_list_free (children);
	
	END_FCN
}

