#ifndef lint
static char *RCSid = "$Header: /home/jsellens/src/users/biffer/RCS/misc.c,v 1.8 1996/02/14 17:40:43 rbutterworth Exp $";
#endif

#include "biffer.h"
#include <ctype.h>
#include <syslog.h>
#include <errno.h>
/* #include <mfcf/libc/stdarg.h> */
#include <stdarg.h>

extern char *progname;

    static char *
dosyslog(priority, fmt, args)
    int priority;
    char *fmt;
    va_list args;
{
    static char buffer[4096];
    
    vsprintf(buffer, fmt, args);
    syslog(priority, "%s", buffer);
    return &buffer[0];
}

    void
#if !defined(C_PROTOTYPES)
debug(fmt, va_alist)
    char *fmt;
    va_dcl
#else
debug(char *fmt, ...)
#endif
{
    auto va_list args;
    auto char *msg;

    va_start(args, fmt);
    msg = dosyslog(LOG_DEBUG, fmt, args);
    va_end(args);

    if (0) {
	static FILE *testing = 0;
	if (!testing) {
	    testing = fopen("/u/rbutterworth/testing", "a");
	    setvbuf(testing, (char*)0, _IOLBF, (size_t)0);
	}
	if (testing)
	    fprintf(testing, "debug: %s\n", msg);
    }
}

    void
#if !defined(C_PROTOTYPES)
eprintf(fmt, va_alist)
    char *fmt;
    va_dcl
#else
eprintf(char *fmt, ...)
#endif
{
    auto va_list args;

    va_start(args, fmt);
    (void)dosyslog(LOG_ERR, fmt, args);
    va_end(args);
}


    void
#if !defined(C_PROTOTYPES)
fatal(fmt, va_alist)
    char *fmt;
    va_dcl
#else
fatal(char *fmt, ...)
#endif
{
    auto va_list args;

    va_start(args, fmt);
    (void)dosyslog(LOG_ERR, fmt, args);
    va_end(args);

    die();
}


die()
{
    exit( 0 );	/* exit nicely so inetd doesn't get worried */
}


/* lowercase the string in place */
void
lowercase( s )
char *s;
{
    for ( ; *s; s++ )
	if ( isascii( *s ) && isupper( *s ) )
	    *s = tolower( *s );
}


/* keep first word, and throw out the rest */
void
trimword( s )
char *s;
{
    while ( *s!='\0' && isascii(*s) && !isspace(*s) )
	s++;
    *s = '\0';
}
