/*
 * Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
 * modified for Big5Con by Hung-Chi Chu <hcchu@r350.ee.ntu.edu.tw>
 * Read: sample.phs
 * Write: sample.phs.b5c
 */

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <stdlib.h>

#include "ksymdef.h"

static void 
p_err(char *fmt,...)
{
    va_list         args;

    va_start(args, fmt);
    fprintf(stderr, "%s:", "clisock.c");
    vfprintf(stderr, fmt, args);
    va_end(args);
    fprintf(stderr, "\n");
    exit(-1);
}


#define BSIZE (64*1024)
static u_char  *bf;
int             ofs;
static FILE    *fw;

void 
init_f(char *file)
{
    char            fname[100];
    if (!(bf = malloc(BSIZE))) {
	puts("malloc err");
    }
    strcpy(fname, file);
    strcat(fname, ".b5c");
    if ((fw = fopen(fname, "w")) == NULL) {
	p_err("Cannot create %s", fname);
    }
    ofs = 4;			/* reserved for header */
}

void 
upload_keyword(int kk, char *str)
{
    memcpy(bf + ofs, &kk, 4);
    ofs += 4;
    if (kk) {
	int             len = strlen(str);
	strcpy(bf + ofs, str);
	ofs += len + 1;
    }
    if (ofs > BSIZE)
	puts("ph file size too large > 64K");
}

void 
write_phr()
{
    *(int *)bf = ofs;
    fwrite(bf, 1, ofs, fw);
    fclose(fw);
}


struct keystruc {
    char           *kname;
    int             ksym;
}               tran[] = {
    {
	"0", '0'
    }, {
	"1", '1'
    }, {
	"2", '2'
    }, {
	"3", '3'
    }, {
	"4", '4'
    }, {
	"5", '5'
    },
    {
	"6", '6'
    }, {
	"7", '7'
    }, {
	"8", '8'
    }, {
	"9", '9'
    },
    {
	"a", 'a'
    }, {
	"b", 'b'
    }, {
	"c", 'c'
    }, {
	"d", 'd'
    }, {
	"e", 'e'
    }, {
	"f", 'f'
    },
    {
	"g", 'g'
    }, {
	"h", 'h'
    }, {
	"i", 'i'
    }, {
	"j", 'j'
    }, {
	"k", 'k'
    }, {
	"l", 'l'
    },
    {
	"m", 'm'
    }, {
	"n", 'n'
    }, {
	"o", 'o'
    }, {
	"p", 'p'
    }, {
	"q", 'q'
    }, {
	"r", 'r'
    },
    {
	"s", 's'
    }, {
	"t", 't'
    }, {
	"u", 'u'
    }, {
	"v", 'v'
    }, {
	"w", 'w'
    }, {
	"x", 'x'
    },
    {
	"y", 'y'
    }, {
	"z", 'z'
    },
    {
	",", '<'
    }, {
	".", '>'
    }, {
	";", ':'
    }, {
	"/", '?'
    }, {
	"[", '{'
    }, {
	"]", '}'
    },
    {
	"f1", VK_F1
    }, {
	"f2", VK_F2
    }, {
	"f3", VK_F3
    }, {
	"f4", VK_F4
    }, {
	"f5", VK_F5
    }, {
	"f6", VK_F6
    },
    {
	"f7", VK_F7
    }, {
	"f8", VK_F8
    }, {
	"f9", VK_F9
    }, {
	"f10", VK_F10
    }, {
	"f11", VK_F11
    },
    {
	"f12", VK_F12
    },
    {
	"k_ins", VK_Insert
    }, {
	"k_del", VK_Delete
    },
    {
	"k_end", VK_End
    }, {
	"k_down", VK_Down
    }, {
	"k_pgdn", VK_Next
    }, {
	"k_left", VK_Left
    },
    {
	"k_5", VK_Begin
    }, {
	"k_right", VK_Right
    }, {
	"k_home", VK_Home
    },
    {
	"k_up", VK_Up
    }, {
	"k_pgup", VK_Prior
    },
    {
	"kp0", VK_KP_0
    }, {
	"kp.", VK_KP_Decimal
    },
    {
	"kp1", VK_KP_1
    }, {
	"kp2", VK_KP_2
    }, {
	"kp3", VK_KP_3
    }, {
	"kp4", VK_KP_4
    },
    {
	"kp5", VK_KP_5
    }, {
	"kp6", VK_KP_6
    }, {
	"kp7", VK_KP_7
    },
    {
	"kp8", VK_KP_8
    }, {
	"kp9", VK_KP_9
    },
    {
	"kp/", VK_KP_Divide
    }, {
	"kp*", VK_KP_Multiply
    }, {
	"kp-", VK_KP_Subtract
    },
    {
	"kp+", VK_KP_Add
    }, {
	"kpenter", VK_KP_Enter
    }
};

int             keynum = sizeof(tran) / sizeof(struct keystruc);

int main(int argc, char **argv)
{
    FILE           *fp;
    char            kname[32];
    char            str[256];
    char            ttt[512];
    int             i, j;

    if (argc <= 1) {
	printf("Usage:  %s phrase_file\n", argv[0]);
	exit(1);
    }
    if ((fp = fopen(argv[1], "r")) == NULL) {
	printf("cannot open %s\n", argv[1]);
	exit(-1);
    }
    init_f(argv[1]);

    while (!feof(fp)) {
	kname[0] = str[0] = 0;
	fgets(ttt, sizeof(ttt), fp);
	if (ttt[0] == '#')
	    continue;
	for (i = 0; ttt[i] != ' ' && ttt[i] != 9 && ttt[i]; i++)
	    kname[i] = ttt[i];
	kname[i] = 0;
	while ((ttt[i] == ' ' || ttt[i] == 9) && ttt[i])
	    i++;
	for (j = 0; ttt[i] != '\n' && ttt[i]; i++, j++)
	    str[j] = ttt[i];
	if (!str[0] || !kname[0])
	    continue;
	str[j] = 0;
	for (i = 0; i < keynum; i++)
	    if (!strcmp(kname, tran[i].kname)) {
		/*
		 * printf("%X %s:%d  %s\n",tran[i].ksym,
		 * tran[i].kname,strlen(str), str);
		 */
		upload_keyword(tran[i].ksym, str);
		break;
	    }
	if (i == keynum)
	    printf("unknown key: %s\n", kname);
    }
    write_phr();
    return 0;
}
