/*
 * Copyright (C) 1995	Edward Der-Hua Liu, Hsin-Chu, Taiwan
 *  binary table -> text table
 * example:# mv tsin.src tsin.src_\n
 *         ./tsd2a tsin > tsin.src
 */

#include <stdio.h>
#include <sys/types.h>

int             phcount;

static char    *pk[] = {
    "  tuvwxyz{|}~",
    "  ",
    "  ",
    "  "
};

void 
prph(u_short kk)
{
    u_int           k1, k2, k3, k4;
    k4 = (kk & 7) << 1;
    kk >>= 3;
    k3 = (kk & 15) << 1;
    kk >>= 4;
    k2 = (kk & 3) << 1;
    kk >>= 2;
    k1 = (kk & 31) << 1;
    if (k1)
	printf("%c%c", pk[0][k1], pk[0][k1 + 1]);
    if (k2)
	printf("%c%c", pk[1][k2], pk[1][k2 + 1]);
    if (k3)
	printf("%c%c", pk[2][k3], pk[2][k3 + 1]);
    if (k4)
	printf("%d", k4 >> 1);
}

int main(int argc, char **argv)
{
    FILE           *fp;
    u_short         phbuf[128];
    u_char          chbuf[128][2];
    int             i;
    u_char          clen;

    if (argc <= 1) {
	printf("%s: file name expected\n", argv[0]);
	exit(1);
    }
    if ((fp = fopen(argv[1], "r")) == NULL) {
	printf("Cannot open %s", argv[1]);
	exit(-1);
    }
    while (!feof(fp)) {
	fread(&clen, 1, 1, fp);
	fread(phbuf, 2, clen, fp);
	fread(chbuf, 2, clen, fp);
	for (i = 0; i < clen; i++) {
	    printf("%c%c", chbuf[i][0], chbuf[i][1]);
	}
	printf(" ");
	for (i = 0; i < clen; i++) {
	    prph(phbuf[i]);
	    if (i != clen - 1)
		printf(" ");
	}
	puts("");
    }
    fclose(fp);
    return 0;
}
