/*
	KON - Kanji ON Linux Console -
	Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)

	KON is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	KON is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* fnld.h -- font information */

#ifndef	FNLD_H
#define	FNLD_H

#include <interface.h>

struct fontRegs {
    u_int (*addr)(u_char ch1, u_char ch2);
    u_int size;
    char *registry, *bitmap;
    u_char high, width, sign0, sign1, stat;
};

struct langInfo {
    u_char
	sb,
	db,
	sc;
};

extern struct langInfo lInfo;

#define	FR_ATTACH	1
#define	FR_PROXY	2

extern struct fontRegs fSRegs[], fDRegs[];
extern struct fontRegs *sbFReg, *dbFReg;

extern u_char	*FontLoad(u_char *fbuff, int fd, struct fontInfo *fi);
extern u_char	*GetShmem(char type);
extern void	DownShmem(char type);

#endif
