/*
	KON - Kanji ON Linux Console -
	Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)

	KON is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	KON is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* interface.h -- communication protocol definition */

#ifndef	INTERFACE_H
#define	INTERFACE_H

#include	<sys/types.h>

#define	STR_NAK		"\x15"
#define	CHR_NAK		0x15
#define	STR_ACK		"\x06"
#define	CHR_ACK		0x06

#define	CHR_SFONT	0x81
#define	CHR_WFONT	0x89

#define	CHR_SFLD	0x80
#define	CHR_DBC		0x20
#define	CHR_DFLD	(CHR_SFLD|CHR_DBC)

#define	CHR_LOAD	'L'
#define	CHR_UNLOAD	'U'
#define	CHR_STAT	'S'
#define	CHR_DISCONNECT	'D'
#define	CHR_TEXTMODE	'T'
#define	CHR_GRAPHMODE	'G'
#define	CHR_RESTART	'R'

#define	MAX_SOCKET_NAME	14
#define	SOCKET_BASENAME	"/tmp/.big5con"

#define	SHMEM_NAME	CONFIG_NAME

#define	MAX_CTRLCHAR	80

/*
extern char	socketName[MAX_SOCKET_NAME+1];
*/

struct	messageHeader	{
	u_char	cno,	/* client number */
		cmd;	/* command */
};

struct	fontInfo {
    u_int size;
    u_char high, width, type;
};

struct fontLoaderRegs {
    u_int (*addr)(u_char ch1, u_char ch2);
    u_int max;
};

extern struct fontLoaderRegs fldSRegs[], fldDRegs[];

extern void	SocketKill(int);
extern int	SocketRecCommand(int, struct messageHeader *);
extern int	SocketSendCommand(int, char);
extern int	SocketClientOpen(void);
extern int	SocketSendData(u_char *buff, int size, int fd);
extern int	CheckLoadedFont(char type);
extern int	SetFont(char *prog, u_char *font, struct fontInfo *fi);

#endif
