/*	Definition of some key symbols

	Copyright (C) 1997 Hung-Chi Chu <hcchu@r350.ee.ntu.edu.tw>

	This file is part of the Big5Con(Big5 Chinese Console) package.

	Big5Con is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Big5Con is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KSYMDEF_H
#define KSYMDEF_H

#if defined(__FreeBSD__)
#include        <osreldate.h>
#if __FreeBSD_version >= 410000
#include        <sys/consio.h> 
#include        <sys/kbio.h>  
#else                       
#include        <machine/console.h>
#endif /* endif __FreeBSD_version >= 410000 */
#endif /* endif defined(__FreeBSD__) */

#define KEY_SHIFT_MASK	0x01
#define KEY_CTRL_MASK	0x02
#define KEY_ALT_MASK	0x04
#define KEY_CAPS_MASK	(LED_CAP<<4)

#define KEY_F1		59
#define KEY_F2		60
#define KEY_F3		61
#define KEY_F4		62
#define KEY_F5		63
#define KEY_F6		64
#define KEY_F7		65
#define KEY_F8		66
#define KEY_F9		67
#define KEY_F10		68
#define KEY_F11		87
#define KEY_F12		88
#define KEY_CTRL_L	29
#define KEY_CTRL_R	90
#define KEY_ALT_L	56
#define KEY_ALT_R	93
#define KEY_ENTER	28
#define KEY_KP_ENTER	89
#define KEY_PLUS	13
#define KEY_KP_PLUS	78
#define KEY_MINUS	12
#define KEY_KP_MINUS	74
#define KEY_MULT	9
#define KEY_KP_MULT	55
#define KEY_DIV		53
#define KEY_KP_DIV	91
#define KEY_KP_DOT	83
#define KEY_DEL		103
#define KEY_KP_0	82
#define KEY_INS		102
#define KEY_KP_1	79
#define KEY_END		99
#define KEY_KP_2	80
#define KEY_DOWN	100
#define KEY_KP_3	81
#define KEY_PGDN	101
#define KEY_KP_4	75
#define KEY_LEFT	97
#define KEY_KP_5	76
#define KEY_KP_6	77
#define KEY_RIGHT	98
#define KEY_KP_7	71
#define KEY_HOME	94
#define KEY_KP_8	72
#define KEY_UP		95
#define KEY_KP_9	73
#define KEY_PGUP	96
#define KEY_SHIFT_L	42

#define VK_F1		(KEY_F1<<8)
#define VK_F2		(KEY_F2<<8)
#define VK_F3		(KEY_F3<<8)
#define VK_F4		(KEY_F4<<8)
#define VK_F5		(KEY_F5<<8)
#define VK_F6		(KEY_F6<<8)
#define VK_F7		(KEY_F7<<8)
#define VK_F8		(KEY_F8<<8)
#define VK_F9		(KEY_F9<<8)
#define VK_F10		(KEY_F10<<8)
#define VK_F11		(KEY_F11<<8)
#define VK_F12		(KEY_F12<<8)
#define VK_Control_L	(KEY_CTRL_L<<8)
#define VK_Shift_L	(KEY_SHIFT_L<<8)
#define VK_BackSpace	(8)
#define VK_Escape	(27)
#define VK_Enter	(13)
#define VK_Tab		(9)
#define VK_Insert	(KEY_INS<<8)
#define VK_Delete	(KEY_DEL<<8)
#define VK_Home		(KEY_HOME<<8)
#define VK_End		(KEY_END<<8)
#define VK_Prior	(KEY_PGUP<<8)
#define VK_Next		(KEY_PGDN<<8)
#define VK_Left		(KEY_LEFT<<8)
#define VK_Right	(KEY_RIGHT<<8)
#define VK_Up		(KEY_UP<<8)
#define VK_Down		(KEY_DOWN<<8)
#define VK_Begin	(KEY_KP_5<<8)
#define VK_KP_0		('0'|(KEY_KP_0<<8))
#define VK_KP_1		('1'|(KEY_KP_1<<8))
#define VK_KP_2		('2'|(KEY_KP_2<<8))
#define VK_KP_3		('3'|(KEY_KP_3<<8))
#define VK_KP_4		('4'|(KEY_KP_4<<8))
#define VK_KP_5		('5'|(KEY_KP_5<<8))
#define VK_KP_6		('6'|(KEY_KP_6<<8))
#define VK_KP_7		('7'|(KEY_KP_7<<8))
#define VK_KP_8		('8'|(KEY_KP_8<<8))
#define VK_KP_9		('9'|(KEY_KP_9<<8))
#define VK_KP_Decimal	('.'|(KEY_KP_DOT<<8))
#define VK_KP_Enter	(VK_Enter|(KEY_KP_ENTER<<8))
#define VK_KP_Add	('+'|(KEY_KP_PLUS<<8))
#define VK_KP_Subtract	('-'|(KEY_KP_MINUS<<8))
#define VK_KP_Multiply	('*'|(KEY_KP_MULT<<8))
#define VK_KP_Divide	('/'|(KEY_KP_DIV<<8))

#endif KSYMDEF_H
