/*
	KON - Kanji ON Linux Console -
	Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)

	KON is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	KON is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include	"big5con.h"

void DownShmem(char fnum)
{
    key_t shmkey;
    int	shmid;
    struct shmid_ds shmseg;

    shmkey = ftok(CONFIG_NAME, fnum);
    shmkey = 5000 + (fnum & 0x7F);
    if ((shmid = shmget(shmkey, sizeof(struct fontInfo), 0444)) < 0)
	return;
    shmctl(shmid, IPC_STAT, &shmseg);
    if (shmseg.shm_nattch < 1) {
	shmctl(shmid, IPC_RMID, 0);
    }
}

u_char	*GetShmem(fnum)
char	fnum;
{
    key_t shmkey;
    int shmid;

    shmkey = ftok(CONFIG_NAME, fnum);
    shmkey = 5000 + (fnum & 0x7F);
    if ((shmid = shmget(shmkey, sizeof(struct fontInfo), 0444)) < 0) return(0);
    return((u_char*)shmat(shmid, 0, SHM_RDONLY));
}
