u_char	*LoadFromShm(u_char *fbuff, int fd, struct fontInfo *fi)
{
	int	shmid;
	u_char	*addr;

	read(fd, &shmid, sizeof(shmid));
	read(fd, fi, sizeof(struct fontInfo));
	addr = memalign(fi->size, PAGE_SIZE);
	if (addr < 0) {
		Perror("memalign");
		return NULL;
	}
	if ((addr = shmat(shmid, addr, 0)) == (char *) -1) {
		Perror("shmat");
		free(addr);
		return NULL;
	}
	if (fbuff)
		free(fbuff);
	return addr;
}
