/*
 * KON - Kanji ON Linux Console - Copyright (C) 1992, 1993, 1994 Takashi
 * MANABE (manabe@tut.ac.jp)
 * 
 * KON is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * KON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include	"big5con.h"

static char    *startupStr, *execProg;

int
ConfigExecProg(const char *string)
{
    execProg = strdup(string);
    return SUCCESS;
}

static int
ConfigStartup(const char *string)
{
    startupStr = strdup(string);
    return SUCCESS;
}

static void
RunStartupCmd(void)
{
    char           *p;

    p = strtok(startupStr, "\n");
    while (p) {
	system(p);
	p = strtok(NULL, "\n");
    }
}

static bool     startupMessage;

static int
ConfigMessage(const char *confstr)
{
    startupMessage = BoolConf(confstr);
    return SUCCESS;
}

void
ChildInit(void)
{
    DefineCap("StartupMessage", ConfigMessage, "On");
    DefineCap("StartUp", ConfigStartup,
    "cat /usr/local/lib/fonts/kc8x15.smf | /usr/local/bin/b5cfld -t smf -n\n"
     "cat /usr/local/lib/fonts/kc15f.smf | /usr/local/bin/b5cfld -t smf -n");
}

void
ChildCleanup(void)
{
    free(startupStr);
}

void
ChildStart(FILE * errfp)
{
    char           *shell, *tail, *tcap;
    char            buff[80];
#if defined(__FreeBSD__) 
    struct winsize win;
#endif

    setgid(getgid());
    setuid(getuid());

    RunStartupCmd();

#if defined(linux)
    sprintf(buff, "TERMCAP=:co#%d:li#%d:tc=console:",
	    dInfo.txmax + 1, dInfo.tymax + 1);
#elif defined(__FreeBSD__)
    win.ws_row = dInfo.tymax; /* by b5c: input bar need one row */
    win.ws_col = dInfo.txmax + 1;
    win.ws_xpixel = win.ws_ypixel = 0;
    ioctl(STDIN_FILENO, TIOCSWINSZ, &win);
    sprintf(buff, "TERM=vt100");
#endif
    tcap = strdup(buff);
    putenv(tcap);

    if (startupMessage) {
	printf("Big5Con " VERSION " for FreeBSD by Hung-Chi Chu, NTUEE\n");
	printf("Big5Con comes with \x1b[4mABSOLUTELY NO WARRANTY\x1b[m.\n");
	printf("Big5Con is free software, and you are welcome to redistribute it\n");
	printf("        under certain conditions; see COPYING for details.\r\n");
	printf("Big5Con is based on:\n");
	printf("        KON v0.99.4e for Linux by Takashi MANABE and MAEDA Atusi,\n");
	printf("        KON v0.01 for FreeBSD-2.x by Takashi OGURA,\r\n");
	printf("        and XCIN-2.1b by Edward Der-Hua Liu, Hsin-Chu, Taiwan\n");
    }
#if defined(linux)
    printf("Big5Con using VT number %c.\n\n",
	   *(ttyname(fileno(errfp)) + 8));
#elif defined(__FreeBSD__)
    printf("Big5Con using VT number %c.\n\n",
	   ttyname(fileno(errfp)) ? *(ttyname(fileno(errfp)) + 9) : '?');
#endif
    fflush(stdout);

    if (execProg)
	execlp(execProg, execProg, 0);
    else {
	if ((execProg = getenv("SHELL")) == NULL)
	    execProg = "/bin/sh";
	if ((tail = rindex(execProg, '/')) == NULL)
	    tail = " sh";
	sprintf(buff, "-%s", tail + 1);
	execl(execProg, buff, 0);
    }
    fprintf(errfp, "Big5Con> couldn't exec shell\r\n");
    fprintf(errfp, "%s: %s\r\n", execProg, strerror(errno));
    exit(EXIT_FAILURE);
}
