/*
 * KON - Kanji ON Linux Console - errors.c Copyright (C) 1993 by MAEDA Atusi
 * (mad@math.keio.ac.jp)
 * 
 * KON is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * KON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include	"big5con.h"

#define MAX_MSGLEN 1024

static void 
KonPrintf(const char *head, const char *format, va_list args)
{
    char            buf[MAX_MSGLEN];

    if (con.text_mode) {
	fprintf(stderr, "%s", head);
	vfprintf(stderr, format, args);
    } else {
	VtEmu(head, strlen(head));
	vsprintf(buf, format, args);
	VtEmu(buf, strlen(buf));
    }
}

void 
fatal(const char *format,...)
{
    va_list         args;

    va_start(args, format);
    fprintf(stderr, "Big5Con> fatal error: ");
    vfprintf(stderr, format, args);
    va_end(args);
    exit(EXIT_FAILURE);
}

void 
warn(const char *format,...)
{
    va_list         args;

    va_start(args, format);
    KonPrintf("Big5Con> warning: ", format, args);
    va_end(args);
}

void 
error(const char *format,...)
{
    va_list         args;

    va_start(args, format);
    KonPrintf("Big5Con> error: ", format, args);
    va_end(args);
}

void 
message(const char *format,...)
{
    va_list         args;

    va_start(args, format);
    KonPrintf("Big5Con> ", format, args);
    va_end(args);
}

void 
Perror(const char *msg)
{
    message("system error - %s: %s\r\n", msg, strerror(errno));
}

void 
PerrorExit(const char *message)
{
    fprintf(stderr, "%s: %s\r\n", message, strerror(errno));
    exit(EXIT_FAILURE);
}
