/*
 * KON - Kanji ON Linux Console - Copyright (C) 1992, 1993 Takashi MANABE
 * (manabe@tut.ac.jp)
 * 
 * KON is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * KON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

#include	"big5con.h"

struct fontRegs *dbFReg, *sbFReg;

u_char         *GetShmem();

void 
FontDetach(bool down)
{
    int             i;

    i = 0;
    while (fSRegs[i].registry) {
	if (fSRegs[i].stat & FR_ATTACH)
	    shmdt(fSRegs[i].bitmap - sizeof(struct fontInfo));
	if (down)
	    DownShmem(i | CHR_SFLD);
	fSRegs[i].width = fSRegs[i].high =
	    fSRegs[i].size = fSRegs[i].stat = 0;
	i++;
    }
    i = 0;
    while (fDRegs[i].registry) {
	if (fDRegs[i].stat & FR_ATTACH)
	    shmdt(fDRegs[i].bitmap - sizeof(struct fontInfo));
	if (down)
	    DownShmem(i | CHR_DFLD);
	fDRegs[i].width = fDRegs[i].high =
	    fDRegs[i].size = fDRegs[i].stat = 0;
	i++;
    }
}

void 
FontAttach()
{
    int             i;
    u_char         *font;
    struct fontInfo *fi;

    i = 0;
    while (fSRegs[i].registry) {
	if ((font = GetShmem(i | CHR_SFLD)) != NULL) {
	    fi = (struct fontInfo *) font;
	    fSRegs[i].high = fi->high;
	    fSRegs[i].stat = FR_ATTACH;
	    fSRegs[i].size = fi->size;
	    fSRegs[i].bitmap = font + sizeof(struct fontInfo);
	    sbFReg = &fSRegs[i];
	} else
	    fSRegs[i].stat = 0;
	i++;
    }
    if (fSRegs[lInfo.sb].stat)
	sbFReg = &fSRegs[lInfo.sb];
#if 1
    i = 0;
    while (fSRegs[i].registry) {
	if (!fSRegs[i].stat) {
	    fSRegs[i].high = sbFReg->high;
	    fSRegs[i].size = sbFReg->size;
	    fSRegs[i].bitmap = sbFReg->bitmap;
	    fSRegs[i].stat = FR_PROXY;
	}
	i++;
    }
#endif
    i = 0;
    while (fDRegs[i].registry) {
	if ((font = GetShmem(i | CHR_DFLD)) != NULL) {
	    fi = (struct fontInfo *) font;
	    fDRegs[i].high = fi->high;
	    fDRegs[i].stat = FR_ATTACH;
	    fDRegs[i].size = fi->size;
	    fDRegs[i].bitmap = font + sizeof(struct fontInfo);
	}
	i++;
    }
    dbFReg = &fDRegs[lInfo.db];
}
