/*
 * KON - Kanji ON Linux Console - Copyright (C) 1992, 1993, 1994 Takashi
 * MANABE (manabe@Roy.dsl.tutics.tut.ac.jp)
 * 
 * KON is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * KON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * modified for Big5Con by Hung-Chi Chu <hcchu@r350.ee.ntu.edu.tw>
 */

#include "big5con.h"

extern void     ChangeNewConsole();

int 
main(int argc, const char *argv[])
{
    fprintf(stderr, "Big5Con - Big5 Chinese Console version "VERSION"\n\n");
    if (geteuid() != 0) {
	fprintf(stderr, "can not get I/O permissions.\n");
	exit(EXIT_FAILURE);
    }
    ChangeNewConsole();
    TermInit(argc - 1, argv + 1);
    if (ReadConfig(CONFIG_NAME) < 0) {
	fprintf(stderr, "Big5Con> error reading %s\n", CONFIG_NAME);
	exit(EXIT_FAILURE);
    }
    TermStart(argc, argv);
}
