/*
 * Copyright (C) 1994	Edward Der-Hua Liu, Hsin-Chu, Taiwan
 */

#include "big5con.h"

static u_char  *bf = 0;
static int      bfsize = 0;

static struct keystruc {
    int             ksym;
    int             stridx;
}               ktab[128];
static int      ktabcount = 0;

void 
set_ktab()
{
    int            *ksymp, ksym;
    int             ofs, idx;

    bzero(ktab, sizeof(ktab));
    for (idx = 0, ktabcount = 0, ofs = 0;;) {
	memcpy(&ksym, &bf[ofs], sizeof(int));
	ofs += sizeof(int);
	/* printf("%d ksym:%x\n", ksym); */
	if (!ksym)
	    break;
	ktab[ktabcount].ksym = ksym;
	ktab[ktabcount].stridx = ofs;
	while (bf[ofs])
	    ofs++;
	ofs++;
	ktabcount++;
    }				/* for */
}

char           *phrfname = 0;
void 
init_phrase()
{
    extern char     TabDir[];
    char            fname[80];
    FILE           *fp;
    int             size;

    if (phrfname) {
	strcpy(fname, phrfname);
    } else {
	strcpy(fname, TabDir);
	strcat(fname, "sample.phs.b5c");
    }
    if ((fp = fopen(fname, "r")) == NULL) {
	error("%s", fname);
	return;
    }
    fread(&size, 4, 1, fp);
    if ((bf = (u_char *) malloc(size)) == NULL) {
	error("malloc");
	return;
    }
    fread(bf, 1, size, fp);
    fclose(fp);
    set_ktab();
}

lookup_key(int ksym)
{
    int             i;
    for (i = 0; i < ktabcount; i++)
	if (ktab[i].ksym == ksym) {
	    putstr(&bf[ktab[i].stridx]);
	    return 1;
	}
    return 1;
}
