/*
 * KON - Kanji ON Linux Console - Copyright (C) 1992, 1993 Takashi MANABE
 * (manabe@tut.ac.jp)
 * 
 * KON is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * KON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Original utmp.c was ported from Wnn by komeda@ics.osaka-u.ac.jp. This code
 * is written by manabe@tut.ac.jp, and this does not contain old code (Wnn's
 * setutmp.c).
 * 
 * Thanks to komeda@ics.osaka-u.ac.jp.
 */
/*
 * The code for FreeBSD is written by Hung-Chi Chu <hcchu@r350.ee.ntu.edu.tw>
 */

#include	"big5con.h"

static int      ttyGid;

void 
SetUtmp(char *tty)
{
#if defined(__FreeBSD__)
    struct utmp     utmp;
    struct passwd  *pw;
    char           *ttyline;
    int             fd;

    ttyline = strdup(tty);
    ttyline = strrchr(ttyline, '/') + 1;
    *ttyline = 't';
    if ((fd = open(_PATH_UTMP, O_RDWR, 0)) < 0)
	return;
    while (read(fd, &utmp, sizeof(struct utmp)) == sizeof(struct utmp))
	if (!strncmp(utmp.ut_line, ttyline, UT_LINESIZE)) {
	    lseek(fd, -(off_t) sizeof(struct utmp), SEEK_CUR);
	    break;
	}
    strncpy(utmp.ut_line, ttyline, UT_LINESIZE);
    ttyline = strrchr(ttyname(0), '/');
    *ttyline = ':';
    strncpy(utmp.ut_host, ttyline, UT_HOSTSIZE);
    time(&(utmp.ut_time));
    pw = getpwuid(getuid());
    strncpy(utmp.ut_name, pw->pw_name, UT_NAMESIZE);
    write(fd, &utmp, sizeof(struct utmp));
    close(fd);
#endif
#if defined(linux)
    struct utmp     utmp;
    struct passwd  *pw;
    struct group   *ttygrp;
    char           *tn;

    pw = getpwuid(getuid());
    tn = rindex(tty, '/') + 1;
    memset((char *)&utmp, 0, sizeof(utmp));
    strncpy(utmp.ut_id, tn + 3, sizeof(utmp.ut_id));
    utmp.ut_type = DEAD_PROCESS;
    setutent();
    getutid(&utmp);
    utmp.ut_type = USER_PROCESS;
    utmp.ut_pid = getpid();
    strncpy(utmp.ut_line, tn, sizeof(utmp.ut_line));
    strncpy(utmp.ut_user, pw->pw_name, sizeof(utmp.ut_user));
    time(&(utmp.ut_time));
    pututline(&utmp);
    endutent();
    if ((ttygrp = getgrnam("tty")) != NULL)
	ttyGid = ttygrp->gr_gid;
    else
	ttyGid = -1;
    chmod(tty, 0622);
    chown(tty, getuid(), ttyGid);
#endif
}

void 
ResetUtmp(char *tty)
{
#if defined(__FreeBSD__)
    struct utmp     ut;
    char           *ttyline;
    int             fd;

    ttyline = strdup(tty);
    ttyline = strrchr(ttyline, '/') + 1;
    *ttyline = 't';
    if ((fd = open(_PATH_UTMP, O_RDWR, 0)) < 0)
	return;
    while (read(fd, &ut, sizeof(struct utmp)) == sizeof(struct utmp))
	if (!strncmp(ut.ut_line, ttyline, UT_LINESIZE)) {
	    bzero(&ut, sizeof(struct utmp));
	    (void)lseek(fd, -(off_t) sizeof(struct utmp), SEEK_CUR);
	    (void)write(fd, &ut, sizeof(struct utmp));
	}
    close(fd);
#endif
#if defined(linux)
    struct utmp     utmp, *utp;
    char           *tn;

    tn = rindex(tty, '/') + 4;
    memset((char *)&utmp, 0, sizeof(utmp));
    strncpy(utmp.ut_id, tn, sizeof(utmp.ut_id));
    utmp.ut_type = USER_PROCESS;
    setutent();
    utp = getutid(&utmp);
    utp->ut_type = DEAD_PROCESS;
    memset(utp->ut_user, 0, sizeof(utmp.ut_user));
    utp->ut_type = DEAD_PROCESS;
    time(&(utp->ut_time));
    pututline(utp);
    endutent();
    chmod(tty, 0600);
    chown(tty, 0, ttyGid);
#endif
}
