/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.AbstractTrainer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.onehead.SingleDP;
import org.biojava.bio.dp.onehead.SingleDPMatrix;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class BaumWelchSampler
extends AbstractTrainer
implements Serializable {
    protected double singleSequenceIteration(ModelTrainer trainer, SymbolList symList) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        return this.singleSequenceIteration(trainer, symList, ScoreType.PROBABILITY);
    }

    protected double singleSequenceIteration(ModelTrainer trainer, SymbolList symList, ScoreType scoreType) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        int s;
        double[] bsc;
        double[] fsc;
        Symbol sym;
        int i;
        SingleDP dp = (SingleDP)this.getDP();
        State[] states = dp.getStates();
        int[][] forwardTransitions = dp.getForwardTransitions();
        double[][] forwardTransitionScores = dp.getForwardTransitionScores(scoreType);
        int[][] backwardTransitions = dp.getBackwardTransitions();
        double[][] backwardTransitionScores = dp.getBackwardTransitionScores(scoreType);
        MarkovModel model = dp.getModel();
        SymbolList[] rll = new SymbolList[]{symList};
        SingleDPMatrix fm = (SingleDPMatrix)dp.forwardMatrix(rll, scoreType);
        double fs = fm.getScore();
        SingleDPMatrix bm = (SingleDPMatrix)dp.backwardMatrix(rll, scoreType);
        double bs = bm.getScore();
        Symbol gap = AlphabetManager.getGapSymbol();
        block2: for (i = 1; i <= symList.length(); ++i) {
            sym = symList.symbolAt(i);
            fsc = fm.scores[i];
            bsc = bm.scores[i];
            double p = Math.random();
            for (s = 0; s < dp.getDotStatesIndex(); ++s) {
                if (states[s] instanceof MagicalState || !((p -= Math.exp(fsc[s] + bsc[s] - fs)) <= 0.0)) continue;
                trainer.addCount(((EmissionState)states[s]).getDistribution(), sym, 1.0);
                continue block2;
            }
        }
        for (i = 0; i <= symList.length(); ++i) {
            sym = i < symList.length() ? symList.symbolAt(i + 1) : gap;
            fsc = fm.scores[i];
            bsc = bm.scores[i + 1];
            double[] bsc2 = bm.scores[i];
            double[] weightVector = dp.getEmission(sym, scoreType);
            block5: for (s = 0; s < states.length; ++s) {
                int[] ts = backwardTransitions[s];
                double[] tss = backwardTransitionScores[s];
                Distribution dist = model.getWeights(states[s]);
                double p = Math.random();
                for (int tc = 0; tc < ts.length; ++tc) {
                    int t = ts[tc];
                    double weight = 1.0;
                    if (states[t] instanceof EmissionState) {
                        weight = Math.exp(weightVector[t]);
                    }
                    if (weight == 0.0) continue;
                    p = t < dp.getDotStatesIndex() ? (p -= Math.exp(fsc[s] + tss[tc] + bsc[t] - fs) * weight) : (p -= Math.exp(fsc[s] + tss[tc] + bsc2[t] - fs));
                    if (!(p <= 0.0)) continue;
                    try {
                        trainer.addCount(dist, states[t], 1.0);
                        continue block5;
                    }
                    catch (IllegalSymbolException ise) {
                        throw new BioError("Transition in backwardTransitions dissapeared", ise);
                    }
                }
            }
        }
        return fs;
    }

    public BaumWelchSampler(DP dp) {
        super(dp);
    }
}

