/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public interface ScoreType {
    public static final ScoreType PROBABILITY = new Probability();
    public static final ScoreType ODDS = new Odds();
    public static final ScoreType NULL_MODEL = new NullModel();

    public double calculateScore(Distribution var1, Symbol var2) throws IllegalSymbolException;

    public static class NullModel
    implements ScoreType,
    Serializable {
        public double calculateScore(Distribution dist, Symbol sym) throws IllegalSymbolException {
            return dist.getNullModel().getWeight(sym);
        }
    }

    public static class Odds
    implements ScoreType,
    Serializable {
        public double calculateScore(Distribution dist, Symbol sym) throws IllegalSymbolException {
            double d = dist.getWeight(sym);
            double n = dist.getNullModel().getWeight(sym);
            return d / n;
        }
    }

    public static class Probability
    implements ScoreType,
    Serializable {
        public double calculateScore(Distribution dist, Symbol sym) throws IllegalSymbolException {
            return dist.getWeight(sym);
        }
    }
}

