/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence.tracklayout;

import java.util.ArrayList;
import org.biojava.bio.gui.sequence.tracklayout.TrackLayout;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;

public class UserDefinedTrackLayout
implements TrackLayout {
    private Sequence sequence;
    private RangeLocation globalLocation;
    private RangeLocation[] ranges;
    private int wrap = 6;
    private int wrapInc = 1;

    public UserDefinedTrackLayout(RangeLocation[] ranges) {
        this.ranges = ranges;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public void setRange(RangeLocation loc) {
        this.globalLocation = loc;
    }

    public void setWrap(int wrap) {
        this.wrap = wrap;
    }

    public int getWrap() {
        return this.wrap;
    }

    public RangeLocation[] getRanges() {
        ArrayList<Location> list = new ArrayList<Location>();
        for (int i = 0; i < this.ranges.length; ++i) {
            Location loc = LocationTools.intersection(this.globalLocation, this.ranges[i]);
            if (((Object)loc).equals(Location.empty)) continue;
            list.add(loc);
        }
        return list.toArray(new RangeLocation[0]);
    }

    public int getWrapIncrement() {
        return this.wrapInc;
    }

    public void setWrapIncrement(int inc) {
        this.wrapInc = inc;
    }
}

