/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.program.homologene.AbstractOrthoPairSet;
import org.biojava.bio.program.homologene.OrthoPair;
import org.biojava.bio.program.homologene.OrthoPairSet;
import org.biojava.bio.program.homologene.Taxon;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleOrthoPairSet
extends AbstractOrthoPairSet {
    String name;
    Set orthologies = new HashSet();

    public SimpleOrthoPairSet() {
        this.generateChangeSupport();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrthoPair(OrthoPair orthology) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.orthologies.add(orthology);
        } else {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(OrthoPairSet.MODIFY);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, OrthoPairSet.MODIFY);
                cs.firePreChangeEvent(ce);
                this.orthologies.add(orthology);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrthoPair(OrthoPair orthology) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.orthologies.remove(orthology);
        } else {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(OrthoPairSet.MODIFY);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, OrthoPairSet.MODIFY);
                cs.firePreChangeEvent(ce);
                this.orthologies.remove(orthology);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public OrthoPairSet.Iterator iterator() {
        return new Iterator(this.orthologies.iterator());
    }

    public double getMinIdentity() {
        double min = 100.0;
        java.util.Iterator orthologiesI = this.orthologies.iterator();
        while (orthologiesI.hasNext()) {
            OrthoPair currOrthoPair = (OrthoPair)orthologiesI.next();
            min = Math.min(min, currOrthoPair.getPercentIdentity());
        }
        return min;
    }

    public int size() {
        return this.orthologies.size();
    }

    public Set getTaxa() {
        HashSet<Taxon> taxa = new HashSet<Taxon>();
        java.util.Iterator orthoI = this.orthologies.iterator();
        while (orthoI.hasNext()) {
            OrthoPair currOrtho = (OrthoPair)orthoI.next();
            taxa.add(currOrtho.getFirstOrthologue().getTaxon());
            taxa.add(currOrtho.getSecondOrthologue().getTaxon());
        }
        return taxa;
    }

    public class Iterator
    implements OrthoPairSet.Iterator {
        private java.util.Iterator setIterator;

        private Iterator(java.util.Iterator setIterator) {
            this.setIterator = setIterator;
        }

        public boolean hasNext() {
            return this.setIterator.hasNext();
        }

        public OrthoPair nextOrthoPair() {
            return (OrthoPair)this.setIterator.next();
        }
    }
}

