/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class DomainSectionSAXParser
extends AbstractNativeAppSAXParser {
    private BlastLikeVersionSupport oVersion;
    private BufferedReader oContents;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private String oLine;

    DomainSectionSAXParser(BlastLikeVersionSupport poVersion, String poNamespacePrefix) {
        this.oVersion = poVersion;
        this.setNamespacePrefix(poNamespacePrefix);
        this.addPrefixMapping("biojava", "http://www.biojava.org");
    }

    public void parse(BufferedReader poContents, String poLine) throws SAXException {
        this.oContents = poContents;
        try {
            this.oLine = poLine;
            while (!this.oLine.startsWith("----")) {
                this.oLine = this.oContents.readLine();
            }
            this.oLine = this.oContents.readLine();
            if (this.oLine.trim().equals("[no hits above thresholds]")) {
                this.oLine = this.oContents.readLine();
                return;
            }
            while (!this.oLine.trim().equals("")) {
                StringTokenizer st = new StringTokenizer(this.oLine);
                this.oAtts.clear();
                this.oAttQName.setQName("modelId");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "/");
                this.oAttQName.setQName("domainPosition");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st2.nextToken());
                this.oAttQName.setQName("sequenceFrom");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                this.oAttQName.setQName("sequenceTo");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                String oTemp = st.nextToken();
                this.oAttQName.setQName("startPositionOfSequence");
                if (oTemp.charAt(0) == '.') {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "internal");
                } else {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "end");
                }
                this.oAttQName.setQName("endPositionOfSequence");
                if (oTemp.charAt(1) == '.') {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "internal");
                } else {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "end");
                }
                this.oAttQName.setQName("hmmFrom");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                this.oAttQName.setQName("hmmTo");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                oTemp = st.nextToken();
                this.oAttQName.setQName("startPositionOfModel");
                if (oTemp.charAt(0) == '.') {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "internal");
                } else {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "end");
                }
                this.oAttQName.setQName("endPositionOfModel");
                if (oTemp.charAt(1) == '.') {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "internal");
                } else {
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "end");
                }
                this.oAttQName.setQName("score");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                this.oAttQName.setQName("expectValue");
                this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", st.nextToken());
                this.startElement(new QName(this, this.prefix("DomainHit")), this.oAtts);
                this.endElement(new QName(this, this.prefix("DomainHit")));
                this.oLine = this.oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interupted");
        }
    }
}

