/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.PrintStream;

public interface SearchListener {
    public void startSearch(String var1);

    public void endSearch(String var1);

    public void hit(int var1, int var2, int var3, int var4);

    public static final class Echo
    implements SearchListener {
        private final PrintStream out;

        public Echo(PrintStream out) {
            this.out = out;
        }

        public void startSearch(String seqID) {
            this.out.println("startSearch: " + seqID);
        }

        public void endSearch(String seqID) {
            this.out.println("endSearch: " + seqID);
        }

        public void hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
            this.out.println("hit.\thitID: " + hitID + "\tqueryOffset: " + queryOffset + "\thitOffset: " + hitOffset + "\thitLength: " + hitLength);
        }
    }

    public static final class FilterByLength
    extends Wrapper {
        private final int minLength;

        public FilterByLength(SearchListener delegate, int minLength) {
            super(delegate);
            this.minLength = minLength;
        }

        public void hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
            if (hitLength >= this.minLength) {
                super.hit(hitID, queryOffset, hitOffset, hitLength);
            }
        }
    }

    public static final class Tee
    implements SearchListener {
        private final SearchListener d1;
        private final SearchListener d2;

        public Tee(SearchListener d1, SearchListener d2) {
            if (d1 == null || d2 == null) {
                throw new IllegalArgumentException("Delegates can not be null: " + d1 + " " + d2);
            }
            this.d1 = d1;
            this.d2 = d2;
        }

        public void startSearch(String seqID) {
            this.d1.startSearch(seqID);
            this.d2.startSearch(seqID);
        }

        public void endSearch(String seqID) {
            this.d1.endSearch(seqID);
            this.d2.endSearch(seqID);
        }

        public void hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
            this.d1.hit(hitID, queryOffset, hitOffset, hitLength);
            this.d2.hit(hitID, queryOffset, hitOffset, hitLength);
        }
    }

    public static abstract class Wrapper
    implements SearchListener {
        private final SearchListener delegate;

        public Wrapper(SearchListener delegate) {
            this.delegate = delegate;
        }

        public void startSearch(String seqID) {
            this.delegate.startSearch(seqID);
        }

        public void endSearch(String seqID) {
            this.delegate.endSearch(seqID);
        }

        public void hit(int hitID, int queryOffset, int hitOffset, int hitLength) {
            this.delegate.hit(hitID, queryOffset, hitOffset, hitLength);
        }
    }
}

