/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import org.biojava.bio.program.ssbind.SeqSimilarityStAXAdapter;
import org.biojava.bio.program.ssbind.SeqSimilarityStAXHandler;
import org.biojava.bio.program.ssbind.StAXHandlerFactory;
import org.biojava.bio.program.xff.ElementRecognizer;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AlignmentStAXHandler
extends SeqSimilarityStAXHandler {
    public static final StAXHandlerFactory ALIGNMENT_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
            return new AlignmentStAXHandler(ssContext);
        }
    };

    AlignmentStAXHandler(SeqSimilarityStAXAdapter ssContext) {
        super(ssContext);
        this.addHandler(new ElementRecognizer.ByNSName("http://www.biojava.org", "QuerySequence"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
                return new QuerySequenceStAXHandler();
            }
        });
        this.addHandler(new ElementRecognizer.ByNSName("http://www.biojava.org", "HitSequence"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(SeqSimilarityStAXAdapter ssContext) {
                return new HitSequenceStAXHandler();
            }
        });
    }

    private class HitSequenceStAXHandler
    extends StringElementHandlerBase {
        private SearchContentHandler sch;

        private HitSequenceStAXHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            super.startElement(nsURI, localName, qName, attrs, dm);
            this.sch = AlignmentStAXHandler.this.ssContext.getSearchContentHandler();
            this.sch.addSubHitProperty("subjectSequenceStart", attrs.getValue("startPosition"));
            this.sch.addSubHitProperty("subjectSequenceEnd", attrs.getValue("stopPosition"));
        }

        protected void setStringValue(String s) throws SAXException {
            this.sch = AlignmentStAXHandler.this.ssContext.getSearchContentHandler();
            this.sch.addSubHitProperty("subjectSequence", s);
        }
    }

    private class QuerySequenceStAXHandler
    extends StringElementHandlerBase {
        private SearchContentHandler sch;

        private QuerySequenceStAXHandler() {
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            super.startElement(nsURI, localName, qName, attrs, dm);
            this.sch = AlignmentStAXHandler.this.ssContext.getSearchContentHandler();
            this.sch.addSubHitProperty("querySequenceStart", attrs.getValue("startPosition"));
            this.sch.addSubHitProperty("querySequenceEnd", attrs.getValue("stopPosition"));
        }

        protected void setStringValue(String s) throws SAXException {
            this.sch = AlignmentStAXHandler.this.ssContext.getSearchContentHandler();
            this.sch.addSubHitProperty("querySequence", s);
        }
    }
}

