/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.PairDistribution;
import org.biojava.bio.dist.SimpleDistribution;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.ChangeVetoException;

public final class DNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final FiniteAlphabet dna;
    private static final SymbolTokenization dnaTokens;
    private static final AtomicSymbol a;
    private static final AtomicSymbol g;
    private static final AtomicSymbol c;
    private static final AtomicSymbol t;
    private static final Symbol n;
    private static final SimpleReversibleTranslationTable transcriptionTable;
    private static Map symbolToComplement;

    public static AtomicSymbol a() {
        return a;
    }

    public static AtomicSymbol g() {
        return g;
    }

    public static AtomicSymbol c() {
        return c;
    }

    public static AtomicSymbol t() {
        return t;
    }

    public static Symbol n() {
        return n;
    }

    private DNATools() {
    }

    public static FiniteAlphabet getDNA() {
        return dna;
    }

    public static FiniteAlphabet getDNAxDNA() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(DNA x DNA)");
    }

    public static FiniteAlphabet getCodonAlphabet() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(DNA x DNA x DNA)");
    }

    public static SymbolList createDNA(String dna) throws IllegalSymbolException {
        SymbolTokenization p = null;
        try {
            p = DNATools.getDNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Something has gone badly wrong with DNA", e);
        }
        return new SimpleSymbolList(p, dna);
    }

    public static Sequence createDNASequence(String dna, String name) throws IllegalSymbolException {
        if (dna.indexOf(45) != -1 || dna.indexOf(126) != -1) {
            return DNATools.createGappedDNASequence(dna, name);
        }
        try {
            return new SimpleSequenceFactory().createSequence(DNATools.createDNA(dna), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError("Something has gone badly wrong with DNA", se);
        }
    }

    public static GappedSequence createGappedDNASequence(String dna, String name) throws IllegalSymbolException {
        String dna1 = dna.replaceAll("-", "");
        Sequence dnaSeq = DNATools.createDNASequence(dna1, name);
        SimpleGappedSequence dnaSeq1 = new SimpleGappedSequence(dnaSeq);
        int pos = dna.indexOf(45, 0);
        while (pos != -1) {
            dnaSeq1.addGapInView(pos + 1);
            pos = dna.indexOf(45, pos + 1);
        }
        return dnaSeq1;
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == t) {
            return 3;
        }
        DNATools.getDNA().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return t;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return t;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == t) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        DNATools.getDNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        SymbolTokenization toke;
        String t = String.valueOf(token);
        try {
            toke = DNATools.getDNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Cannot find the 'token' Tokenization for DNA!?", e);
        }
        return toke.parseToken(t);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, DNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), DNATools.complementTable());
    }

    public static SymbolList flip(SymbolList list, StrandedFeature.Strand strand) throws IllegalAlphabetException {
        if (strand == StrandedFeature.NEGATIVE) {
            return DNATools.reverseComplement(list);
        }
        return list;
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static char dnaToken(Symbol sym) throws IllegalSymbolException {
        return dnaTokens.tokenizeSymbol(sym).charAt(0);
    }

    public static Distribution getDNADistribution(double fractionGC) {
        try {
            SimpleDistribution dist = new SimpleDistribution(DNATools.getDNA());
            double gc = 0.5 * fractionGC;
            double at = 0.5 * (1.0 - fractionGC);
            dist.setWeight(DNATools.a(), at);
            dist.setWeight(DNATools.t(), at);
            dist.setWeight(DNATools.c(), gc);
            dist.setWeight(DNATools.g(), gc);
            return dist;
        }
        catch (IllegalSymbolException ise) {
            return null;
        }
        catch (ChangeVetoException cve) {
            return null;
        }
    }

    public static Distribution getDNAxDNADistribution(double fractionGC0, double fractionGC1) {
        return new PairDistribution(DNATools.getDNADistribution(fractionGC0), DNATools.getDNADistribution(fractionGC1));
    }

    public static SymbolList toRNA(SymbolList syms) throws IllegalAlphabetException {
        return SymbolListViews.translate(syms, transcriptionTable);
    }

    public static SymbolList transcribeToRNA(SymbolList syms) throws IllegalAlphabetException {
        syms = DNATools.reverseComplement(syms);
        return DNATools.toRNA(syms);
    }

    static {
        try {
            dna = (FiniteAlphabet)AlphabetManager.alphabetForName("DNA");
            dnaTokens = dna.getTokenization("token");
            SimpleSymbolList syms = new SimpleSymbolList(dnaTokens, "agctn");
            a = (AtomicSymbol)syms.symbolAt(1);
            g = (AtomicSymbol)syms.symbolAt(2);
            c = (AtomicSymbol)syms.symbolAt(3);
            t = (AtomicSymbol)syms.symbolAt(4);
            n = syms.symbolAt(5);
            symbolToComplement = new HashMap();
            Symbol gap = dna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            Iterator i = AlphabetManager.getAllSymbols(dna).iterator();
            while (i.hasNext()) {
                Symbol as = (Symbol)i.next();
                FiniteAlphabet matches = (FiniteAlphabet)as.getMatches();
                if (matches.size() <= 1) continue;
                HashSet<Symbol> l = new HashSet<Symbol>();
                Iterator j = matches.iterator();
                while (j.hasNext()) {
                    l.add(DNATools.complement((Symbol)j.next()));
                }
                symbolToComplement.put(as, dna.getAmbiguity(l));
            }
            complementTable = new DNAComplementTranslationTable();
            transcriptionTable = new SimpleReversibleTranslationTable(DNATools.getDNA(), RNATools.getRNA());
            transcriptionTable.setTranslation(a, RNATools.a());
            transcriptionTable.setTranslation(c, RNATools.c());
            transcriptionTable.setTranslation(g, RNATools.g());
            transcriptionTable.setTranslation(t, RNATools.u());
        }
        catch (Throwable th) {
            throw new BioError("Unable to initialize DNATools", th);
        }
    }

    private static class DNAComplementTranslationTable
    implements ReversibleTranslationTable {
        private DNAComplementTranslationTable() {
        }

        public Symbol translate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Symbol untranslate(Symbol s) throws IllegalSymbolException {
            return DNATools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return DNATools.getDNA();
        }

        public Alphabet getTargetAlphabet() {
            return DNATools.getDNA();
        }
    }
}

