/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.FetchURL;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;

public class SwissprotSequenceDB {
    private static SequenceFormat format;
    private static String DBName;
    private boolean IOExceptionFound = false;

    protected SequenceFormat getSequenceFormat() {
        return format;
    }

    protected Alphabet getAlphabet() {
        return ProteinTools.getTAlphabet();
    }

    protected URL getAddress(String id) throws MalformedURLException {
        String defaultReturnFormat = "";
        FetchURL seqURL = new FetchURL(DBName, defaultReturnFormat);
        String baseurl = seqURL.getbaseURL();
        String url = baseurl + id;
        return new URL(url);
    }

    public String getName() {
        return DBName;
    }

    public Sequence getSequence(String id) throws BioException {
        try {
            this.IOExceptionFound = false;
            URL queryURL = this.getAddress(id);
            SequenceFormat sFormat = this.getSequenceFormat();
            SimpleSequenceBuilder sbuilder = new SimpleSequenceBuilder();
            SwissprotProcessor.Factory sFact = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            Alphabet alpha = this.getAlphabet();
            SymbolTokenization rParser = alpha.getTokenization("token");
            System.err.println("got data from " + queryURL);
            DataInputStream in = new DataInputStream(queryURL.openStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            SequenceIterator seqI = SeqIOTools.readSwissprot(reader);
            return seqI.nextSequence();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            this.IOExceptionFound = true;
            return null;
        }
    }

    public boolean checkIOException() {
        return this.IOExceptionFound;
    }

    static {
        DBName = "swiss-prot";
        EmblLikeFormat emblLikeFormat = new EmblLikeFormat();
    }
}

