/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ParseErrorEvent;
import org.biojava.utils.ParseErrorListener;
import org.biojava.utils.ParseErrorSource;

public class FastaFormat
implements SequenceFormat,
Serializable,
ParseErrorListener,
ParseErrorSource {
    public static final String DEFAULT = "FASTA";
    public static final String PROPERTY_DESCRIPTIONLINE = "description_line";
    protected Vector mListeners = new Vector();
    protected int lineWidth = 60;

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener siol) throws IllegalSymbolException, IOException, ParseException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature stream end");
        }
        while (line.length() == 0) {
            line = reader.readLine();
            if (line != null) continue;
            throw new IOException("Premature stream end");
        }
        if (!line.startsWith(">")) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + line);
        }
        siol.startSequence();
        String description = line.substring(1).trim();
        String regex = "(\\S+)(\\s+(.*))*";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(description);
        if (!m.matches()) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + line);
        }
        String name = m.group(1);
        String desc = m.group(3);
        siol.setName(name);
        siol.addSequenceProperty(PROPERTY_DESCRIPTIONLINE, description);
        boolean seenEOF = this.readSequenceData(reader, symParser, siol);
        siol.endSequence();
        return !seenEOF;
    }

    private boolean readSequenceData(BufferedReader r, SymbolTokenization parser, SeqIOListener listener) throws IOException, IllegalSymbolException {
        char[] cache = new char[512];
        boolean reachedEnd = false;
        boolean seenEOF = false;
        StreamParser sparser = parser.parseStream(listener);
        while (!reachedEnd) {
            r.mark(cache.length + 1);
            int bytesRead = r.read(cache, 0, cache.length);
            if (bytesRead < 0) {
                seenEOF = true;
                reachedEnd = true;
                continue;
            }
            int parseStart = 0;
            int parseEnd = 0;
            while (!reachedEnd && parseStart < bytesRead && cache[parseStart] != '>') {
                for (parseEnd = parseStart; parseEnd < bytesRead && cache[parseEnd] != '\n' && cache[parseEnd] != '\r'; ++parseEnd) {
                }
                sparser.characters(cache, parseStart, parseEnd - parseStart);
                for (parseStart = parseEnd + 1; parseStart < bytesRead && (cache[parseStart] == '\n' || cache[parseStart] == '\r'); ++parseStart) {
                }
            }
            if (parseStart >= bytesRead || cache[parseStart] != '>') continue;
            try {
                r.reset();
            }
            catch (IOException ioe) {
                throw new IOException("Can't reset: " + ioe.getMessage() + " parseStart=" + parseStart + " bytesRead=" + bytesRead);
            }
            if (r.skip(parseStart) != (long)parseStart) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            reachedEnd = true;
        }
        sparser.close();
        return seenEOF;
    }

    protected String describeSequence(Sequence seq) {
        String description = null;
        Annotation seqAnn = seq.getAnnotation();
        description = seqAnn.containsProperty(PROPERTY_DESCRIPTIONLINE) ? (String)seqAnn.getProperty(PROPERTY_DESCRIPTIONLINE) : seq.getName();
        return description;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        os.print(">");
        os.println(this.describeSequence(seq));
        int length = seq.length();
        for (int pos = 1; pos <= length; pos += this.lineWidth) {
            int end = Math.min(pos + this.lineWidth - 1, length);
            os.println(seq.subStr(pos, end));
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (!format.equalsIgnoreCase(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format '" + format + "'");
        }
        this.writeSequence(seq, os);
    }

    public String getDefaultFormat() {
        return DEFAULT;
    }

    public synchronized void addParseErrorListener(ParseErrorListener theListener) {
        if (!this.mListeners.contains(theListener)) {
            this.mListeners.addElement(theListener);
        }
    }

    public synchronized void removeParseErrorListener(ParseErrorListener theListener) {
        if (this.mListeners.contains(theListener)) {
            this.mListeners.removeElement(theListener);
        }
    }

    public void BadLineParsed(ParseErrorEvent theEvent) {
        this.notifyParseErrorEvent(theEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyParseErrorEvent(ParseErrorEvent theEvent) {
        Vector listeners;
        FastaFormat fastaFormat = this;
        synchronized (fastaFormat) {
            listeners = (Vector)this.mListeners.clone();
        }
        for (int index = 0; index < listeners.size(); ++index) {
            ParseErrorListener client = (ParseErrorListener)listeners.elementAt(index);
            client.BadLineParsed(theEvent);
        }
    }
}

