/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

class GenpeptFileFormer
extends AbstractGenEmblFileFormer
implements SeqFileFormer {
    private PrintStream stream;
    private StringBuffer sq = new StringBuffer();
    private StringBuffer qb = new StringBuffer();
    private StringBuffer ub = new StringBuffer();
    private StringBuffer idb = null;
    private StringBuffer acb = null;
    private StringBuffer deb = null;
    private StringBuffer svb = null;
    private StringBuffer kwb = null;
    private StringBuffer osb = null;
    private StringBuffer ocb = null;
    private StringBuffer ccb = null;
    private StringBuffer ftb = new StringBuffer();
    private StringBuffer typeb = new StringBuffer();
    private StringBuffer strb = new StringBuffer();
    private StringBuffer sizeb = new StringBuffer();
    private StringBuffer circb = new StringBuffer();
    private StringBuffer mdatb = new StringBuffer();
    private StringBuffer divb = new StringBuffer();
    private SymbolTokenization proteinTokenization;

    protected GenpeptFileFormer() {
        try {
            this.proteinTokenization = ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Couldn't initialize tokenizer for the PROTEIN alphabet", ex);
        }
        this.stream = System.out;
    }

    protected GenpeptFileFormer(PrintStream stream) {
        try {
            this.proteinTokenization = ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Couldn't initialize tokenizer for the PROTEIN alphabet", ex);
        }
        this.stream = stream;
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public void setPrintStream(PrintStream stream) {
        this.stream = stream;
    }

    public void setName(String id) throws ParseException {
        this.idb = new StringBuffer("LOCUS       " + id);
    }

    public void startSequence() throws ParseException {
    }

    public void endSequence() throws ParseException {
    }

    public void setURI(String uri) throws ParseException {
    }

    public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) throws IllegalAlphabetException {
        try {
            int end = start + length - 1;
            this.locusLineCreator(length);
            if (this.idb != null) {
                this.stream.println(this.idb);
            }
            if (this.acb != null) {
                this.stream.println(this.acb);
            }
            if (this.svb != null) {
                this.stream.println(this.svb);
            }
            if (this.deb != null) {
                this.stream.println(this.deb);
            }
            if (this.kwb != null) {
                this.stream.println(this.kwb);
            }
            if (this.osb != null) {
                this.stream.println(this.osb);
            }
            if (this.ocb != null) {
                this.stream.println(this.ocb);
            }
            if (this.ccb != null) {
                this.stream.println(this.ccb);
            }
            if (this.ftb.length() != 0) {
                this.ftb.insert(0, "FEATURES             Location/Qualifiers" + this.nl);
                this.stream.print(this.ftb);
            }
            this.sq.setLength(0);
            this.sq.append("ORIGIN");
            this.stream.println(this.sq);
            int fullLine = length / 60;
            int partLine = length % 60;
            int lineCount = fullLine;
            if (partLine > 0) {
                ++lineCount;
            }
            int[] lineLens = new int[lineCount];
            Arrays.fill(lineLens, 60);
            lineLens[lineCount - 1] = partLine;
            char[] emptyLine = new char[80];
            for (int i = 0; i < lineLens.length; ++i) {
                this.sq.setLength(0);
                this.ub.setLength(0);
                int len = lineLens[i];
                Arrays.fill(emptyLine, ' ');
                this.sq.append(emptyLine);
                Symbol[] sa = new Symbol[len];
                System.arraycopy(syms, start + i * 60, sa, 0, len);
                String blocks = this.formatTokenBlock(this.ub, sa, 10, this.proteinTokenization).toString();
                this.sq.replace(10, blocks.length() + 10, blocks);
                String count = Integer.toString(i * 60 + 1);
                this.sq.replace(9 - count.length(), 9, count);
                this.stream.println(this.sq);
            }
            this.stream.println("//");
        }
        catch (IllegalSymbolException ex) {
            throw new IllegalAlphabetException(ex, "Protein not tokenizing");
        }
    }

    private String sequenceBufferCreator(Object key, Object value) {
        StringBuffer temp = new StringBuffer();
        if (value == null) {
            temp.append((String)key);
        } else if (value instanceof ArrayList) {
            Iterator iter = ((ArrayList)value).iterator();
            temp.append((String)key + " " + iter.next());
            while (iter.hasNext()) {
                temp.append(this.nl + "            " + iter.next());
            }
        } else {
            StringTokenizer valueToke = new StringTokenizer((String)value, " ");
            int fullline = 80;
            int length = 0;
            temp.append((String)key);
            if (valueToke.hasMoreTokens()) {
                String token = valueToke.nextToken();
                while (true) {
                    length = temp.length() % (fullline + 1) + token.length() + 1;
                    if (temp.length() % (fullline + 1) == 0) {
                        length = 81 + token.length();
                    }
                    while (length <= fullline && valueToke.hasMoreTokens()) {
                        temp.append(" " + token);
                        token = valueToke.nextToken();
                        length = temp.length() % (fullline + 1) + token.length() + 1;
                        if (temp.length() % (fullline + 1) != 0) continue;
                        length = 81 + token.length();
                    }
                    if (!valueToke.hasMoreTokens()) break;
                    for (int i = length - token.length(); i < fullline; ++i) {
                        temp.append(" ");
                    }
                    temp.append(this.nl + "           ");
                }
                if (length <= fullline) {
                    temp.append(" " + token);
                } else {
                    temp.append(this.nl);
                    temp.append("            " + token);
                }
            } else {
                temp.append(" ");
            }
        }
        return temp.toString();
    }

    private StringBuffer fixLength(StringBuffer temp, int length) {
        while (temp.length() < length) {
            temp.append(" ");
        }
        return temp;
    }

    private void locusLineCreator(int size) {
        this.idb = this.fixLength(this.idb, 30);
        this.typeb = this.fixLength(this.typeb, 8);
        this.sizeb.insert(0, size);
        while (this.sizeb.length() < 12) {
            this.sizeb.insert(0, " ");
        }
        this.sizeb.append(" aa ");
        if (this.strb.length() > 0) {
            this.strb.append("-");
        }
        this.strb = this.fixLength(this.strb, 3);
        this.circb = this.fixLength(this.circb, 9);
        this.mdatb = this.fixLength(this.mdatb, 11);
        this.divb = this.fixLength(this.divb, 4);
        this.idb.insert(29, this.sizeb);
        this.idb.insert(44, this.strb);
        this.idb.insert(47, this.typeb);
        this.idb.insert(55, this.circb);
        this.idb.insert(64, this.divb);
        this.idb.insert(68, this.mdatb);
        this.idb.setLength(79);
        System.out.println("idb length: " + this.idb.length());
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        if (key.equals("LOCUS")) {
            this.idb.setLength(0);
            this.idb.append("LOCUS       " + (String)value);
        } else if (key.equals("TYPE")) {
            this.typeb.append(value);
        } else if (key.equals("DIVISION")) {
            this.divb.append(value);
        } else if (key.equals("CIRCULAR")) {
            this.circb.append(value);
        } else if (key.equals("DT") || key.equals("MDAT")) {
            if (value instanceof ArrayList) {
                this.mdatb.append(((ArrayList)value).get(0));
            } else {
                this.mdatb.append(value);
            }
        } else if (key.equals("DE") || key.equals("DEFINITION")) {
            this.deb = new StringBuffer(this.sequenceBufferCreator("DEFINITION ", value));
        } else if (key.equals("SV") || key.equals("VERSION")) {
            if (this.svb != null) {
                this.svb.insert(11, (String)value);
            } else {
                this.svb = new StringBuffer("VERSION     " + (String)value);
            }
        } else if (key.equals("GI")) {
            if (this.svb != null) {
                this.svb.append("  GI:" + (String)value);
            } else {
                this.svb = new StringBuffer("VERSION       GI:" + (String)value);
            }
        } else if (key.equals("KW") || key.equals("KEYWORDS")) {
            this.kwb = new StringBuffer(this.sequenceBufferCreator("KEYWORDS   ", value));
        } else if (key.equals("OS") || key.equals("SOURCE")) {
            this.osb = new StringBuffer(this.sequenceBufferCreator("SOURCE     ", value));
        } else if (key.equals("OC") || key.equals("ORGANISM")) {
            this.ocb = new StringBuffer(this.sequenceBufferCreator("  ORGANISM ", value));
        } else if (key.equals("CC") || key.equals("COMMENT")) {
            this.ccb = new StringBuffer(this.sequenceBufferCreator("COMMENT    ", value));
        } else if (key.equals("genbank_accessions")) {
            ArrayList<Object> l;
            this.ub.setLength(0);
            this.ub.append("ACCESSION   ");
            if (value instanceof List) {
                l = (ArrayList<Object>)value;
            } else {
                l = new ArrayList<Object>();
                l.add(value);
            }
            Iterator ai = l.iterator();
            while (ai.hasNext()) {
                this.ub.append((String)ai.next());
            }
            this.acb = new StringBuffer(this.ub.toString());
        }
    }

    public void startFeature(Feature.Template templ) throws ParseException {
    }

    public void endFeature() throws ParseException {
    }

    public void addFeatureProperty(Object key, Object value) throws ParseException {
    }
}

