/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.SVDSuperimposer;
import org.biojava.bio.structure.StandardAminoAcid;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.jama.Matrix;

public class Calc {
    static double RADIAN = 57.29577951;

    public static double getDistance(Atom a, Atom b) throws StructureException {
        Atom c = Calc.substract(b, a);
        double dist = Calc.amount(c);
        return dist;
    }

    private static void nullCheck(Atom a) throws StructureException {
        if (a == null) {
            throw new StructureException("Atom is null!");
        }
    }

    public static Atom add(Atom a, Atom b) {
        double[] coords = new double[]{a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ()};
        AtomImpl c = new AtomImpl();
        c.setCoords(coords);
        return c;
    }

    public static Atom substract(Atom a, Atom b) throws StructureException {
        Calc.nullCheck(a);
        Calc.nullCheck(b);
        double[] coords = new double[]{a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ()};
        AtomImpl c = new AtomImpl();
        c.setCoords(coords);
        return c;
    }

    public static Atom vectorProduct(Atom a, Atom b) {
        double[] coords = new double[]{a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX()};
        AtomImpl c = new AtomImpl();
        c.setCoords(coords);
        return c;
    }

    public static double skalarProduct(Atom a, Atom b) {
        double skalar = a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
        return skalar;
    }

    public static double amount(Atom a) {
        return Math.sqrt(Calc.skalarProduct(a, a));
    }

    public static double angle(Atom a, Atom b) {
        double skalar = Calc.skalarProduct(a, b);
        double angle = skalar / (Calc.amount(a) * Calc.amount(b));
        angle = Math.acos(angle);
        return angle *= RADIAN;
    }

    public static Atom unitVector(Atom a) {
        double amount = Calc.amount(a);
        Atom U = a;
        double[] coords = new double[]{a.getX() / amount, a.getY() / amount, a.getZ() / amount};
        U.setCoords(coords);
        return U;
    }

    public static double torsionAngle(Atom a, Atom b, Atom c, Atom d) throws StructureException {
        Atom ab = Calc.substract(a, b);
        Atom cb = Calc.substract(c, b);
        Atom bc = Calc.substract(b, c);
        Atom dc = Calc.substract(d, c);
        Atom abc = Calc.vectorProduct(ab, cb);
        Atom bcd = Calc.vectorProduct(bc, dc);
        double angl = Calc.angle(abc, bcd);
        Atom vecprod = Calc.vectorProduct(abc, bcd);
        double val = Calc.skalarProduct(cb, vecprod);
        if (val < 0.0) {
            angl = -angl;
        }
        return angl;
    }

    public static double getPhi(AminoAcid a, AminoAcid b) throws StructureException {
        if (!Calc.isConnected(a, b)) {
            throw new StructureException("can not calc Phi - AminoAcids are not connected!");
        }
        Atom a_C = a.getC();
        Atom b_N = b.getN();
        Atom b_CA = b.getCA();
        Atom b_C = b.getC();
        double phi = Calc.torsionAngle(a_C, b_N, b_CA, b_C);
        return phi;
    }

    public static double getPsi(AminoAcid a, AminoAcid b) throws StructureException {
        if (!Calc.isConnected(a, b)) {
            throw new StructureException("can not calc Psi - AminoAcids are not connected!");
        }
        Atom a_N = a.getN();
        Atom a_CA = a.getCA();
        Atom a_C = a.getC();
        Atom b_N = b.getN();
        double psi = Calc.torsionAngle(a_N, a_CA, a_C, b_N);
        return psi;
    }

    public static boolean isConnected(AminoAcid a, AminoAcid b) throws StructureException {
        Atom N;
        Atom C = a.getC();
        double distance = Calc.getDistance(C, N = b.getN());
        return distance < 2.5;
    }

    public static void rotate(Atom atom, double[][] m) {
        double x = atom.getX();
        double y = atom.getY();
        double z = atom.getZ();
        double nx = m[0][0] * x + m[0][1] * y + m[0][2] * z;
        double ny = m[1][0] * x + m[1][1] * y + m[1][2] * z;
        double nz = m[2][0] * x + m[2][1] * y + m[2][2] * z;
        double[] coords = new double[]{nx, ny, nz};
        atom.setCoords(coords);
    }

    public static void rotate(Structure structure, double[][] rotationmatrix) throws StructureException {
        double[][] m = rotationmatrix;
        if (m.length != 3) {
            throw new StructureException("matrix does not have size 3x3 !");
        }
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = (Atom)iter.next();
            Calc.rotate(atom, rotationmatrix);
        }
    }

    public static void rotate(Group group, double[][] rotationmatrix) throws StructureException {
        double[][] m = rotationmatrix;
        if (m.length != 3) {
            throw new StructureException("matrix does not have size 3x3 !");
        }
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = null;
            atom = (Atom)iter.next();
            Calc.rotate(atom, rotationmatrix);
        }
    }

    public static void rotate(Atom atom, Matrix m) {
        double x = atom.getX();
        double y = atom.getY();
        double z = atom.getZ();
        double[][] ad = new double[][]{{x, y, z}};
        Matrix am = new Matrix(ad);
        Matrix na = am.times(m);
        double[] coords = new double[]{na.get(0, 0), na.get(0, 1), na.get(0, 2)};
        atom.setCoords(coords);
    }

    public static void rotate(Group group, Matrix m) {
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = (Atom)iter.next();
            Calc.rotate(atom, m);
        }
    }

    public static void rotate(Structure structure, Matrix m) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = (Atom)iter.next();
            Calc.rotate(atom, m);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plus(Structure s, Matrix matrix) {
        AtomIterator iter = new AtomIterator(s);
        Atom oldAtom = null;
        Atom rotOldAtom = null;
        while (iter.hasNext()) {
            Atom atom = null;
            atom = (Atom)iter.next();
            try {
                if (oldAtom == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            oldAtom = (Atom)atom.clone();
            double x = atom.getX();
            double y = atom.getY();
            double z = atom.getZ();
            double[][] ad = new double[][]{{x, y, z}};
            Matrix am = new Matrix(ad);
            Matrix na = am.plus(matrix);
            double[] coords = new double[]{na.get(0, 0), na.get(0, 1), na.get(0, 2)};
            atom.setCoords(coords);
            try {
                if (rotOldAtom == null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rotOldAtom = (Atom)atom.clone();
        }
        return;
    }

    public static void shift(Structure structure, Atom a) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = null;
            atom = (Atom)iter.next();
            Atom natom = Calc.add(atom, a);
            double x = natom.getX();
            double y = natom.getY();
            double z = natom.getZ();
            atom.setX(x);
            atom.setY(y);
            atom.setZ(z);
        }
    }

    public static void shift(Atom a, Atom b) {
        Atom natom = Calc.add(a, b);
        double x = natom.getX();
        double y = natom.getY();
        double z = natom.getZ();
        a.setX(x);
        a.setY(y);
        a.setZ(z);
    }

    public static void shift(Group group, Atom a) {
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = null;
            atom = (Atom)iter.next();
            Atom natom = Calc.add(atom, a);
            double x = natom.getX();
            double y = natom.getY();
            double z = natom.getZ();
            atom.setX(x);
            atom.setY(y);
            atom.setZ(z);
        }
    }

    public static Atom getCentroid(Atom[] atomSet) {
        double[] coords = new double[]{0.0, 0.0, 0.0};
        for (int i = 0; i < atomSet.length; ++i) {
            Atom a = atomSet[i];
            coords[0] = coords[0] + a.getX();
            coords[1] = coords[1] + a.getY();
            coords[2] = coords[2] + a.getZ();
        }
        int n = atomSet.length;
        coords[0] = coords[0] / (double)n;
        coords[1] = coords[1] / (double)n;
        coords[2] = coords[2] / (double)n;
        AtomImpl vec = new AtomImpl();
        vec.setCoords(coords);
        return vec;
    }

    public static Atom getCenterVector(Atom[] atomSet) {
        Atom centroid = Calc.getCentroid(atomSet);
        double[] coords = new double[]{0.0 - centroid.getX(), 0.0 - centroid.getY(), 0.0 - centroid.getZ()};
        AtomImpl shiftVec = new AtomImpl();
        shiftVec.setCoords(coords);
        return shiftVec;
    }

    public static Atom[] centerAtoms(Atom[] atomSet) throws StructureException {
        Atom shiftVector = Calc.getCenterVector(atomSet);
        Atom[] newAtoms = new AtomImpl[atomSet.length];
        for (int i = 0; i < atomSet.length; ++i) {
            Atom n;
            Atom a = atomSet[i];
            newAtoms[i] = n = Calc.add(a, shiftVector);
        }
        return newAtoms;
    }

    public static Atom createVirtualCBAtom(AminoAcid amino) throws StructureException {
        AminoAcid ala = StandardAminoAcid.getAminoAcid("ALA");
        Atom aN = ala.getN();
        Atom aCA = ala.getCA();
        Atom aC = ala.getC();
        Atom aCB = ala.getCB();
        Atom[] arr1 = new Atom[]{aN, aCA, aC};
        Atom[] arr2 = new Atom[]{amino.getN(), amino.getCA(), amino.getC()};
        SVDSuperimposer svd = new SVDSuperimposer(arr2, arr1);
        Matrix rotMatrix = svd.getRotation();
        Atom tranMatrix = svd.getTranslation();
        Calc.rotate(aCB, rotMatrix);
        Atom virtualCB = Calc.add(aCB, tranMatrix);
        virtualCB.setName("CB");
        virtualCB.setFullName(" CB ");
        return virtualCB;
    }
}

