/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;

public class GroupIterator
implements Iterator {
    Structure structure;
    int current_model_pos;
    int current_chain_pos;
    int current_group_pos;

    public GroupIterator(Structure struct) {
        this.structure = struct;
        this.current_model_pos = 0;
        this.current_chain_pos = 0;
        this.current_group_pos = -1;
    }

    private Structure getStructure() {
        return this.structure;
    }

    private int getModelPos() {
        return this.current_model_pos;
    }

    private void setModelPos(int pos) {
        this.current_model_pos = pos;
    }

    private int getChainPos() {
        return this.current_chain_pos;
    }

    private void setChainPos(int pos) {
        this.current_chain_pos = pos;
    }

    private int getGroupPos() {
        return this.current_group_pos;
    }

    private void setGroupPos(int pos) {
        this.current_group_pos = pos;
    }

    public Object clone() {
        GroupIterator gr = new GroupIterator(this.getStructure());
        gr.setModelPos(this.getModelPos());
        gr.setChainPos(this.getChainPos());
        gr.setGroupPos(this.getGroupPos());
        return gr;
    }

    public boolean hasNext() {
        return this.hasSubGroup(this.current_model_pos, this.current_chain_pos, this.current_group_pos + 1);
    }

    private boolean hasSubGroup(int tmp_model, int tmp_chain, int tmp_group) {
        if (tmp_model >= this.structure.nrModels()) {
            return false;
        }
        List model = this.structure.getModel(tmp_model);
        if (tmp_chain >= model.size()) {
            return this.hasSubGroup(tmp_model + 1, 0, 0);
        }
        Chain chain = (Chain)model.get(tmp_chain);
        if (tmp_group >= chain.getLength()) {
            return this.hasSubGroup(tmp_model, tmp_chain + 1, 0);
        }
        return true;
    }

    public Chain getCurrentChain() {
        if (this.current_model_pos >= this.structure.nrModels()) {
            return null;
        }
        List model = this.structure.getModel(this.current_model_pos);
        if (this.current_chain_pos >= model.size()) {
            return null;
        }
        Chain chain = (Chain)model.get(this.current_chain_pos);
        return chain;
    }

    public Object next() throws NoSuchElementException {
        return this.getNextGroup(this.current_model_pos, this.current_chain_pos, this.current_group_pos + 1);
    }

    private Group getNextGroup(int tmp_model, int tmp_chain, int tmp_group) throws NoSuchElementException {
        if (tmp_model >= this.structure.nrModels()) {
            throw new NoSuchElementException("arrived at end of structure!");
        }
        List model = this.structure.getModel(tmp_model);
        if (tmp_chain >= model.size()) {
            return this.getNextGroup(tmp_model + 1, 0, 0);
        }
        Chain chain = (Chain)model.get(tmp_chain);
        if (tmp_group >= chain.getLength()) {
            return this.getNextGroup(tmp_model, tmp_chain + 1, 0);
        }
        this.current_model_pos = tmp_model;
        this.current_chain_pos = tmp_chain;
        this.current_group_pos = tmp_group;
        Group group = chain.getGroup(this.current_group_pos);
        return group;
    }

    public void remove() {
    }
}

