/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBParseException;

public class HetatomImpl
implements Group {
    public static String type = "hetatm";
    HashMap properties;
    boolean pdb_flag = false;
    String pdb_name = null;
    String pdb_code = null;
    ArrayList atoms = new ArrayList();
    Chain parent = null;

    public HetatomImpl() {
        this.properties = new HashMap();
    }

    public boolean has3D() {
        return this.pdb_flag;
    }

    public void setPDBFlag(boolean flag) {
        this.pdb_flag = flag;
    }

    public String getPDBCode() {
        return this.pdb_code;
    }

    public void setPDBCode(String pdb) {
        this.pdb_code = pdb;
    }

    public void setPDBName(String s) throws PDBParseException {
        this.pdb_name = s;
    }

    public String getPDBName() {
        return this.pdb_name;
    }

    public void addAtom(Atom atom) {
        atom.setParent(this);
        this.atoms.add(atom);
        if (atom.getCoords() != null) {
            this.setPDBFlag(true);
        }
    }

    public void clearAtoms() {
        this.atoms.clear();
        this.setPDBFlag(false);
    }

    public int size() {
        return this.atoms.size();
    }

    public List getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(String name) throws StructureException {
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            if (!atom.getName().equals(name)) continue;
            return atom;
        }
        throw new StructureException(" No atom " + name + " in group " + this.pdb_name + " " + this.pdb_code + " !");
    }

    public Atom getAtom(int position) throws StructureException {
        if (position < 0 || position >= this.atoms.size()) {
            throw new StructureException("No atom found at position " + position);
        }
        Atom a = (Atom)this.atoms.get(position);
        return a;
    }

    public boolean hasAtom(String name) {
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            if (!atom.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return type;
    }

    public String toString() {
        String str = "PDB: " + this.pdb_name + " " + this.pdb_code + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + "atoms: " + this.atoms.size();
        }
        return str;
    }

    public boolean hasAminoAtoms() {
        String[] atoms = this.getType().equals("amino") & this.getPDBName().equals("GLY") ? new String[]{"N", "CA", "C", "O"} : new String[]{"N", "CA", "C", "O", "CB"};
        for (int i = 0; i < atoms.length; ++i) {
            if (this.hasAtom(atoms[i])) continue;
            return false;
        }
        return true;
    }

    public void setProperties(Map props) {
        this.properties = (HashMap)props;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Iterator iterator() {
        AtomIterator iter = new AtomIterator(this);
        return iter;
    }

    public Object clone() {
        HetatomImpl n = new HetatomImpl();
        n.setPDBFlag(this.has3D());
        n.setPDBCode(this.getPDBCode());
        try {
            n.setPDBName(this.getPDBName());
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            n.addAtom((Atom)atom.clone());
        }
        return n;
    }

    public void setParent(Chain parent) {
        this.parent = parent;
    }

    public Chain getParent() {
        return this.parent;
    }
}

