/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.biojava.utils.io.UncompressInputStream;

public class InputStreamProvider {
    public static final int GZIP_MAGIC = 8075;

    public InputStream getInputStream(String pathToFile) throws IOException {
        File f = new File(pathToFile);
        return this.getInputStream(f);
    }

    private int getMagicNumber(InputStream in) throws IOException {
        int t = in.read();
        if (t < 0) {
            throw new EOFException("Failed to read magic number");
        }
        int magic = (t & 0xFF) << 8;
        t = in.read();
        if (t < 0) {
            throw new EOFException("Failed to read magic number");
        }
        return magic += t & 0xFF;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getInputStream(File f) throws IOException {
        void var3_10;
        int magic = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(f);
            magic = this.getMagicNumber(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object var3_6 = null;
        String fileName = f.getName();
        if (magic == 8093) {
            return this.openCompressedFile(f);
        }
        if (magic == 8075) {
            return this.openGZIPFile(f);
        }
        if (fileName.endsWith(".gz")) {
            return this.openGZIPFile(f);
        }
        if (fileName.endsWith(".zip")) {
            ZipFile zipfile = new ZipFile(f);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            if (!e.hasMoreElements()) throw new IOException("Zip file has no entries");
            ZipEntry entry = e.nextElement();
            InputStream inputStream = zipfile.getInputStream(entry);
            return var3_10;
        } else if (fileName.endsWith(".jar")) {
            JarFile jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            if (!e.hasMoreElements()) throw new IOException("Jar file has no entries");
            JarEntry entry = e.nextElement();
            InputStream inputStream = jarFile.getInputStream(entry);
            return var3_10;
        } else {
            if (fileName.endsWith(".Z")) {
                return this.openCompressedFile(f);
            }
            FileInputStream fileInputStream = new FileInputStream(f);
        }
        return var3_10;
    }

    private InputStream openCompressedFile(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        UncompressInputStream inputStream = new UncompressInputStream(is);
        return inputStream;
    }

    private InputStream openGZIPFile(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        GZIPInputStream inputStream = new GZIPInputStream(is);
        return inputStream;
    }
}

