/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.process;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.biojava.utils.SimpleThreadPool;
import org.biojava.utils.ThreadPool;
import org.biojava.utils.process.InputHandler;
import org.biojava.utils.process.OutputHandler;
import org.biojava.utils.process.ReaderInputHandler;
import org.biojava.utils.process.SimpleInputHandler;
import org.biojava.utils.process.SimpleOutputHandler;
import org.biojava.utils.process.WriterOutputHandler;

public final class ExternalProcess {
    public static final int THREAD_POOL_SIZE = 9;
    public static final int SLEEP_TIME = 10;
    private static final ThreadPool THREAD_POOL = new SimpleThreadPool(9, true);
    private static final Logger LOGGER = Logger.getLogger(ExternalProcess.class.getName());
    private String commands = null;
    private File workingDirectory = null;
    private String[] environmentProperties = null;
    private InputHandler inputHandler = null;
    private OutputHandler outputHandler = null;
    private OutputHandler errorHandler = null;
    private ThreadPool threadPool = null;
    private boolean stopThreads = true;
    private int sleepTime = 10;

    public static void main(String[] args) {
        try {
            System.exit(ExternalProcess.execute(ExternalProcess.joinCommands(args)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String resolveCommands(String commands, Properties variables) throws NullPointerException {
        if (commands == null) {
            throw new NullPointerException("commands is null.");
        }
        if (variables != null && !variables.isEmpty()) {
            Enumeration<Object> keys = variables.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = variables.getProperty(key);
                commands = commands.replaceAll("%" + key + "%", value);
            }
        }
        return commands;
    }

    public static int execute(String commands) throws IOException, InterruptedException, NullPointerException, SecurityException, IllegalArgumentException {
        return ExternalProcess.execute(commands, null, null, null);
    }

    public static int execute(String commands, String inputString, StringWriter outputString, StringWriter errorString) throws IOException, InterruptedException, NullPointerException, SecurityException, IllegalArgumentException {
        ExternalProcess ep = new ExternalProcess(THREAD_POOL);
        ep.setCommands(commands);
        if (inputString != null) {
            ep.setInputHandler(new ReaderInputHandler(new StringReader(inputString), "STDIN"));
        }
        if (outputString != null) {
            ep.setOutputHandler(new WriterOutputHandler(outputString, "STDOUT"));
        }
        if (errorString != null) {
            ep.setErrorHandler(new WriterOutputHandler(errorString, "STDERR"));
        }
        return ep.execute();
    }

    public static String joinCommands(Object[] commandList) throws NullPointerException {
        if (commandList == null) {
            throw new NullPointerException("commandList is null.");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < commandList.length; ++i) {
            if (i == commandList.length - 1) {
                sb.append(commandList[i].toString());
                continue;
            }
            sb.append(commandList[i].toString() + " ");
        }
        return sb.toString();
    }

    public ExternalProcess() {
        this(null);
    }

    public ExternalProcess(ThreadPool threadPool) {
        if (threadPool == null) {
            this.threadPool = new SimpleThreadPool(3, true);
            this.stopThreads = true;
        } else {
            this.threadPool = threadPool;
            this.stopThreads = false;
        }
        this.setEnvironmentProperties(null);
        this.setWorkingDirectory(null);
        this.setInputHandler(null);
        this.setOutputHandler(null);
        this.setErrorHandler(null);
    }

    public int execute() throws IOException, InterruptedException, SecurityException, IllegalArgumentException {
        return this.execute(null);
    }

    public int execute(Properties variables) throws IOException, InterruptedException, SecurityException, IllegalArgumentException {
        Runtime runtime = Runtime.getRuntime();
        String commands = ExternalProcess.resolveCommands(this.commands, variables);
        Process process = runtime.exec(commands, this.environmentProperties, this.workingDirectory);
        OutputStream in = process.getOutputStream();
        InputStream out = process.getInputStream();
        InputStream err = process.getErrorStream();
        this.inputHandler.setOutput(in);
        this.outputHandler.setInput(out);
        this.errorHandler.setInput(err);
        this.threadPool.addRequest(this.inputHandler);
        this.threadPool.addRequest(this.outputHandler);
        this.threadPool.addRequest(this.errorHandler);
        Thread.yield();
        int exitCode = process.waitFor();
        Thread.sleep(this.sleepTime);
        in.close();
        out.close();
        err.close();
        return exitCode;
    }

    public String getCommands() {
        return this.commands;
    }

    public void setCommands(String commands) throws NullPointerException {
        if (commands == null) {
            throw new NullPointerException("commands is null.");
        }
        this.commands = commands;
    }

    public String[] getEnvironmentProperties() {
        String[] environmentProperties = null;
        if (this.environmentProperties != null) {
            environmentProperties = (String[])this.environmentProperties.clone();
        }
        return environmentProperties;
    }

    public void setEnvironmentProperties(String[] environmentProperties) {
        this.environmentProperties = environmentProperties == null ? null : (String[])environmentProperties.clone();
    }

    public OutputHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(OutputHandler errorHandler) {
        this.errorHandler = errorHandler == null ? new SimpleOutputHandler(System.err, "STDERR") : errorHandler;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler == null ? new SimpleInputHandler(System.in, "STDINS") : inputHandler;
    }

    public OutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler == null ? new SimpleOutputHandler(System.out, "STDOUT") : outputHandler;
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) throws IllegalArgumentException {
        if ((double)sleepTime < 0.0) {
            throw new IllegalArgumentException("sleepTime must be zero or positive.");
        }
        this.sleepTime = sleepTime;
    }

    protected void finalize() {
        if (this.stopThreads) {
            this.threadPool.stopThreads();
        }
    }
}

