/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.Changeable;
import org.biojavax.SimpleDocRefAuthor;

public interface DocRefAuthor
extends Comparable,
Changeable {
    public String getName();

    public String getExtendedName();

    public boolean isEditor();

    public boolean isConsortium();

    public static class Tools {
        private Tools() {
        }

        public static List parseAuthorString(String authors) {
            if (authors == null) {
                throw new IllegalArgumentException("Authors string cannot be null");
            }
            String[] parts = authors.split("(,|\\sand)\\s+");
            ArrayList<SimpleDocRefAuthor> authSet = new ArrayList<SimpleDocRefAuthor>();
            for (int i = 0; i < parts.length; ++i) {
                authSet.add(new SimpleDocRefAuthor(parts[i]));
            }
            return authSet;
        }

        public static String generateAuthorString(List authors) {
            StringBuffer sb = new StringBuffer();
            int authCount = 1;
            Iterator i = authors.iterator();
            while (i.hasNext()) {
                DocRefAuthor a = (DocRefAuthor)i.next();
                sb.append(a.getExtendedName());
                if (!i.hasNext()) continue;
                if (authCount++ == authors.size() - 1) {
                    sb.append(" and ");
                    continue;
                }
                sb.append(", ");
            }
            return sb.toString();
        }
    }
}

