/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import org.biojava.utils.Unchangeable;
import org.biojavax.DocRefAuthor;

public class SimpleDocRefAuthor
extends Unchangeable
implements DocRefAuthor {
    private String name;
    private boolean editor;
    private boolean consortium;

    public SimpleDocRefAuthor(String name, boolean consortium, boolean editor) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.editor = editor;
        this.consortium = consortium;
    }

    public SimpleDocRefAuthor(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String[] parts = s.split("\\(");
        this.name = parts[0].trim();
        if (parts.length == 3) {
            parts[1] = parts[1].trim();
            parts[2] = parts[2].trim();
            parts[1] = parts[1].substring(0, parts[1].length() - 1);
            parts[2] = parts[2].substring(0, parts[2].length() - 1);
            this.editor = parts[1].equals("ed.") || parts[2].equals("ed.");
            this.consortium = parts[1].equals("consortium") || parts[2].equals("consortium");
        } else if (parts.length == 2) {
            parts[1] = parts[1].trim();
            parts[1] = parts[1].substring(0, parts[1].length() - 1);
            this.editor = parts[1].equals("ed.");
            this.consortium = parts[1].equals("consortium");
        } else {
            this.editor = false;
            this.consortium = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getExtendedName() {
        StringBuffer result = new StringBuffer();
        result.append(this.name);
        if (this.consortium) {
            result.append(" (consortium)");
        }
        if (this.editor) {
            result.append(" (ed.)");
        }
        return result.toString();
    }

    public boolean isEditor() {
        return this.editor;
    }

    public boolean isConsortium() {
        return this.consortium;
    }

    public int compareTo(Object o) {
        DocRefAuthor them = (DocRefAuthor)o;
        if (!this.name.equals(them.getName())) {
            return this.name.compareTo(them.getName());
        }
        if (this.consortium != them.isConsortium()) {
            return this.consortium ? -1 : 1;
        }
        if (this.editor != them.isEditor()) {
            return this.editor ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DocRefAuthor)) {
            return false;
        }
        DocRefAuthor them = (DocRefAuthor)obj;
        return this.name.equals(them.getName()) && this.consortium == them.isConsortium() && this.editor == them.isEditor();
    }

    public int hashCode() {
        int code = 17;
        code = 37 * code + this.name.hashCode();
        code = 37 * code + (this.consortium ? 1 : 0);
        code = 37 * code + (this.editor ? 1 : 0);
        return code;
    }

    public String toString() {
        return this.getExtendedName();
    }
}

