/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.net.URI;
import java.net.URISyntaxException;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Namespace;

public class SimpleNamespace
extends AbstractChangeable
implements Namespace {
    private String name;
    private String acronym;
    private String authority;
    private String description;
    private URI URI;
    private Integer id;

    public SimpleNamespace(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.acronym = null;
        this.authority = null;
        this.description = null;
        this.URI = null;
    }

    protected SimpleNamespace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcronym(String acronym) throws ChangeVetoException {
        if (!this.hasListeners(Namespace.ACRONYM)) {
            this.acronym = acronym;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Namespace.ACRONYM, acronym, this.acronym);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Namespace.ACRONYM);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.acronym = acronym;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthority(String authority) throws ChangeVetoException {
        if (!this.hasListeners(Namespace.AUTHORITY)) {
            this.authority = authority;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Namespace.AUTHORITY, authority, this.authority);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Namespace.AUTHORITY);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.authority = authority;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) throws ChangeVetoException {
        if (!this.hasListeners(Namespace.DESCRIPTION)) {
            this.description = description;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Namespace.DESCRIPTION, description, this.description);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Namespace.DESCRIPTION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.description = description;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    private void setURIString(String URI2) throws ChangeVetoException, URISyntaxException {
        if (URI2 != null) {
            this.setURI(new URI(URI2));
        } else {
            this.URI = null;
        }
    }

    private String getURIString() {
        if (this.URI == null) {
            return null;
        }
        return this.URI.toASCIIString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURI(URI URI2) throws ChangeVetoException {
        if (!this.hasListeners(Namespace.URI)) {
            this.URI = URI2;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Namespace.URI, URI2, this.URI);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Namespace.URI);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.URI = URI2;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.URI;
    }

    public int compareTo(Object o) {
        if (this.name == null) {
            return -1;
        }
        Namespace them = (Namespace)o;
        return this.name.compareTo(them.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Namespace)) {
            return false;
        }
        if (this.name == null) {
            return false;
        }
        Namespace them = (Namespace)obj;
        return this.name.equals(them.getName());
    }

    public int hashCode() {
        int hash = 17;
        if (this.name == null) {
            return hash;
        }
        return 31 * hash + this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }
}

