/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import org.biojava.utils.Unchangeable;
import org.biojavax.CrossRef;
import org.biojavax.RankedCrossRef;

public class SimpleRankedCrossRef
extends Unchangeable
implements RankedCrossRef {
    private CrossRef crossref;
    private int rank;

    public SimpleRankedCrossRef(CrossRef crossref, int rank) {
        if (crossref == null) {
            throw new IllegalArgumentException("Cross reference cannot be null");
        }
        this.crossref = crossref;
        this.rank = rank;
    }

    protected SimpleRankedCrossRef() {
    }

    private void setCrossRef(CrossRef crossref) {
        this.crossref = crossref;
    }

    public CrossRef getCrossRef() {
        return this.crossref;
    }

    private void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RankedCrossRef)) {
            return false;
        }
        if (this.crossref == null) {
            return false;
        }
        RankedCrossRef them = (RankedCrossRef)obj;
        return this.rank == them.getRank() && this.crossref.equals(them.getCrossRef());
    }

    public int compareTo(Object o) {
        if (this.crossref == null) {
            return -1;
        }
        RankedCrossRef them = (RankedCrossRef)o;
        if (this.rank != them.getRank()) {
            return this.rank - them.getRank();
        }
        return this.crossref.compareTo(them.getCrossRef());
    }

    public int hashCode() {
        int code = 17;
        if (this.crossref == null) {
            return code;
        }
        code = 37 * code + this.crossref.hashCode();
        code = 37 * code + this.rank;
        return code;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.crossref;
    }
}

